/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.uaa.spi;

import feign.FeignException;
import io.dialob.security.uaa.spi.UaaClient;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class UaaServiceBase {
    private final UaaClient uaaClient;

    public UaaServiceBase(UaaClient uaaClient) {
        this.uaaClient = uaaClient;
    }

    protected UaaClient getUaaClient() {
        return this.uaaClient;
    }

    protected <T> Optional<T> get(Function<UaaClient, T> op) {
        try {
            return Optional.of(op.apply(this.getUaaClient()));
        }
        catch (FeignException.NotFound notFound) {
            return Optional.empty();
        }
    }

    protected <T> List<T> list(Function<UaaClient, List<T>> op) {
        try {
            return op.apply(this.getUaaClient());
        }
        catch (FeignException.NotFound notFound) {
            return Collections.emptyList();
        }
    }
}

