/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.uaa;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import io.dialob.security.spring.oauth2.Groups2GrantedAuthorisations;
import io.dialob.security.spring.oauth2.OAuth2AuthenticationInterceptor;
import io.dialob.security.spring.oauth2.StreamingGrantedAuthoritiesMapper;
import io.dialob.security.spring.oauth2.UaaGroups2GroupGrantedAuthoritiesMapper;
import io.dialob.security.spring.oauth2.UsersAndGroupsService;
import io.dialob.security.spring.tenant.GrantedTenantAccessEvaluator;
import io.dialob.security.spring.tenant.MapTenantGroupToTenantGrantedAuthority;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.security.uaa.spi.UaaClient;
import io.dialob.security.uaa.spi.UaaUsersAndGroupsService;
import io.dialob.settings.DialobSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;

@Configuration(proxyBeanMethods=false)
@Profile(value={"uaa"})
public class DialobSecurityUaaAutoConfiguration {
    @Bean
    public UaaClient uaaClient(DialobSettings settings) {
        ObjectMapper objectMapper = new ObjectMapper().registerModules(new Module[]{new JavaTimeModule(), new Jdk8Module()});
        return (UaaClient)Feign.builder().encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor((RequestInterceptor)new OAuth2AuthenticationInterceptor(settings.getUaa().getUrl(), settings.getUaa().getClientId(), settings.getUaa().getClientSecret())).logger((Logger)new Slf4jLogger(DialobSecurityUaaAutoConfiguration.class)).target(UaaClient.class, settings.getUaa().getUrl());
    }

    @Bean
    public UsersAndGroupsService usersAndGroupsService(UaaClient uaaClient) {
        return new UaaUsersAndGroupsService(uaaClient);
    }

    @Bean
    public GrantedAuthoritiesMapper grantedAuthoritiesMapper(DialobSettings dialobSettings, Optional<UsersAndGroupsService> usersAndGroupsService) {
        ArrayList<Object> operators = new ArrayList<Object>();
        Map groupPermissions = dialobSettings.getSecurity().getGroupPermissions();
        operators.add(new Groups2GrantedAuthorisations(group -> groupPermissions.getOrDefault(group, Collections.emptySet())));
        operators.add(new MapTenantGroupToTenantGrantedAuthority(dialobSettings.getTenant().getEnv()));
        usersAndGroupsService.ifPresent(service -> operators.add(new UaaGroups2GroupGrantedAuthoritiesMapper(service)));
        return new StreamingGrantedAuthoritiesMapper(operators);
    }

    @Bean
    public TenantAccessEvaluator tenantAccessEvaluator() {
        return new GrantedTenantAccessEvaluator(){

            protected boolean canAccessAnyTenant(AbstractAuthenticationToken authentication) {
                return authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("tenant.all"));
            }
        };
    }
}

