package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UaaUserList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUaaUserList.builder()}.
 */
@Generated(from = "UaaUserList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableUaaUserList implements UaaUserList {
  private final List<UaaUser> resources;
  private final Integer startIndex;
  private final Integer itemsPerPage;
  private final Integer totalResults;
  private final List<String> schemas;

  private ImmutableUaaUserList(
      List<UaaUser> resources,
      Integer startIndex,
      Integer itemsPerPage,
      Integer totalResults,
      List<String> schemas) {
    this.resources = resources;
    this.startIndex = startIndex;
    this.itemsPerPage = itemsPerPage;
    this.totalResults = totalResults;
    this.schemas = schemas;
  }

  /**
   * @return The value of the {@code resources} attribute
   */
  @JsonProperty("resources")
  @Override
  public List<UaaUser> getResources() {
    return resources;
  }

  /**
   * @return The value of the {@code startIndex} attribute
   */
  @JsonProperty("startIndex")
  @Override
  public Integer getStartIndex() {
    return startIndex;
  }

  /**
   * @return The value of the {@code itemsPerPage} attribute
   */
  @JsonProperty("itemsPerPage")
  @Override
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * @return The value of the {@code totalResults} attribute
   */
  @JsonProperty("totalResults")
  @Override
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * @return The value of the {@code schemas} attribute
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUserList#getResources() resources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUserList withResources(UaaUser... elements) {
    List<UaaUser> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUserList(newValue, this.startIndex, this.itemsPerPage, this.totalResults, this.schemas);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUserList#getResources() resources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of resources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUserList withResources(Iterable<? extends UaaUser> elements) {
    if (this.resources == elements) return this;
    List<UaaUser> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUserList(newValue, this.startIndex, this.itemsPerPage, this.totalResults, this.schemas);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUserList#getStartIndex() startIndex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUserList withStartIndex(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "startIndex");
    if (this.startIndex.equals(newValue)) return this;
    return new ImmutableUaaUserList(this.resources, newValue, this.itemsPerPage, this.totalResults, this.schemas);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUserList#getItemsPerPage() itemsPerPage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for itemsPerPage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUserList withItemsPerPage(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "itemsPerPage");
    if (this.itemsPerPage.equals(newValue)) return this;
    return new ImmutableUaaUserList(this.resources, this.startIndex, newValue, this.totalResults, this.schemas);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUserList#getTotalResults() totalResults} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalResults
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUserList withTotalResults(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "totalResults");
    if (this.totalResults.equals(newValue)) return this;
    return new ImmutableUaaUserList(this.resources, this.startIndex, this.itemsPerPage, newValue, this.schemas);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUserList#getSchemas() schemas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUserList withSchemas(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUserList(this.resources, this.startIndex, this.itemsPerPage, this.totalResults, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUserList#getSchemas() schemas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schemas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUserList withSchemas(Iterable<String> elements) {
    if (this.schemas == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUserList(this.resources, this.startIndex, this.itemsPerPage, this.totalResults, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUaaUserList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUaaUserList
        && equalTo((ImmutableUaaUserList) another);
  }

  private boolean equalTo(ImmutableUaaUserList another) {
    return resources.equals(another.resources)
        && startIndex.equals(another.startIndex)
        && itemsPerPage.equals(another.itemsPerPage)
        && totalResults.equals(another.totalResults)
        && schemas.equals(another.schemas);
  }

  /**
   * Computes a hash code from attributes: {@code resources}, {@code startIndex}, {@code itemsPerPage}, {@code totalResults}, {@code schemas}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + resources.hashCode();
    h += (h << 5) + startIndex.hashCode();
    h += (h << 5) + itemsPerPage.hashCode();
    h += (h << 5) + totalResults.hashCode();
    h += (h << 5) + schemas.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UaaUserList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UaaUserList{"
        + "resources=" + resources
        + ", startIndex=" + startIndex
        + ", itemsPerPage=" + itemsPerPage
        + ", totalResults=" + totalResults
        + ", schemas=" + schemas
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UaaUserList", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UaaUserList {
    @Nullable List<UaaUser> resources = Collections.emptyList();
    @Nullable Integer startIndex;
    @Nullable Integer itemsPerPage;
    @Nullable Integer totalResults;
    @Nullable List<String> schemas = Collections.emptyList();
    @JsonProperty("resources")
    public void setResources(List<UaaUser> resources) {
      this.resources = resources;
    }
    @JsonProperty("startIndex")
    public void setStartIndex(Integer startIndex) {
      this.startIndex = startIndex;
    }
    @JsonProperty("itemsPerPage")
    public void setItemsPerPage(Integer itemsPerPage) {
      this.itemsPerPage = itemsPerPage;
    }
    @JsonProperty("totalResults")
    public void setTotalResults(Integer totalResults) {
      this.totalResults = totalResults;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @Override
    public List<UaaUser> getResources() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStartIndex() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getItemsPerPage() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalResults() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUaaUserList fromJson(Json json) {
    ImmutableUaaUserList.Builder builder = ImmutableUaaUserList.builder();
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    if (json.startIndex != null) {
      builder.startIndex(json.startIndex);
    }
    if (json.itemsPerPage != null) {
      builder.itemsPerPage(json.itemsPerPage);
    }
    if (json.totalResults != null) {
      builder.totalResults(json.totalResults);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UaaUserList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UaaUserList instance
   */
  public static ImmutableUaaUserList copyOf(UaaUserList instance) {
    if (instance instanceof ImmutableUaaUserList) {
      return (ImmutableUaaUserList) instance;
    }
    return ImmutableUaaUserList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUaaUserList ImmutableUaaUserList}.
   * <pre>
   * ImmutableUaaUserList.builder()
   *    .addResources|addAllResources(io.dialob.security.uaa.spi.model.UaaUser) // {@link UaaUserList#getResources() resources} elements
   *    .startIndex(Integer) // required {@link UaaUserList#getStartIndex() startIndex}
   *    .itemsPerPage(Integer) // required {@link UaaUserList#getItemsPerPage() itemsPerPage}
   *    .totalResults(Integer) // required {@link UaaUserList#getTotalResults() totalResults}
   *    .addSchemas|addAllSchemas(String) // {@link UaaUserList#getSchemas() schemas} elements
   *    .build();
   * </pre>
   * @return A new ImmutableUaaUserList builder
   */
  public static ImmutableUaaUserList.Builder builder() {
    return new ImmutableUaaUserList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUaaUserList ImmutableUaaUserList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UaaUserList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_START_INDEX = 0x1L;
    private static final long INIT_BIT_ITEMS_PER_PAGE = 0x2L;
    private static final long INIT_BIT_TOTAL_RESULTS = 0x4L;
    private long initBits = 0x7L;

    private List<UaaUser> resources = new ArrayList<UaaUser>();
    private @Nullable Integer startIndex;
    private @Nullable Integer itemsPerPage;
    private @Nullable Integer totalResults;
    private List<String> schemas = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UaaUserList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaUserList instance) {
      Objects.requireNonNull(instance, "instance");
      addAllResources(instance.getResources());
      startIndex(instance.getStartIndex());
      itemsPerPage(instance.getItemsPerPage());
      totalResults(instance.getTotalResults());
      addAllSchemas(instance.getSchemas());
      return this;
    }

    /**
     * Adds one element to {@link UaaUserList#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResources(UaaUser element) {
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUserList#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResources(UaaUser... elements) {
      for (UaaUser element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUserList#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(Iterable<? extends UaaUser> elements) {
      this.resources.clear();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link UaaUserList#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends UaaUser> elements) {
      for (UaaUser element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUserList#getStartIndex() startIndex} attribute.
     * @param startIndex The value for startIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("startIndex")
    public final Builder startIndex(Integer startIndex) {
      this.startIndex = Objects.requireNonNull(startIndex, "startIndex");
      initBits &= ~INIT_BIT_START_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUserList#getItemsPerPage() itemsPerPage} attribute.
     * @param itemsPerPage The value for itemsPerPage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("itemsPerPage")
    public final Builder itemsPerPage(Integer itemsPerPage) {
      this.itemsPerPage = Objects.requireNonNull(itemsPerPage, "itemsPerPage");
      initBits &= ~INIT_BIT_ITEMS_PER_PAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUserList#getTotalResults() totalResults} attribute.
     * @param totalResults The value for totalResults 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("totalResults")
    public final Builder totalResults(Integer totalResults) {
      this.totalResults = Objects.requireNonNull(totalResults, "totalResults");
      initBits &= ~INIT_BIT_TOTAL_RESULTS;
      return this;
    }

    /**
     * Adds one element to {@link UaaUserList#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUserList#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUserList#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link UaaUserList#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableUaaUserList ImmutableUaaUserList}.
     * @return An immutable instance of UaaUserList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUaaUserList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUaaUserList(
          createUnmodifiableList(true, resources),
          startIndex,
          itemsPerPage,
          totalResults,
          createUnmodifiableList(true, schemas));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START_INDEX) != 0) attributes.add("startIndex");
      if ((initBits & INIT_BIT_ITEMS_PER_PAGE) != 0) attributes.add("itemsPerPage");
      if ((initBits & INIT_BIT_TOTAL_RESULTS) != 0) attributes.add("totalResults");
      return "Cannot build UaaUserList, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
