/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.aws;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.dialob.security.aws.elb.ElbJWKSource;
import io.dialob.security.spring.oauth2.Groups2GrantedAuthorisations;
import io.dialob.security.spring.oauth2.StreamingGrantedAuthoritiesMapper;
import io.dialob.security.spring.oauth2.UaaGroups2GroupGrantedAuthoritiesMapper;
import io.dialob.security.spring.oauth2.UsersAndGroupsService;
import io.dialob.security.spring.tenant.GrantedTenantAccessEvaluator;
import io.dialob.security.spring.tenant.MapTenantGroupToTenantGrantedAuthority;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;

@Configuration(proxyBeanMethods=false)
@Profile(value={"aws"})
public class DialobSecurityAwsAutoConfiguration {
    @Bean
    public GrantedAuthoritiesMapper grantedAuthoritiesMapper(DialobSettings dialobSettings, Optional<UsersAndGroupsService> usersAndGroupsService) {
        ArrayList<Object> operators = new ArrayList<Object>();
        Map groupPermissions = dialobSettings.getSecurity().getGroupPermissions();
        operators.add(new Groups2GrantedAuthorisations(group -> groupPermissions.getOrDefault(group, Collections.emptySet())));
        operators.add(new MapTenantGroupToTenantGrantedAuthority(dialobSettings.getTenant().getEnv()));
        usersAndGroupsService.ifPresent(service -> operators.add(new UaaGroups2GroupGrantedAuthoritiesMapper(service)));
        return new StreamingGrantedAuthoritiesMapper(operators);
    }

    @Bean
    public TenantAccessEvaluator tenantAccessEvaluator() {
        return new GrantedTenantAccessEvaluator(){

            protected boolean canAccessAnyTenant(AbstractAuthenticationToken authentication) {
                return authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("tenant.all"));
            }
        };
    }

    @Bean
    public <C extends SecurityContext> JWTProcessor<C> awsElbJwtProcessor(DialobSettings settings, Optional<JWKSource<C>> jwkSource) {
        JWKSource keySource = jwkSource.orElseGet(() -> {
            String url = "https://public-keys.auth.elb." + settings.getAws().getRegion() + ".amazonaws.com/{kid}";
            DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(5000, 5000);
            return new ElbJWKSource(url, (ResourceRetriever)resourceRetriever);
        });
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(settings.getAws().getElb().getAlgorithms().stream().map(JWSAlgorithm::parse).collect(Collectors.toSet()), keySource);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        return jwtProcessor;
    }
}

