/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.aws.elb;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriTemplate;

@ThreadSafe
public class ElbJWKSource<C extends SecurityContext>
implements JWKSource<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElbJWKSource.class);
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final UriTemplate jwkSetUriTemplate;
    private final JWKSetCache jwkSetCache;
    private final ResourceRetriever jwkSetRetriever;

    public ElbJWKSource(String jwkSetUriTemplate) {
        this(jwkSetUriTemplate, null);
    }

    public ElbJWKSource(String jwkSetUriTemplate, ResourceRetriever resourceRetriever) {
        this(jwkSetUriTemplate, resourceRetriever, null);
    }

    public ElbJWKSource(String jwkSetUriTemplate, ResourceRetriever resourceRetriever, JWKSetCache jwkSetCache) {
        if (jwkSetUriTemplate == null) {
            throw new IllegalArgumentException("The JWK set URI template must not be null");
        }
        this.jwkSetUriTemplate = new UriTemplate(jwkSetUriTemplate);
        this.jwkSetRetriever = Objects.requireNonNullElseGet(resourceRetriever, () -> new DefaultResourceRetriever(500, 500, 51200));
        this.jwkSetCache = Objects.requireNonNullElseGet(jwkSetCache, DefaultJWKSetCache::new);
    }

    private JWKSet updateJWKSetFromURL(JWKSelector jwkSelector) throws KeySourceException {
        JWKSet jwkSet;
        Resource res;
        String kid = ElbJWKSource.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
        if (StringUtils.isBlank((CharSequence)kid)) {
            throw new KeySourceException("Couldn't retrieve remote JWK set. Could not fid a KeyId.");
        }
        URI expanded = this.jwkSetUriTemplate.expand(Map.of("kid", kid));
        try {
            URL url = expanded.toURL();
            LOGGER.debug("Found kid: {} and looking public key from url {}", (Object)kid, (Object)url);
            res = this.jwkSetRetriever.retrieveResource(url);
        }
        catch (IOException e) {
            throw new RemoteKeySourceException("Couldn't retrieve remote JWK set: " + e.getMessage(), (Throwable)e);
        }
        String publicKey = res.getContent();
        try {
            JWK jwk = JWK.parseFromPEMEncodedObjects((String)publicKey);
            if (jwk instanceof RSAKey) {
                jwk = new RSAKey.Builder((RSAKey)jwk).keyID(kid).build();
            } else if (jwk instanceof ECKey) {
                jwk = new ECKey.Builder((ECKey)jwk).keyID(kid).build();
            } else {
                throw new KeySourceException("Unknown key type: " + jwk.getKeyType());
            }
            jwkSet = new JWKSet(jwk);
        }
        catch (JOSEException e) {
            throw new RemoteKeySourceException("Couldn't parse remote JWK set: " + e.getMessage(), (Throwable)e);
        }
        this.jwkSetCache.put(jwkSet);
        return jwkSet;
    }

    public UriTemplate getJWKSetUriTemplate() {
        return this.jwkSetUriTemplate;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSetCache getJWKSetCache() {
        return this.jwkSetCache;
    }

    public JWKSet getCachedJWKSet() {
        return this.jwkSetCache.get();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jwkMatcher) {
        Set keyIDs = jwkMatcher.getKeyIDs();
        if (keyIDs == null || keyIDs.isEmpty()) {
            return null;
        }
        for (String id : keyIDs) {
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public List<JWK> get(JWKSelector jwkSelector, C context) throws KeySourceException {
        List matches;
        JWKSet jwkSet;
        block7: {
            jwkSet = this.jwkSetCache.get();
            if (this.jwkSetCache.requiresRefresh() || jwkSet == null) {
                try {
                    jwkSet = this.updateJWKSetFromURL(jwkSelector);
                }
                catch (Exception ex) {
                    if (jwkSet != null) break block7;
                    throw ex;
                }
            }
        }
        if (!(matches = jwkSelector.select(jwkSet)).isEmpty()) {
            return matches;
        }
        String soughtKeyID = ElbJWKSource.getFirstSpecifiedKeyID(jwkSelector.getMatcher());
        if (soughtKeyID == null) {
            return Collections.emptyList();
        }
        if (jwkSet.getKeyByKeyId(soughtKeyID) != null) {
            return Collections.emptyList();
        }
        jwkSet = this.updateJWKSetFromURL(jwkSelector);
        if (jwkSet == null) {
            return Collections.emptyList();
        }
        return jwkSelector.select(jwkSet);
    }
}

