/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import io.dialob.rule.parser.node.ReducerExprNode;
import io.dialob.rule.parser.node.Span;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASTBuilder {
    private final ASTBuilder parentScopeBuilder;
    private NodeBase rootNode = null;
    private NodeBase topNode = null;

    public ASTBuilder() {
        this(null);
    }

    public ASTBuilder(ASTBuilder parentScopeBuilder) {
        this.parentScopeBuilder = parentScopeBuilder;
    }

    public ASTBuilder getParentScopeBuilder() {
        return this.parentScopeBuilder;
    }

    private NodeBase peek() {
        return this.topNode;
    }

    private void push(NodeBase nodeBase) {
        if (this.rootNode == null) {
            this.rootNode = nodeBase;
        }
        this.topNode = nodeBase;
    }

    private NodeBase pop() {
        if (this.topNode == null) {
            throw new IllegalStateException("node stack underflow");
        }
        NodeBase parent = this.topNode.getParent();
        if (parent != null) {
            parent.addSubnode(this.topNode);
        }
        this.topNode = parent;
        return this.topNode;
    }

    public ASTBuilder notExprNode(Span span) {
        return this.callExprNode(NodeOperator.createNodeOperator("not"), ValueType.BOOLEAN, span);
    }

    public ASTBuilder logicExprNode(String operator, Span span) {
        return this.callExprNode(NodeOperator.createNodeOperator(operator), ValueType.BOOLEAN, span);
    }

    public ASTBuilder infixExprNode(String operator, Span span) {
        return this.callExprNode(NodeOperator.createNodeOperator(operator), null, span);
    }

    public ASTBuilder unaryExprNode(String operator, Span span) {
        return this.callExprNode(NodeOperator.createNodeOperator(operator), null, span);
    }

    public ASTBuilder callExprNode(String function, Span span) {
        this.push(new CallExprNode(this.peek(), NodeOperator.createNodeOperator(function), span));
        return this;
    }

    public ASTBuilder callExprNode(String function, ValueType type, Span span) {
        this.push(new CallExprNode(this.peek(), NodeOperator.createNodeOperator(function), type, span));
        return this;
    }

    public ASTBuilder callExprNode(NodeOperator nodeOperator, ValueType type, Span span) {
        this.push(new CallExprNode(this.peek(), nodeOperator, type, span));
        return this;
    }

    public ASTBuilder callExprNode(CallExprNode node) {
        this.push(new CallExprNode(this.peek(), node.getNodeOperator(), node.getValueType(), node.getSpan()));
        return this;
    }

    public ASTBuilder reducerExprNode(String operator, Span span) {
        this.push(new ReducerExprNode(this.peek(), NodeOperator.createNodeOperator(operator), span));
        return this;
    }

    public ASTBuilder relationExprNode(String text, Span span) {
        return this.callExprNode(NodeOperator.createNodeOperator(text), ValueType.BOOLEAN, span);
    }

    public ASTBuilder constExprNode(String text, String unit, ValueType type, Span span) {
        this.push(new ConstExprNode(this.peek(), text, unit, type, span));
        return this;
    }

    public ASTBuilder constExprNode(ConstExprNode constExprNode) {
        this.push(new ConstExprNode(this.peek(), constExprNode.getValue(), constExprNode.getUnit(), constExprNode.getValueType(), constExprNode.getSpan()));
        return this;
    }

    public ASTBuilder idExprNode(@Nullable String namespace, @NotNull String text, @Nullable ValueType valueType, @NotNull Span span) {
        return this.idExprNode(namespace, null, text, valueType, span);
    }

    public ASTBuilder idExprNode(@Nullable String namespace, @Nullable String scopeId, @NotNull String text, @Nullable ValueType valueType, @NotNull Span span) {
        this.push(new IdExprNode(this.peek(), namespace, scopeId, text, valueType, span));
        return this;
    }

    public ASTBuilder idExprNode(IdExprNode node) {
        this.push(new IdExprNode(this.peek(), node.getNamespace(), node.getScopeId(), node.getId(), node.getValueType(), node.getSpan()));
        return this;
    }

    public ASTBuilder setValueType(ValueType valueType) {
        this.topNode.setValueType(valueType);
        return this;
    }

    public ASTBuilder closeExpr() {
        this.pop();
        return this;
    }

    public NodeBase getTopNode() {
        return this.topNode;
    }

    public NodeBase build() {
        if (this.topNode != null) {
            throw new IllegalStateException("Unclosed expression");
        }
        return this.rootNode;
    }

    public ASTBuilder cloneNode(NodeBase node) {
        if (node instanceof CallExprNode) {
            ASTBuilder builder = this.callExprNode((CallExprNode)node);
            node.getSubnodes().forEach(subnode -> builder.cloneNode((NodeBase)subnode).closeExpr());
        }
        return this.exprNode(node);
    }

    public ASTBuilder exprNode(NodeBase node) {
        if (node instanceof IdExprNode) {
            return this.idExprNode((IdExprNode)node);
        }
        if (node instanceof ConstExprNode) {
            return this.constExprNode((ConstExprNode)node);
        }
        if (node instanceof CallExprNode) {
            return this.callExprNode((CallExprNode)node);
        }
        throw new IllegalStateException("Unknown node type " + this);
    }

    public ASTBuilder exprNodes(NodeBase ... nodes) {
        ASTBuilder builder = this;
        for (NodeBase node : nodes) {
            List<NodeBase> subnodes = node.getSubnodes();
            builder = builder.exprNode(node).exprNodes(subnodes.toArray(new NodeBase[0])).closeExpr();
        }
        return builder;
    }
}

