/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import org.jetbrains.annotations.NotNull;

public class ExpressionWriterVisitor
implements ASTVisitor {
    private final String separator;
    private final NodeOperator nodeOperator;
    private StringBuilder stringBuilder = new StringBuilder();
    private ExpressionWriterVisitor subVisitor;
    private boolean first = true;

    ExpressionWriterVisitor() {
        this(null, "");
    }

    private ExpressionWriterVisitor(NodeOperator nodeOperator, String separator) {
        this.separator = separator;
        this.nodeOperator = nodeOperator;
    }

    @Override
    @NotNull
    public ASTVisitor visitCallExpr(@NotNull CallExprNode node) {
        this.addSeparator();
        String separator = this.getOperatorSeparator(node.getNodeOperator());
        this.subVisitor = this.createSubVisitor(node, separator);
        return this.subVisitor;
    }

    private String getOperatorSeparator(NodeOperator nodeOperator) {
        Object separator = "";
        String operator = this.convertOperator(nodeOperator.getOperator());
        switch (nodeOperator.getCategory()) {
            case FUNCTION: {
                this.stringBuilder.append(operator).append("(");
                separator = ",";
                break;
            }
            case LOGICAL: {
                if (nodeOperator.isUnary()) {
                    this.stringBuilder.append(operator).append(" ");
                    separator = "";
                    break;
                }
                separator = " " + operator + " ";
                break;
            }
            case INFIX: {
                separator = operator;
                break;
            }
            case UNARY: {
                separator = "";
                break;
            }
            case RELATION: {
                separator = " " + operator + " ";
                break;
            }
        }
        return separator;
    }

    private String convertOperator(@NotNull String operator) {
        return operator;
    }

    private ExpressionWriterVisitor createSubVisitor(CallExprNode node, String separator) {
        return new ExpressionWriterVisitor(node.getNodeOperator(), separator);
    }

    @Override
    @NotNull
    public NodeBase endCallExpr(@NotNull CallExprNode node) {
        switch (node.getNodeOperator().getCategory()) {
            case FUNCTION: {
                this.stringBuilder.append(this.subVisitor.toString()).append(")");
                break;
            }
            case LOGICAL: {
                this.stringBuilder.append(this.addBrackets(this.subVisitor));
                break;
            }
            case INFIX: {
                this.stringBuilder.append(this.addBrackets(this.subVisitor));
                break;
            }
            case UNARY: {
                this.stringBuilder.append(this.convertUnaryOper(node)).append(this.addBrackets(this.subVisitor));
                break;
            }
            case RELATION: {
                this.stringBuilder.append(this.subVisitor.toString());
                break;
            }
        }
        return node;
    }

    private String convertUnaryOper(CallExprNode node) {
        switch (node.getNodeOperator().getOperator()) {
            case "neg": {
                return "-";
            }
            case "inv": {
                return "1/";
            }
        }
        throw new IllegalStateException("Unknown unary operator " + node.getNodeOperator().getOperator());
    }

    private String addBrackets(ExpressionWriterVisitor subVisitor) {
        if (subVisitor.nodeOperator != null && this.nodeOperator != null) {
            if (subVisitor.nodeOperator.getCategory() == this.nodeOperator.getCategory() && subVisitor.nodeOperator.getPrecedenceWeight() < this.nodeOperator.getPrecedenceWeight()) {
                return "(" + subVisitor.stringBuilder.toString() + ")";
            }
            if (this.nodeOperator.isUnary()) {
                return "(" + subVisitor.stringBuilder.toString() + ")";
            }
        }
        return subVisitor.stringBuilder.toString();
    }

    @Override
    @NotNull
    public NodeBase visitConstExpr(@NotNull ConstExprNode node) {
        this.addSeparator();
        this.stringBuilder.append(node.getValue());
        if (node.getUnit() != null) {
            this.stringBuilder.append(node.getUnit());
        }
        return node;
    }

    private void addSeparator() {
        if (!this.first) {
            this.stringBuilder.append(this.separator);
        }
        this.first = false;
    }

    private String convertId(String id) {
        return id;
    }

    @Override
    @NotNull
    public NodeBase visitIdExpr(@NotNull IdExprNode node) {
        this.addSeparator();
        this.stringBuilder.append(this.convertId(node.getId()));
        return node;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }
}

