/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.AstMatcher;
import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.modifier.ModifyingMinifierVisitor;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AstMatcherTest {
    @Test
    public void simpleNodeMatchersAreCalled() {
        Expression expression = Expression.createExpression((String)"1 + a + 3");
        final UnaryOperator constNodeFunctionMock = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        final UnaryOperator idNodeFunctionMock = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        Mockito.when((Object)((NodeBase)constNodeFunctionMock.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(invocation -> (NodeBase)invocation.getArguments()[0]);
        Mockito.when((Object)((NodeBase)idNodeFunctionMock.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(invocation -> (NodeBase)invocation.getArguments()[0]);
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(1.constNode(), constNodeFunctionMock);
                this.whenMatches(1.idNode(), idNodeFunctionMock);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify((Object)constNodeFunctionMock, (VerificationMode)Mockito.times((int)2))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify((Object)idNodeFunctionMock, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constNodeFunctionMock, idNodeFunctionMock});
    }

    @Test
    public void simpleNodeMatchersAreCalledWhenPredicateMatches() {
        Expression expression = Expression.createExpression((String)"1 + a + 3");
        final UnaryOperator constNode3FunctionMock = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        final UnaryOperator constNode1FunctionMock = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        final UnaryOperator idANodeFunctionMock = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        Mockito.when((Object)((NodeBase)constNode3FunctionMock.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(AdditionalAnswers.returnsFirstArg());
        Mockito.when((Object)((NodeBase)constNode1FunctionMock.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(AdditionalAnswers.returnsFirstArg());
        Mockito.when((Object)((NodeBase)idANodeFunctionMock.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(AdditionalAnswers.returnsFirstArg());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(2.constNode((Predicate)2.stringValue((Predicate)2.is((Object)"3"))), constNode3FunctionMock);
                this.whenMatches(2.constNode((Predicate)2.value((Predicate)2.is((Object)1))), constNode1FunctionMock);
                this.whenMatches(2.idNode((Predicate)2.valueType((Predicate)2.isNull())), idANodeFunctionMock);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify((Object)constNode3FunctionMock, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify((Object)idANodeFunctionMock, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify((Object)constNode1FunctionMock, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constNode3FunctionMock, idANodeFunctionMock, constNode1FunctionMock});
    }

    @Test
    public void callOperatorMathers() {
        Expression expression = Expression.createExpression((String)"1 + a + 3");
        final UnaryOperator<NodeBase> callMatcher = this.mockMatchFunction();
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(3.callNode(), callMatcher);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher, (VerificationMode)Mockito.times((int)2))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher});
    }

    @Test
    public void callOperatorArgumentsMatchers() {
        Expression expression = Expression.createExpression((String)"1 + a + 3");
        final UnaryOperator<NodeBase> callMatcher1 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher2 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher3 = this.mockMatchFunction();
        System.out.println(expression.getAst());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(4.callNode((Predicate)4.args((Predicate)4.length((Predicate)4.is((Object)1)))), callMatcher1);
                this.whenMatches(4.callNode((Predicate)4.args((Predicate)4.length((Predicate)4.is((Object)2)))), callMatcher2);
                this.whenMatches(4.callNode((Predicate)4.args((Predicate)4.length((Predicate)4.is((Object)3)))), callMatcher3);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher1, (VerificationMode)Mockito.times((int)0))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher2, (VerificationMode)Mockito.times((int)2))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher3, (VerificationMode)Mockito.times((int)0))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher1, callMatcher2, callMatcher3});
    }

    @Test
    public void matchersWithHigherPredenceOverridesLowerMatchers() {
        Expression expression = Expression.createExpression((String)"1 + 3 + 3 + a");
        final UnaryOperator<NodeBase> callMatcher1 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher2 = this.mockMatchFunction();
        System.out.println(expression.getAst());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(5.callNode((Predicate)5.args((Predicate)5.allMatches((Predicate)5.constNode()))), callMatcher1);
                this.whenMatches(5.callNode((Predicate)5.args((Predicate)5.anyMatches((Predicate)5.constNode()))), callMatcher2);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher1, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher2, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher1, callMatcher2});
    }

    @Test
    public void matchersWithHigherPredenceOverridesLowerMatchers2() {
        Expression expression = Expression.createExpression((String)"1 + 3 + 3 + a");
        final UnaryOperator<NodeBase> callMatcher1 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher2 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher3 = this.mockMatchFunction();
        System.out.println(expression.getAst());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(6.callNode((Predicate)6.args((Predicate)6.allMatches((Predicate)6.constNode()))), callMatcher1);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        matcher = new AstMatcher(){
            {
                this.whenMatches(7.callNode((Predicate)7.args((Predicate)7.anyMatches((Predicate)7.constNode()))), callMatcher2);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        matcher = new AstMatcher(){
            {
                this.whenMatches(8.callNode((Predicate)8.operator((Predicate)8.is((Object)"+"))), callMatcher3);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher1, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher2, (VerificationMode)Mockito.times((int)2))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher3, (VerificationMode)Mockito.times((int)3))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher1, callMatcher2, callMatcher3});
    }

    @Test
    public void relativeMatchers() {
        Expression expression = Expression.createExpression((String)"1 + a + 3");
        final UnaryOperator<NodeBase> callMatcher1 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher2 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher3 = this.mockMatchFunction();
        System.out.println(expression.getAst());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(9.callNode((Predicate)9.args((Predicate)9.length((Predicate)9.is((Object)1)))), callMatcher1);
                this.whenMatches(9.callNode((Predicate)9.args((Predicate)9.length((Predicate)9.is((Object)2)))), callMatcher2);
                this.whenMatches(9.callNode((Predicate)9.args((Predicate)9.length((Predicate)9.is((Object)3)))), callMatcher3);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher1, (VerificationMode)Mockito.times((int)0))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher2, (VerificationMode)Mockito.times((int)2))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher3, (VerificationMode)Mockito.times((int)0))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher1, callMatcher2, callMatcher3});
    }

    @Test
    public void shouldMatchOnParentNode() {
        Expression expression = Expression.createExpression((String)"a + b + c");
        final UnaryOperator<NodeBase> callMatcher1 = this.mockMatchFunction();
        final UnaryOperator<NodeBase> callMatcher2 = this.mockMatchFunction();
        System.out.println(expression.getAst());
        AstMatcher matcher = new AstMatcher(){
            {
                this.whenMatches(10.callNode(10.operator((Predicate)10.is((Object)"+")).and(10.parent((Predicate)10.callNode((Predicate)10.operator((Predicate)10.is((Object)"+")))))), callMatcher1);
                this.whenMatches(10.callNode(10.operator((Predicate)10.is((Object)"+")).and(10.parent((Predicate)10.callNode((Predicate)10.operator((Predicate)10.is((Object)"-")))))), callMatcher2);
            }
        };
        expression.getAst().accept((ASTVisitor)matcher);
        ((UnaryOperator)Mockito.verify(callMatcher1, (VerificationMode)Mockito.times((int)1))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        ((UnaryOperator)Mockito.verify(callMatcher2, (VerificationMode)Mockito.times((int)0))).apply((NodeBase)ArgumentMatchers.any(NodeBase.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{callMatcher1, callMatcher2});
    }

    @Test
    public void constEvalTest() {
        this.assertMinify("6", "1 + 2 + 3");
    }

    @Test
    public void constEvalTest2() {
        this.assertMinify("-2", "1 + 2 + 3 - 3 - 6 - 8 + 9");
    }

    @Test
    public void stringPlusIsStringCat() {
        this.assertMinify("\"6a689\"", "1 + 2 + 3 + 'a' + 6 + 8 + 9");
    }

    @Test
    public void integerMultiply() {
        this.assertMinify("24", "1 * 2 * 3 * 4");
    }

    @Test
    public void decimalMultiply() {
        this.assertMinify("26.4", "1 * 2.2 * 3 * 4");
    }

    @Test
    public void divide() {
        this.assertMinify("0.5", "1 / 2");
        this.assertMinify("(/ (* 0.5 a) 6)", "1 / 2 * a / 6");
    }

    @Test
    public void negateInteger() {
        this.assertMinify("-1", "-1");
    }

    @Test
    public void negateDecimal() {
        this.assertMinify("-5.0", "-1.0 * 5");
    }

    @Test
    public void relOpe() {
        this.assertMinify("false", "-1.0 > 5");
        this.assertMinify("false", "-1.0 >= 5");
        this.assertMinify("true", "-1.0 <= 5");
        this.assertMinify("true", "-1.0 < 5");
        this.assertMinify("false", "-1.0 = 5");
        this.assertMinify("true", "-1.0 != 5");
        this.assertMinify("false", "-1 > 5");
        this.assertMinify("false", "-1 >= 5");
        this.assertMinify("true", "-1 <= 5");
        this.assertMinify("true", "-1 < 5");
        this.assertMinify("false", "-1 = 5");
        this.assertMinify("true", "-1 != 5");
        this.assertMinify("-1", "5 - 6");
        this.assertMinify("true", "-1 = 5 - 6");
    }

    @Test
    public void logicalOper() {
        this.assertMinify("false", "false or false");
        this.assertMinify("(= a 0)", "true and a = 0");
        this.assertMinify("false", "false and a = 0");
        this.assertMinify("(= a (+ b 6))", "false or a = (b + 6)");
        this.assertMinify("(= a (+ b 6))", "a = (b + 6) or false");
        this.assertMinify("true", "true or a = (b + 6)");
        this.assertMinify("true", "not false or not false");
        this.assertMinify("false", "not true and not true");
        this.assertMinify("false", "not (true and true)");
        this.assertMinify("true", "not (true and false)");
        this.assertMinify("false", "true and false");
        this.assertMinify("true", "true and true and true");
        this.assertMinify("true", "6 + 9 = 15 and 8 * 8 < 65");
        this.assertMinify("(or (and (< question1 (/ question2 -4)) (> (+ question2 18) 0)) (!= (- question3 10) 10))", "question1 < question2 / (2 - 6) and question2 + 2 * 9 > 0 or question3 - 10 != 10");
    }

    private void assertMinify(String expected, String expressionString) {
        Expression expression = Expression.createExpression((String)expressionString);
        ASTBuilder astBuilder = new ASTBuilder();
        System.out.println(expression.getAst().toString());
        ModifyingMinifierVisitor matcher = new ModifyingMinifierVisitor();
        expression.accept((ASTVisitor)matcher);
        Assertions.assertEquals((Object)expected, (Object)expression.getAst().toString());
    }

    private UnaryOperator<NodeBase> mockMatchFunction() {
        UnaryOperator matchFunction = (UnaryOperator)Mockito.mock(UnaryOperator.class);
        Mockito.when((Object)((NodeBase)matchFunction.apply((NodeBase)ArgumentMatchers.any(NodeBase.class)))).thenAnswer(invocation -> (NodeBase)invocation.getArguments()[0]);
        return matchFunction;
    }
}

