/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import io.dialob.rule.parser.node.Span;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstExprNode
extends NodeBase {
    private static final long serialVersionUID = 7754763577641440194L;
    private final String value;
    private final String unit;

    public ConstExprNode(NodeBase parent, String value, String unit, @Nullable ValueType valueType, Span span) {
        super(parent, span);
        this.value = value;
        this.unit = unit;
        if (valueType != null) {
            this.setValueType(valueType);
        }
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    @NotNull
    public NodeOperator getNodeOperator() {
        return NodeOperator.CONST;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public Object getAsValueType() {
        return this.getAsValueType(this.getValueType());
    }

    public Object getAsValueType(ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType may not be null");
        if (this.value == null) {
            return null;
        }
        if (this.unit != null) {
            return valueType.parseFromStringWithUnit(this.value, this.unit);
        }
        return valueType.parseFromString(this.value);
    }

    public String toString() {
        if (this.unit != null) {
            return "\"" + this.value + " " + this.unit + "\"";
        }
        if (this.getValueType() == ValueType.STRING) {
            return "\"" + StringEscapeUtils.escapeJava((String)this.value) + "\"";
        }
        return this.value;
    }

    @Override
    public String toTypedString() {
        String string = "'" + this.value;
        if (this.unit != null) {
            string = string + " " + this.unit;
        }
        return string + "'[" + this.getValueType() + "]";
    }

    @Override
    public NodeBase accept(@NotNull ASTVisitor visitor) {
        return visitor.visitConstExpr(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstExprNode)) {
            return false;
        }
        ConstExprNode other = (ConstExprNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstExprNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }
}

