/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.node.NodeBase;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TypeAnalysisTest {
    @Test
    public void doubleQuotedStringsAreStrings() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        NodeBase nodeBase = this.parse(variableFinder, "\"a\"");
        Assertions.assertSame((Object)ValueType.STRING, (Object)nodeBase.getValueType());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder});
    }

    @Test
    public void singleQuotedStringsAreStrings() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        NodeBase nodeBase = this.parse(variableFinder, "'a'");
        Assertions.assertSame((Object)ValueType.STRING, (Object)nodeBase.getValueType());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder});
    }

    @Test
    public void additionOf2IntegersResultsInteger() throws Exception {
        VariableFinder variableFinder = (VariableFinder)Mockito.mock(VariableFinder.class);
        Assertions.assertSame((Object)ValueType.INTEGER, (Object)this.parse(variableFinder, "1 + 2").getValueType());
        Assertions.assertSame((Object)ValueType.INTEGER, (Object)this.parse(variableFinder, "1 + 2 - 3 * 5 / 9").getValueType());
        Assertions.assertSame((Object)ValueType.STRING, (Object)this.parse(variableFinder, "'1' + '2'").getValueType());
        Assertions.assertSame((Object)ValueType.INTEGER, (Object)this.parse(variableFinder, "1 * 2").getValueType());
        Assertions.assertSame((Object)ValueType.INTEGER, (Object)this.parse(variableFinder, "1 - 2").getValueType());
        Assertions.assertSame((Object)ValueType.INTEGER, (Object)this.parse(variableFinder, "1 / 2").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1.0 + 2.0").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1.0 * 2.0").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1.0 - 2.0").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1.0 / 2.0").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1.0 + 2").getValueType());
        Assertions.assertSame((Object)ValueType.DECIMAL, (Object)this.parse(variableFinder, "1 + 2.0").getValueType());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variableFinder});
    }

    private NodeBase parse(VariableFinder variableFinder, String expressionString) {
        return Expression.createExpression((VariableFinder)variableFinder, (Map)Maps.newHashMap(), (String)expressionString).getAst();
    }
}

