package io.dialob.rule.parser.api;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableVariableFinder} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link VariableFinder}.
 * @see ImmutableVariableFinder.Variable
 * @see ImmutableVariableFinder.Function
 */
@Generated(from = "VariableFinder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableVariableFinder {
  private ImmutableVariableFinder() {}

  /**
   * Immutable implementation of {@link VariableFinder.Variable}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableVariableFinder.Variable.builder()}.
   */
  @Generated(from = "VariableFinder.Variable", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Variable implements VariableFinder.Variable {
    private final String name;
    private final ValueType valueType;
    private final @Nullable String scope;
    private final @Nullable Object placeHolderValue;
    private final @Nullable String valueSetId;

    private Variable(
        String name,
        ValueType valueType,
        @Nullable String scope,
        @Nullable Object placeHolderValue,
        @Nullable String valueSetId) {
      this.name = name;
      this.valueType = valueType;
      this.scope = scope;
      this.placeHolderValue = placeHolderValue;
      this.valueSetId = valueSetId;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String getName() {
      return name;
    }

    /**
     * @return The value of the {@code valueType} attribute
     */
    @Override
    public ValueType getValueType() {
      return valueType;
    }

    /**
     * @return The value of the {@code scope} attribute
     */
    @Override
    public Optional<String> getScope() {
      return Optional.ofNullable(scope);
    }

    /**
     * @return The value of the {@code placeHolderValue} attribute
     */
    @Override
    public Optional<Object> getPlaceHolderValue() {
      return Optional.ofNullable(placeHolderValue);
    }

    /**
     * @return The value of the {@code valueSetId} attribute
     */
    @Override
    public Optional<String> getValueSetId() {
      return Optional.ofNullable(valueSetId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link VariableFinder.Variable#getName() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableVariableFinder.Variable withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableVariableFinder.Variable(newValue, this.valueType, this.scope, this.placeHolderValue, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link VariableFinder.Variable#getValueType() valueType} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for valueType
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableVariableFinder.Variable withValueType(ValueType value) {
      if (this.valueType == value) return this;
      ValueType newValue = Objects.requireNonNull(value, "valueType");
      return new ImmutableVariableFinder.Variable(this.name, newValue, this.scope, this.placeHolderValue, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link VariableFinder.Variable#getScope() scope} attribute.
     * @param value The value for scope
     * @return A modified copy of {@code this} object
     */
    public final ImmutableVariableFinder.Variable withScope(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "scope");
      if (Objects.equals(this.scope, newValue)) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, newValue, this.placeHolderValue, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link VariableFinder.Variable#getScope() scope} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for scope
     * @return A modified copy of {@code this} object
     */
    public final ImmutableVariableFinder.Variable withScope(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.scope, value)) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, value, this.placeHolderValue, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link VariableFinder.Variable#getPlaceHolderValue() placeHolderValue} attribute.
     * @param value The value for placeHolderValue
     * @return A modified copy of {@code this} object
     */
    public final ImmutableVariableFinder.Variable withPlaceHolderValue(Object value) {
      @Nullable Object newValue = Objects.requireNonNull(value, "placeHolderValue");
      if (this.placeHolderValue == newValue) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, this.scope, newValue, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link VariableFinder.Variable#getPlaceHolderValue() placeHolderValue} attribute.
     * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for placeHolderValue
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableVariableFinder.Variable withPlaceHolderValue(Optional<? extends Object> optional) {
      @Nullable Object value = optional.orElse(null);
      if (this.placeHolderValue == value) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, this.scope, value, this.valueSetId);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link VariableFinder.Variable#getValueSetId() valueSetId} attribute.
     * @param value The value for valueSetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableVariableFinder.Variable withValueSetId(String value) {
      @Nullable String newValue = Objects.requireNonNull(value, "valueSetId");
      if (Objects.equals(this.valueSetId, newValue)) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, this.scope, this.placeHolderValue, newValue);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link VariableFinder.Variable#getValueSetId() valueSetId} attribute.
     * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for valueSetId
     * @return A modified copy of {@code this} object
     */
    public final ImmutableVariableFinder.Variable withValueSetId(Optional<String> optional) {
      @Nullable String value = optional.orElse(null);
      if (Objects.equals(this.valueSetId, value)) return this;
      return new ImmutableVariableFinder.Variable(this.name, this.valueType, this.scope, this.placeHolderValue, value);
    }

    /**
     * This instance is equal to all instances of {@code Variable} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableVariableFinder.Variable
          && equalTo((ImmutableVariableFinder.Variable) another);
    }

    private boolean equalTo(ImmutableVariableFinder.Variable another) {
      return name.equals(another.name)
          && valueType.equals(another.valueType)
          && Objects.equals(scope, another.scope)
          && Objects.equals(placeHolderValue, another.placeHolderValue)
          && Objects.equals(valueSetId, another.valueSetId);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code valueType}, {@code scope}, {@code placeHolderValue}, {@code valueSetId}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @com.google.errorprone.annotations.Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + valueType.hashCode();
      h += (h << 5) + Objects.hashCode(scope);
      h += (h << 5) + Objects.hashCode(placeHolderValue);
      h += (h << 5) + Objects.hashCode(valueSetId);
      return h;
    }

    /**
     * Prints the immutable value {@code Variable} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Variable")
          .omitNullValues()
          .add("name", name)
          .add("valueType", valueType)
          .add("scope", scope)
          .add("placeHolderValue", placeHolderValue)
          .add("valueSetId", valueSetId)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link VariableFinder.Variable} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Variable instance
     */
    public static ImmutableVariableFinder.Variable copyOf(VariableFinder.Variable instance) {
      if (instance instanceof ImmutableVariableFinder.Variable) {
        return (ImmutableVariableFinder.Variable) instance;
      }
      return ImmutableVariableFinder.Variable.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableVariableFinder.Variable Variable}.
     * <pre>
     * ImmutableVariableFinder.Variable.builder()
     *    .name(String) // required {@link VariableFinder.Variable#getName() name}
     *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link VariableFinder.Variable#getValueType() valueType}
     *    .scope(String) // optional {@link VariableFinder.Variable#getScope() scope}
     *    .placeHolderValue(Object) // optional {@link VariableFinder.Variable#getPlaceHolderValue() placeHolderValue}
     *    .valueSetId(String) // optional {@link VariableFinder.Variable#getValueSetId() valueSetId}
     *    .build();
     * </pre>
     * @return A new Variable builder
     */
    public static ImmutableVariableFinder.Variable.Builder builder() {
      return new ImmutableVariableFinder.Variable.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableVariableFinder.Variable Variable}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "VariableFinder.Variable", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_VALUE_TYPE = 0x2L;
      private long initBits = 0x3L;

      private @Nullable String name;
      private @Nullable ValueType valueType;
      private @Nullable String scope;
      private @Nullable Object placeHolderValue;
      private @Nullable String valueSetId;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code io.dialob.rule.parser.api.VariableFinder.Variable} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(VariableFinder.Variable instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code io.dialob.rule.parser.api.VariableFinder.Var} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(VariableFinder.Var instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof VariableFinder.Variable) {
          VariableFinder.Variable instance = (VariableFinder.Variable) object;
          Optional<Object> placeHolderValueOptional = instance.getPlaceHolderValue();
          if (placeHolderValueOptional.isPresent()) {
            placeHolderValue(placeHolderValueOptional);
          }
          Optional<String> valueSetIdOptional = instance.getValueSetId();
          if (valueSetIdOptional.isPresent()) {
            valueSetId(valueSetIdOptional);
          }
          Optional<String> scopeOptional = instance.getScope();
          if (scopeOptional.isPresent()) {
            scope(scopeOptional);
          }
        }
        if (object instanceof VariableFinder.Var) {
          VariableFinder.Var instance = (VariableFinder.Var) object;
          name(instance.getName());
          valueType(instance.getValueType());
        }
      }

      /**
       * Initializes the value for the {@link VariableFinder.Variable#getName() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link VariableFinder.Variable#getValueType() valueType} attribute.
       * @param valueType The value for valueType 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder valueType(ValueType valueType) {
        this.valueType = Objects.requireNonNull(valueType, "valueType");
        initBits &= ~INIT_BIT_VALUE_TYPE;
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getScope() scope} to scope.
       * @param scope The value for scope
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder scope(String scope) {
        this.scope = Objects.requireNonNull(scope, "scope");
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getScope() scope} to scope.
       * @param scope The value for scope
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder scope(Optional<String> scope) {
        this.scope = scope.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getPlaceHolderValue() placeHolderValue} to placeHolderValue.
       * @param placeHolderValue The value for placeHolderValue
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder placeHolderValue(Object placeHolderValue) {
        this.placeHolderValue = Objects.requireNonNull(placeHolderValue, "placeHolderValue");
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getPlaceHolderValue() placeHolderValue} to placeHolderValue.
       * @param placeHolderValue The value for placeHolderValue
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder placeHolderValue(Optional<? extends Object> placeHolderValue) {
        this.placeHolderValue = placeHolderValue.orElse(null);
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getValueSetId() valueSetId} to valueSetId.
       * @param valueSetId The value for valueSetId
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder valueSetId(String valueSetId) {
        this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
        return this;
      }

      /**
       * Initializes the optional value {@link VariableFinder.Variable#getValueSetId() valueSetId} to valueSetId.
       * @param valueSetId The value for valueSetId
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder valueSetId(Optional<String> valueSetId) {
        this.valueSetId = valueSetId.orElse(null);
        return this;
      }

      /**
       * Builds a new {@link ImmutableVariableFinder.Variable Variable}.
       * @return An immutable instance of Variable
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableVariableFinder.Variable build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableVariableFinder.Variable(name, valueType, scope, placeHolderValue, valueSetId);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
        return "Cannot build Variable, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link VariableFinder.Function}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableVariableFinder.Function.builder()}.
   */
  @Generated(from = "VariableFinder.Function", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Function implements VariableFinder.Function {
    private final String name;
    private final ValueType valueType;
    private final boolean isAsync;

    private Function(String name, ValueType valueType, boolean isAsync) {
      this.name = name;
      this.valueType = valueType;
      this.isAsync = isAsync;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public String getName() {
      return name;
    }

    /**
     * @return The value of the {@code valueType} attribute
     */
    @Override
    public ValueType getValueType() {
      return valueType;
    }

    /**
     * @return The value of the {@code isAsync} attribute
     */
    @Override
    public boolean isAsync() {
      return isAsync;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link VariableFinder.Function#getName() name} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableVariableFinder.Function withName(String value) {
      String newValue = Objects.requireNonNull(value, "name");
      if (this.name.equals(newValue)) return this;
      return new ImmutableVariableFinder.Function(newValue, this.valueType, this.isAsync);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link VariableFinder.Function#getValueType() valueType} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for valueType
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableVariableFinder.Function withValueType(ValueType value) {
      if (this.valueType == value) return this;
      ValueType newValue = Objects.requireNonNull(value, "valueType");
      return new ImmutableVariableFinder.Function(this.name, newValue, this.isAsync);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link VariableFinder.Function#isAsync() isAsync} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for isAsync
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableVariableFinder.Function withIsAsync(boolean value) {
      if (this.isAsync == value) return this;
      return new ImmutableVariableFinder.Function(this.name, this.valueType, value);
    }

    /**
     * This instance is equal to all instances of {@code Function} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableVariableFinder.Function
          && equalTo((ImmutableVariableFinder.Function) another);
    }

    private boolean equalTo(ImmutableVariableFinder.Function another) {
      return name.equals(another.name)
          && valueType.equals(another.valueType)
          && isAsync == another.isAsync;
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code valueType}, {@code isAsync}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @com.google.errorprone.annotations.Var int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + valueType.hashCode();
      h += (h << 5) + Booleans.hashCode(isAsync);
      return h;
    }

    /**
     * Prints the immutable value {@code Function} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Function")
          .omitNullValues()
          .add("name", name)
          .add("valueType", valueType)
          .add("isAsync", isAsync)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link VariableFinder.Function} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Function instance
     */
    public static ImmutableVariableFinder.Function copyOf(VariableFinder.Function instance) {
      if (instance instanceof ImmutableVariableFinder.Function) {
        return (ImmutableVariableFinder.Function) instance;
      }
      return ImmutableVariableFinder.Function.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableVariableFinder.Function Function}.
     * <pre>
     * ImmutableVariableFinder.Function.builder()
     *    .name(String) // required {@link VariableFinder.Function#getName() name}
     *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link VariableFinder.Function#getValueType() valueType}
     *    .isAsync(boolean) // required {@link VariableFinder.Function#isAsync() isAsync}
     *    .build();
     * </pre>
     * @return A new Function builder
     */
    public static ImmutableVariableFinder.Function.Builder builder() {
      return new ImmutableVariableFinder.Function.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableVariableFinder.Function Function}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "VariableFinder.Function", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_VALUE_TYPE = 0x2L;
      private static final long INIT_BIT_IS_ASYNC = 0x4L;
      private long initBits = 0x7L;

      private @Nullable String name;
      private @Nullable ValueType valueType;
      private boolean isAsync;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code io.dialob.rule.parser.api.VariableFinder.Var} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(VariableFinder.Var instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code io.dialob.rule.parser.api.VariableFinder.Function} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(VariableFinder.Function instance) {
        Objects.requireNonNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof VariableFinder.Var) {
          VariableFinder.Var instance = (VariableFinder.Var) object;
          name(instance.getName());
          valueType(instance.getValueType());
        }
        if (object instanceof VariableFinder.Function) {
          VariableFinder.Function instance = (VariableFinder.Function) object;
          isAsync(instance.isAsync());
        }
      }

      /**
       * Initializes the value for the {@link VariableFinder.Function#getName() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link VariableFinder.Function#getValueType() valueType} attribute.
       * @param valueType The value for valueType 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder valueType(ValueType valueType) {
        this.valueType = Objects.requireNonNull(valueType, "valueType");
        initBits &= ~INIT_BIT_VALUE_TYPE;
        return this;
      }

      /**
       * Initializes the value for the {@link VariableFinder.Function#isAsync() isAsync} attribute.
       * @param isAsync The value for isAsync 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder isAsync(boolean isAsync) {
        this.isAsync = isAsync;
        initBits &= ~INIT_BIT_IS_ASYNC;
        return this;
      }

      /**
       * Builds a new {@link ImmutableVariableFinder.Function Function}.
       * @return An immutable instance of Function
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableVariableFinder.Function build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableVariableFinder.Function(name, valueType, isAsync);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
        if ((initBits & INIT_BIT_IS_ASYNC) != 0) attributes.add("isAsync");
        return "Cannot build Function, some of required attributes are not set " + attributes;
      }
    }
  }
}
