/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import io.dialob.rule.parser.node.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdExprNode
extends NodeBase {
    private static final long serialVersionUID = -3176730634816602189L;
    private final String scopeId;
    private final String id;
    private final String namespace;
    private final Map<String, ValueType> idSet;

    public IdExprNode(NodeBase parent, @Nullable String namespace, @Nullable String scopeId, @NotNull String id, @Nullable ValueType valueType, @NotNull Span span) {
        super(parent, span, valueType);
        this.id = Objects.requireNonNull(id);
        this.namespace = StringUtils.defaultString((String)namespace);
        HashMap<String, ValueType> idSet = new HashMap<String, ValueType>();
        idSet.put(this.id, valueType);
        this.idSet = Collections.unmodifiableMap(idSet);
        this.scopeId = scopeId;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getScopeId() {
        return this.scopeId;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String toTypedString() {
        return this.id + "[" + this.getValueType() + "]";
    }

    @Override
    public NodeBase accept(@NotNull ASTVisitor visitor) {
        return visitor.visitIdExpr(this);
    }

    @Override
    @NotNull
    public Map<String, ValueType> getDependencies() {
        return this.idSet;
    }

    @Override
    @NotNull
    public NodeOperator getNodeOperator() {
        return NodeOperator.ID;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdExprNode)) {
            return false;
        }
        IdExprNode other = (IdExprNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdExprNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }
}

