/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;

public class PeriodUtil {
    public static int comparePeriods(Period lhs, Period rhs) {
        if (lhs.getYears() != rhs.getYears()) {
            return Integer.compare(lhs.getYears(), rhs.getYears());
        }
        if (lhs.getMonths() != rhs.getMonths()) {
            return Integer.compare(lhs.getMonths(), rhs.getMonths());
        }
        if (lhs.getDays() != rhs.getDays()) {
            return Integer.compare(lhs.getDays(), rhs.getDays());
        }
        return 0;
    }

    public static LocalDate datePlusPeriod(LocalDate lhs, Period rhs) {
        return lhs.plus(rhs);
    }

    public static LocalDate periodPlusDate(Period lhs, LocalDate rhs) {
        return rhs.plus(lhs);
    }

    public static LocalDate dateMinusPeriod(LocalDate lhs, Period rhs) {
        return lhs.minus(rhs);
    }

    public static Period sumPeriods(Period lhs, Period rhs) {
        return lhs.plus(rhs).normalized();
    }

    public static Duration sumDurations(Duration lhs, Duration rhs) {
        return lhs.plus(rhs);
    }

    public static Period minusPeriods(Period lhs, Period rhs) {
        return lhs.minus(rhs).normalized();
    }

    public static Duration minusDurations(Duration lhs, Duration rhs) {
        return lhs.minus(rhs);
    }

    public static LocalTime timePlusDuration(LocalTime lhs, Duration rhs) {
        return lhs.plus(rhs);
    }

    public static LocalTime durationPlusTime(Duration lhs, LocalTime rhs) {
        return rhs.plus(lhs);
    }

    public static LocalTime timeMinusDuration(LocalTime lhs, Duration rhs) {
        return lhs.minus(rhs);
    }
}

