package io.dialob.rule.parser.node;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Span}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpan.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSpan.of()}.
 */
@Generated(from = "Span", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSpan implements Span {
  private final int startIndex;
  private final int stopIndex;

  private ImmutableSpan(int startIndex, int stopIndex) {
    this.startIndex = startIndex;
    this.stopIndex = stopIndex;
  }

  /**
   * @return The value of the {@code startIndex} attribute
   */
  @Override
  public int getStartIndex() {
    return startIndex;
  }

  /**
   * @return The value of the {@code stopIndex} attribute
   */
  @Override
  public int getStopIndex() {
    return stopIndex;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Span#getStartIndex() startIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpan withStartIndex(int value) {
    if (this.startIndex == value) return this;
    return new ImmutableSpan(value, this.stopIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Span#getStopIndex() stopIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stopIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpan withStopIndex(int value) {
    if (this.stopIndex == value) return this;
    return new ImmutableSpan(this.startIndex, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpan} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpan
        && equalTo((ImmutableSpan) another);
  }

  private boolean equalTo(ImmutableSpan another) {
    return startIndex == another.startIndex
        && stopIndex == another.stopIndex;
  }

  /**
   * Computes a hash code from attributes: {@code startIndex}, {@code stopIndex}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + startIndex;
    h += (h << 5) + stopIndex;
    return h;
  }

  /**
   * Prints the immutable value {@code Span} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Span")
        .omitNullValues()
        .add("startIndex", startIndex)
        .add("stopIndex", stopIndex)
        .toString();
  }

  /**
   * Construct a new immutable {@code Span} instance.
   * @param startIndex The value for the {@code startIndex} attribute
   * @param stopIndex The value for the {@code stopIndex} attribute
   * @return An immutable Span instance
   */
  public static ImmutableSpan of(int startIndex, int stopIndex) {
    return new ImmutableSpan(startIndex, stopIndex);
  }

  /**
   * Creates an immutable copy of a {@link Span} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Span instance
   */
  public static ImmutableSpan copyOf(Span instance) {
    if (instance instanceof ImmutableSpan) {
      return (ImmutableSpan) instance;
    }
    return ImmutableSpan.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpan ImmutableSpan}.
   * <pre>
   * ImmutableSpan.builder()
   *    .startIndex(int) // required {@link Span#getStartIndex() startIndex}
   *    .stopIndex(int) // required {@link Span#getStopIndex() stopIndex}
   *    .build();
   * </pre>
   * @return A new ImmutableSpan builder
   */
  public static ImmutableSpan.Builder builder() {
    return new ImmutableSpan.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpan ImmutableSpan}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Span", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_START_INDEX = 0x1L;
    private static final long INIT_BIT_STOP_INDEX = 0x2L;
    private long initBits = 0x3L;

    private int startIndex;
    private int stopIndex;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Span} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Span instance) {
      Objects.requireNonNull(instance, "instance");
      startIndex(instance.getStartIndex());
      stopIndex(instance.getStopIndex());
      return this;
    }

    /**
     * Initializes the value for the {@link Span#getStartIndex() startIndex} attribute.
     * @param startIndex The value for startIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder startIndex(int startIndex) {
      this.startIndex = startIndex;
      initBits &= ~INIT_BIT_START_INDEX;
      return this;
    }

    /**
     * Initializes the value for the {@link Span#getStopIndex() stopIndex} attribute.
     * @param stopIndex The value for stopIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stopIndex(int stopIndex) {
      this.stopIndex = stopIndex;
      initBits &= ~INIT_BIT_STOP_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpan ImmutableSpan}.
     * @return An immutable instance of Span
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSpan build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSpan(startIndex, stopIndex);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START_INDEX) != 0) attributes.add("startIndex");
      if ((initBits & INIT_BIT_STOP_INDEX) != 0) attributes.add("stopIndex");
      return "Cannot build Span, some of required attributes are not set " + attributes;
    }
  }
}
