/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NodeOperator
implements Serializable {
    private static final long serialVersionUID = 3766609755158172243L;
    public static final NodeOperator CONST = new NodeOperator("$const", Category.LEAF);
    public static final NodeOperator ID = new NodeOperator("$id", Category.LEAF);
    private final String operator;
    private final Category category;
    private static final Map<String, NodeOperator> OPERATORS = ImmutableMap.builder().put((Object)"neg", (Object)new NodeOperator("neg", Category.UNARY)).put((Object)"inv", (Object)new NodeOperator("inv", Category.UNARY)).put((Object)"not", (Object)new NodeOperator("not", Category.LOGICAL)).put((Object)"and", (Object)new NodeOperator("and", Category.LOGICAL)).put((Object)"or", (Object)new NodeOperator("or", Category.LOGICAL)).put((Object)"*", (Object)new NodeOperator("*", Category.INFIX)).put((Object)"/", (Object)new NodeOperator("/", Category.INFIX)).put((Object)"+", (Object)new NodeOperator("+", Category.INFIX)).put((Object)"-", (Object)new NodeOperator("-", Category.INFIX)).put((Object)"!=", (Object)new NodeOperator("!=", Category.RELATION)).put((Object)"=", (Object)new NodeOperator("=", Category.RELATION)).put((Object)"<", (Object)new NodeOperator("<", Category.RELATION)).put((Object)"<=", (Object)new NodeOperator("<=", Category.RELATION)).put((Object)">", (Object)new NodeOperator(">", Category.RELATION)).put((Object)">=", (Object)new NodeOperator(">=", Category.RELATION)).put((Object)"in", (Object)new NodeOperator("in", Category.RELATION)).put((Object)"matches", (Object)new NodeOperator("matches", Category.RELATION)).put((Object)"notIn", (Object)new NodeOperator("notIn", Category.RELATION)).put((Object)"notMatches", (Object)new NodeOperator("notMatches", Category.RELATION)).put((Object)"isAnswered", (Object)new NodeOperator("isAnswered", Category.RELATION)).put((Object)"isNotAnswered", (Object)new NodeOperator("isNotAnswered", Category.RELATION)).put((Object)"isValid", (Object)new NodeOperator("isValid", Category.RELATION)).put((Object)"isNotValid", (Object)new NodeOperator("isNotValid", Category.RELATION)).put((Object)"sumOf", (Object)new NodeOperator("sumOf", Category.FUNCTION)).put((Object)"minOf", (Object)new NodeOperator("minOf", Category.FUNCTION)).put((Object)"maxOf", (Object)new NodeOperator("maxOf", Category.FUNCTION)).put((Object)"allOf", (Object)new NodeOperator("allOf", Category.FUNCTION)).put((Object)"anyOf", (Object)new NodeOperator("anyOf", Category.FUNCTION)).build();

    private NodeOperator(@NotNull String operator, @NotNull Category category) {
        this.operator = operator;
        this.category = category;
    }

    @NotNull
    public static NodeOperator createNodeOperator(@NotNull String operator) {
        NodeOperator nodeOperator = OPERATORS.get(operator);
        if (nodeOperator == null) {
            return new NodeOperator(operator, Category.FUNCTION);
        }
        return nodeOperator;
    }

    public NodeOperator not() {
        if (this.getCategory() == Category.RELATION || this.getCategory() == Category.LOGICAL) {
            switch (this.operator) {
                case "not": {
                    return null;
                }
                case "and": {
                    return NodeOperator.createNodeOperator("or");
                }
                case "or": {
                    return NodeOperator.createNodeOperator("and");
                }
                case "!=": {
                    return NodeOperator.createNodeOperator("=");
                }
                case "=": {
                    return NodeOperator.createNodeOperator("!=");
                }
                case "<": {
                    return NodeOperator.createNodeOperator(">=");
                }
                case "<=": {
                    return NodeOperator.createNodeOperator(">");
                }
                case ">": {
                    return NodeOperator.createNodeOperator("<=");
                }
                case ">=": {
                    return NodeOperator.createNodeOperator("<");
                }
                case "in": {
                    return NodeOperator.createNodeOperator("notIn");
                }
                case "notIn": {
                    return NodeOperator.createNodeOperator("in");
                }
                case "matches": {
                    return NodeOperator.createNodeOperator("notMatches");
                }
                case "notMatches": {
                    return NodeOperator.createNodeOperator("matches");
                }
                case "isAnswered": {
                    return NodeOperator.createNodeOperator("isNotAnswered");
                }
                case "isNotAnswered": {
                    return NodeOperator.createNodeOperator("isAnswered");
                }
            }
        }
        throw new IllegalStateException("cannot not operator " + this);
    }

    @NotNull
    public String getOperator() {
        return this.operator;
    }

    @NotNull
    public Category getCategory() {
        return this.category;
    }

    public boolean isNegOp() {
        return "neg".equals(this.operator);
    }

    public boolean isInvOp() {
        return "inv".equals(this.operator);
    }

    public boolean isNotOp() {
        return "not".equals(this.operator);
    }

    public boolean isAndOp() {
        return "and".equals(this.operator);
    }

    public boolean isOrOp() {
        return "or".equals(this.operator);
    }

    public boolean isMultOp() {
        return "*".equals(this.operator);
    }

    public boolean isPlusOp() {
        return "+".equals(this.operator);
    }

    public boolean isMinusOp() {
        return "-".equals(this.operator);
    }

    public boolean isDivOp() {
        return "/".equals(this.operator);
    }

    public boolean isUnary() {
        return this.isNotOp() || this.isInvOp() || this.isNegOp();
    }

    public boolean isInfix() {
        return this.category == Category.INFIX;
    }

    public boolean isLogical() {
        return this.category == Category.LOGICAL;
    }

    public boolean isRelation() {
        return this.category == Category.RELATION;
    }

    public int getPrecedenceWeight() {
        if (this.isUnary()) {
            return 8;
        }
        if (this.isDivOp()) {
            return 7;
        }
        if (this.isMultOp()) {
            return 6;
        }
        if (this.isPlusOp() || this.isMinusOp()) {
            return 5;
        }
        if (this.category == Category.FUNCTION) {
            return 4;
        }
        if (this.category == Category.RELATION) {
            return 3;
        }
        if (this.isAndOp()) {
            return 2;
        }
        if (this.isOrOp()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeOperator) {
            NodeOperator other = (NodeOperator)obj;
            return other.getCategory() == this.getCategory() && this.operator.equals(other.getOperator());
        }
        return false;
    }

    public int hashCode() {
        return this.operator.hashCode() * 31 + this.category.hashCode();
    }

    public String toString() {
        return this.operator;
    }

    public static enum Category {
        FUNCTION,
        LOGICAL,
        UNARY,
        INFIX,
        RELATION,
        LEAF;

    }
}

