/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.function;

import io.dialob.rule.parser.function.FunctionRegistry;
import java.time.LocalDate;
import java.time.LocalTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;

public class DefaultFunctions {
    public DefaultFunctions(FunctionRegistry functionRegistry) {
        functionRegistry.configureFunction("today", "now", LocalDate.class, false);
        functionRegistry.configureFunction("now", "now", LocalTime.class, false);
        functionRegistry.configureFunction("lengthOf", "lengthOf", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isLyt", "isLyt", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isNotLyt", "isNotLyt", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isHetu", "isHetu", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isNotHetu", "isNotHetu", DefaultFunctions.class, false);
        functionRegistry.configureFunction("count", "count", DefaultFunctions.class, false);
        functionRegistry.configureFunction("birthDateFromHetu", "birthDateFromHetu", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isIban", "isIban", DefaultFunctions.class, false);
        functionRegistry.configureFunction("isNotIban", "isNotIban", DefaultFunctions.class, false);
    }

    public static boolean isIban(String iban) {
        return IBANValidator.getInstance().isValid(StringUtils.deleteWhitespace((String)iban));
    }

    public static boolean isNotIban(String iban) {
        return !DefaultFunctions.isIban(iban);
    }

    public static Integer lengthOf(String s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public static boolean isNotLyt(String lyt) {
        return !DefaultFunctions.isLyt(lyt);
    }

    public static int count(Object[] list) {
        if (list == null) {
            return 0;
        }
        return list.length;
    }

    public static boolean isLyt(String lyt) {
        if (StringUtils.isBlank((CharSequence)lyt)) {
            return false;
        }
        if (((String)(lyt = ((String)lyt).trim())).length() > 9) {
            return false;
        }
        if (((String)lyt).length() < 9) {
            lyt = "00000000".substring(0, 9 - ((String)lyt).length()) + (String)lyt;
        }
        if (!((String)lyt).matches("\\d{7}-\\d")) {
            return false;
        }
        int[] factors = new int[]{7, 9, 10, 5, 8, 4, 2};
        int sum = 0;
        for (int i = 0; i < 7; ++i) {
            sum += factors[i] * (((String)lyt).charAt(i) - 48);
        }
        int reminder = sum % 11;
        if (reminder > 0) {
            reminder = 11 - reminder;
        }
        return ((String)lyt).charAt(8) - 48 == reminder;
    }

    public static boolean isNotHetu(String hetu) {
        return !DefaultFunctions.isHetu(hetu);
    }

    public static boolean isHetu(String hetu) {
        if (StringUtils.isBlank((CharSequence)hetu)) {
            return false;
        }
        if (hetu.length() != 11) {
            return false;
        }
        hetu = hetu.toUpperCase();
        String date = hetu.substring(0, 6);
        String seq = hetu.substring(7, 10);
        if (!date.matches("\\d{6}")) {
            return false;
        }
        if (!seq.matches("\\d{3}")) {
            return false;
        }
        LocalDate birthDate = DefaultFunctions.birthDateFromHetu(hetu);
        if (birthDate == null) {
            return false;
        }
        int reminder = Integer.parseInt(date + seq) % 31;
        char checkCode = "0123456789ABCDEFHJKLMNPRSTUVWXY".charAt(reminder);
        return checkCode == hetu.charAt(10);
    }

    public static LocalDate birthDateFromHetu(String hetu) {
        if (StringUtils.isBlank((CharSequence)hetu)) {
            return null;
        }
        if (hetu.length() != 11) {
            return null;
        }
        try {
            hetu = hetu.toUpperCase();
            int day = Integer.parseInt(hetu.substring(0, 2));
            int month = Integer.parseInt(hetu.substring(2, 4));
            int year = Integer.parseInt(hetu.substring(4, 6));
            char middlechar = hetu.charAt(6);
            if (middlechar == '+') {
                year += 1800;
            } else if (middlechar == '-') {
                year += 1900;
            } else if (middlechar >= 'A' && middlechar <= 'Z') {
                year += (middlechar - 65) * 100 + 2000;
            } else {
                return null;
            }
            return LocalDate.of(year, month, day);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

