/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.rule.parser.api.ValueType;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Comparator;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.StringUtils;

public enum PrimitiveValueType implements ValueType
{
    TIME{

        public Comparator<LocalTime> getComparator() {
            return Comparator.naturalOrder();
        }

        @Override
        public Class<?> getTypeClass() {
            return LocalTime.class;
        }

        @Override
        public LocalTime parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return LocalTime.parse(string);
        }

        @Override
        public boolean isNegateable() {
            return false;
        }

        @Override
        public boolean canEqualWith(ValueType rhs) {
            return rhs == this;
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (rhs == PERIOD || rhs == DATE) {
                return null;
            }
            if (rhs == DURATION) {
                return TIME;
            }
            if (rhs == TIME) {
                return DURATION;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (rhs == DURATION) {
                return TIME;
            }
            if (rhs == TIME) {
                return DURATION;
            }
            return null;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                LocalTime localTime = (LocalTime)value;
                output.writeInt32NoTag(localTime.getHour());
                output.writeInt32NoTag(localTime.getMinute());
                output.writeInt32NoTag(localTime.getSecond());
                output.writeInt32NoTag(localTime.getNano());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                int hour = input.readInt32();
                int minute = input.readInt32();
                int second = input.readInt32();
                int nano = input.readInt32();
                return LocalTime.of(hour, minute, second, nano);
            }
            return null;
        }
    }
    ,
    DURATION{

        public Comparator<Duration> getComparator() {
            return Comparator.naturalOrder();
        }

        public BinaryOperator<Duration> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity.plus((Duration)element);
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return Duration.class;
        }

        @Override
        public Duration parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return Duration.parse(string);
        }

        @Override
        public Object parseFromStringWithUnit(String value, String unit) {
            switch (unit) {
                case "seconds": 
                case "second": {
                    return Duration.ofSeconds(Long.parseLong(value));
                }
                case "minutes": 
                case "minute": {
                    return Duration.ofMinutes(Long.parseLong(value));
                }
                case "hours": 
                case "hour": {
                    return Duration.ofHours(Long.parseLong(value));
                }
                case "days": 
                case "day": {
                    return Duration.ofDays(Long.parseLong(value));
                }
                case "weeks": 
                case "week": {
                    return Duration.ofDays(Long.parseLong(value) * 7L);
                }
            }
            return this.parseFromString(value);
        }

        @Override
        public boolean isNegateable() {
            return true;
        }

        @Override
        public Object negate(Object value) {
            return ((Duration)value).negated();
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (rhs == DURATION) {
                return DURATION;
            }
            if (rhs == TIME) {
                return TIME;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (rhs == DURATION) {
                return DURATION;
            }
            return null;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                Duration duration = (Duration)value;
                output.writeInt64NoTag(duration.getSeconds());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                long seconds = input.readInt64();
                return Duration.of(seconds, ChronoUnit.SECONDS);
            }
            return null;
        }
    }
    ,
    DATE{

        public Comparator<LocalDate> getComparator() {
            return Comparator.naturalOrder();
        }

        @Override
        public Class<?> getTypeClass() {
            return LocalDate.class;
        }

        @Override
        public LocalDate parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return LocalDate.parse(string);
        }

        @Override
        public boolean canEqualWith(ValueType rhs) {
            return rhs == this;
        }

        @Override
        public boolean isNegateable() {
            return false;
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (rhs == TIME || rhs == DURATION) {
                return null;
            }
            if (rhs == DATE) {
                return PERIOD;
            }
            if (rhs == PERIOD) {
                return DATE;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (rhs == DATE) {
                return PERIOD;
            }
            if (rhs == PERIOD) {
                return DATE;
            }
            return null;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                LocalDate localDate = (LocalDate)value;
                output.writeInt32NoTag(localDate.getYear());
                output.writeInt32NoTag(localDate.getMonthValue());
                output.writeInt32NoTag(localDate.getDayOfMonth());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                int year = input.readInt32();
                int month = input.readInt32();
                int day = input.readInt32();
                return LocalDate.of(year, month, day);
            }
            return null;
        }
    }
    ,
    PERIOD{

        public Comparator<Period> getComparator() {
            return null;
        }

        public BinaryOperator<Period> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity.plus((TemporalAmount)element);
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return Period.class;
        }

        @Override
        public Object parseFromStringWithUnit(String value, String unit) {
            switch (unit) {
                case "years": 
                case "year": {
                    return Period.ofYears(Integer.parseInt(value));
                }
                case "months": 
                case "month": {
                    return Period.ofMonths(Integer.parseInt(value));
                }
                case "days": 
                case "day": {
                    return Period.ofDays(Integer.parseInt(value));
                }
                case "weeks": 
                case "week": {
                    return Period.ofWeeks(Integer.parseInt(value));
                }
            }
            return this.parseFromString(value);
        }

        @Override
        public Period parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return Period.parse(string);
        }

        @Override
        public boolean isNegateable() {
            return true;
        }

        @Override
        public Object negate(Object value) {
            return ((Period)value).negated();
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (rhs == PERIOD) {
                return PERIOD;
            }
            if (rhs == DATE) {
                return DATE;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (rhs == PERIOD) {
                return PERIOD;
            }
            return null;
        }

        @Override
        public boolean canOrderWith(ValueType rhs) {
            return rhs == PERIOD;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                Period period = (Period)value;
                output.writeInt32NoTag(period.getYears());
                output.writeInt32NoTag(period.getMonths());
                output.writeInt32NoTag(period.getDays());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                int years = input.readInt32();
                int months = input.readInt32();
                int days = input.readInt32();
                return Period.of(years, months, days);
            }
            return null;
        }
    }
    ,
    INTEGER{

        public Comparator<Integer> getComparator() {
            return Comparator.naturalOrder();
        }

        public BinaryOperator<Integer> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity + element;
            };
        }

        public BinaryOperator<Integer> multOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity * element;
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return Integer.class;
        }

        @Override
        public Integer parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return Integer.valueOf(string);
        }

        @Override
        public boolean isNegateable() {
            return true;
        }

        @Override
        public Object negate(Object value) {
            return -((Integer)value).intValue();
        }

        protected boolean isNumberType(ValueType rhs) {
            return rhs == DECIMAL || rhs == INTEGER;
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (this.isNumberType(rhs)) {
                return rhs;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (this.isNumberType(rhs)) {
                return rhs;
            }
            return null;
        }

        @Override
        public ValueType multiplyType(ValueType rhs) {
            if (this.isNumberType(rhs)) {
                return rhs;
            }
            return null;
        }

        @Override
        public ValueType divideByType(ValueType rhs) {
            if (this.isNumberType(rhs)) {
                return rhs;
            }
            return null;
        }

        @Override
        public boolean canOrderWith(ValueType rhs) {
            return this.isNumberType(rhs);
        }

        @Override
        public boolean canEqualWith(ValueType rhs) {
            return this.isNumberType(rhs);
        }

        @Override
        public Object coerseFrom(Object value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return null;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                output.writeInt32NoTag(((Integer)value).intValue());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                return input.readInt32();
            }
            return null;
        }
    }
    ,
    DECIMAL{

        public Comparator<BigDecimal> getComparator() {
            return Comparator.naturalOrder();
        }

        public BinaryOperator<BigDecimal> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity.add((BigDecimal)element);
            };
        }

        public BinaryOperator<BigDecimal> multOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity.multiply((BigDecimal)element);
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return BigDecimal.valueOf(Double.parseDouble(string));
        }

        @Override
        public boolean isNegateable() {
            return true;
        }

        @Override
        public Object negate(Object value) {
            return ((BigDecimal)value).negate();
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            if (rhs == DECIMAL || rhs == INTEGER) {
                return DECIMAL;
            }
            return super.plusType(rhs);
        }

        @Override
        public ValueType minusType(ValueType rhs) {
            if (rhs == DECIMAL || rhs == INTEGER) {
                return DECIMAL;
            }
            return null;
        }

        @Override
        public ValueType multiplyType(ValueType rhs) {
            if (rhs == DECIMAL || rhs == INTEGER) {
                return DECIMAL;
            }
            return null;
        }

        @Override
        public ValueType divideByType(ValueType rhs) {
            if (rhs == DECIMAL || rhs == INTEGER) {
                return DECIMAL;
            }
            return null;
        }

        @Override
        public boolean canOrderWith(ValueType rhs) {
            return rhs == DECIMAL || rhs == INTEGER;
        }

        @Override
        public boolean canEqualWith(ValueType rhs) {
            return rhs == DECIMAL || rhs == INTEGER;
        }

        @Override
        public Object coerseFrom(Object value) {
            if (value instanceof Number) {
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return null;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                BigDecimal decimal = (BigDecimal)value;
                output.writeStringNoTag(decimal.toString());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                return new BigDecimal(input.readString());
            }
            return null;
        }
    }
    ,
    BOOLEAN{

        public Comparator<Boolean> getComparator() {
            return Comparator.naturalOrder();
        }

        public BinaryOperator<Boolean> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity != false || element != false;
            };
        }

        public BinaryOperator<Boolean> multOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                if (element == null) {
                    return identity;
                }
                return identity != false && element != false;
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return Boolean.class;
        }

        @Override
        public Boolean parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return Boolean.valueOf(string);
        }

        @Override
        public boolean isNegateable() {
            return false;
        }

        @Override
        public Object not(Object value) {
            return (Boolean)value == false;
        }

        @Override
        public boolean canOrderWith(ValueType rhs) {
            return false;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                output.writeBoolNoTag(((Boolean)value).booleanValue());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                return input.readBool();
            }
            return null;
        }
    }
    ,
    STRING{

        public Comparator<String> getComparator() {
            return Comparator.naturalOrder();
        }

        public BinaryOperator<String> sumOp() {
            return (identity, element) -> {
                if (identity == null) {
                    return element;
                }
                return identity + element;
            };
        }

        @Override
        public Class<?> getTypeClass() {
            return String.class;
        }

        @Override
        public Object parseFromString(String string) {
            return string;
        }

        @Override
        public boolean isNegateable() {
            return false;
        }

        @Override
        public ValueType plusType(ValueType rhs) {
            return STRING;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                String string = (String)value;
                output.writeStringNoTag(string);
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                return input.readString();
            }
            return null;
        }
    }
    ,
    PERCENT{

        public Comparator<BigDecimal> getComparator() {
            return Comparator.naturalOrder();
        }

        @Override
        public Class<?> getTypeClass() {
            return BigDecimal.class;
        }

        @Override
        public Object parseFromString(String string) {
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            return BigDecimal.valueOf(Double.parseDouble(string));
        }

        @Override
        public boolean isNegateable() {
            return false;
        }

        @Override
        public void writeTo(CodedOutputStream output, Object value) throws IOException {
            boolean present = value != null;
            output.writeBoolNoTag(present);
            if (present) {
                BigDecimal decimal = (BigDecimal)value;
                output.writeStringNoTag(decimal.toString());
            }
        }

        @Override
        public Object readFrom(CodedInputStream input) throws IOException {
            if (input.readBool()) {
                return new BigDecimal(input.readString());
            }
            return null;
        }
    };


    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object negate(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object not(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> BinaryOperator<T> sumOp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> BinaryOperator<T> multOp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueType plusType(ValueType rhs) {
        if (rhs == STRING) {
            return STRING;
        }
        return null;
    }

    @Override
    public ValueType minusType(ValueType rhs) {
        return null;
    }

    @Override
    public ValueType multiplyType(ValueType rhs) {
        return null;
    }

    @Override
    public ValueType divideByType(ValueType rhs) {
        return null;
    }

    @Override
    public boolean canEqualWith(ValueType rhs) {
        return this == rhs;
    }

    @Override
    public boolean canOrderWith(ValueType rhs) {
        return this == rhs;
    }

    @Override
    public Object parseFromStringWithUnit(String value, String unit) {
        return this.parseFromString(value);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public byte getTypeCode() {
        return (byte)this.ordinal();
    }
}

