/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeOperator;
import io.dialob.rule.parser.node.Span;
import io.dialob.rule.parser.node.TypedNode;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class NodeBase
implements TypedNode,
Serializable {
    private static final long serialVersionUID = 1948018522089217375L;
    private NodeBase parent;
    private final Span span;
    private ValueType type;

    public NodeBase(NodeBase parent) {
        this(parent, null, null);
    }

    public NodeBase(NodeBase parent, Span span) {
        this(parent, span, null);
    }

    public NodeBase(NodeBase parent, Span span, ValueType type) {
        this.parent = parent;
        this.span = span;
        this.type = type;
    }

    public NodeBase getParent() {
        return this.parent;
    }

    public void setParent(NodeBase parent) {
        this.parent = parent;
    }

    public Span getSpan() {
        return this.span;
    }

    @Override
    public ValueType getValueType() {
        return this.type;
    }

    public void setValueType(@NotNull ValueType type) {
        this.type = Objects.requireNonNull(type);
    }

    @NotNull
    public Map<String, ValueType> getDependencies() {
        return Collections.emptyMap();
    }

    public Map<String, ValueType> getAllDependencies() {
        return this.getDependencies();
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isIdentifier() {
        return false;
    }

    public NodeBase addSubnode(@NotNull NodeBase topNode) {
        throw new IllegalStateException("Cannot add subnodes on leaf node");
    }

    @NotNull
    public List<NodeBase> getSubnodes() {
        return Collections.emptyList();
    }

    @NotNull
    public abstract NodeOperator getNodeOperator();

    public abstract NodeBase accept(@NotNull ASTVisitor var1);

    public String toTypedString() {
        return this.toString() + "[" + this.type + "]";
    }

    public String toString(String indent) {
        return indent + this.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodeBase)) {
            return false;
        }
        NodeBase other = (NodeBase)obj;
        return other.type == this.type;
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }
}

