/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import com.google.common.collect.Maps;
import io.dialob.rule.parser.DialobRuleLexer;
import io.dialob.rule.parser.DialobRuleParser;
import io.dialob.rule.parser.api.ImmutableRuleExpressionCompilerError;
import io.dialob.rule.parser.api.RuleExpressionCompilerError;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.node.ASTBuilderWalker;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.ErrorLogger;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.Span;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jetbrains.annotations.NotNull;

public class Expression
implements ErrorLogger {
    private final String expression;
    private NodeBase ast;
    private List<RuleExpressionCompilerError> errors = new ArrayList<RuleExpressionCompilerError>();

    private Expression(@NotNull String expression) {
        this(ASTBuilderWalker.DUMMY_VARIABLE_FINDER, Maps.newHashMap(), expression);
    }

    private Expression(@NotNull VariableFinder variableFinder, Map<NodeBase, String> asyncFunctionVariables, @NotNull String expression) {
        this.expression = Objects.requireNonNull(expression, "expression may not be null");
        ParseTree parseTree = this.parseExpression(expression);
        if (!this.hasErrors()) {
            ParseTreeWalker walker = new ParseTreeWalker();
            ASTBuilderWalker astBuilder = new ASTBuilderWalker(variableFinder, asyncFunctionVariables);
            astBuilder.setErrorLogger(this);
            walker.walk((ParseTreeListener)astBuilder, parseTree);
            this.ast = astBuilder.getBuilder().build();
        }
    }

    @NotNull
    public static Expression createExpression(@NotNull String expression) {
        return new Expression(expression);
    }

    @NotNull
    public static Expression createExpression(VariableFinder variableFinder, Map<NodeBase, String> asyncFunctionVariables, @NotNull String expression) {
        return new Expression(variableFinder, asyncFunctionVariables, expression);
    }

    @NotNull
    private ParseTree parseExpression(@NotNull String expression) {
        DialobRuleLexer dialobRuleLexer = new DialobRuleLexer((CharStream)CharStreams.fromString((String)expression));
        ErrorListener errorListener = new ErrorListener(this);
        dialobRuleLexer.addErrorListener(errorListener);
        DialobRuleParser dialobRuleParser = new DialobRuleParser((TokenStream)new CommonTokenStream((TokenSource)dialobRuleLexer));
        dialobRuleParser.addErrorListener(errorListener);
        dialobRuleParser.setBuildParseTree(true);
        return dialobRuleParser.compileUnit();
    }

    public List<RuleExpressionCompilerError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        return this.expression;
    }

    @Override
    public void logError(String errorCode, Span span) {
        this.errors.add(ImmutableRuleExpressionCompilerError.builder().errorCode(errorCode).span(span).build());
    }

    @Override
    public void logError(String errorCode, Object[] args, Span span) {
        this.errors.add(ImmutableRuleExpressionCompilerError.builder().errorCode(errorCode).args(args).span(span).build());
    }

    public Set<String> getAllIds() {
        final HashSet<String> ids = new HashSet<String>();
        this.ast.accept(new ASTVisitor(){

            @Override
            @NotNull
            public NodeBase visitIdExpr(@NotNull IdExprNode node) {
                ids.add(node.getId());
                return node;
            }
        });
        return ids;
    }

    public Expression renameId(final String from, String to) {
        final ArrayList opes = new ArrayList();
        this.ast.accept(new ASTVisitor(){

            @Override
            @NotNull
            public NodeBase visitIdExpr(@NotNull IdExprNode node) {
                if (node.getId().equals(from)) {
                    opes.add(new StringOper(node.getSpan()));
                }
                return node;
            }
        });
        Collections.sort(opes);
        Object updatedExpression = this.expression;
        for (StringOper op : opes) {
            updatedExpression = ((String)updatedExpression).substring(0, op.span.getStartIndex()) + to + ((String)updatedExpression).substring(op.span.getStopIndex() + 1);
        }
        return Expression.createExpression((String)updatedExpression);
    }

    public void accept(ASTVisitor visitor) {
        this.ast = this.ast.accept(visitor);
    }

    public NodeBase getAst() {
        return this.ast;
    }

    private static class ErrorListener
    implements ANTLRErrorListener {
        private final ErrorLogger errorLogger;

        private ErrorListener(ErrorLogger errorLogger) {
            this.errorLogger = errorLogger;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object o, int row, int column, String s, RecognitionException e) {
            this.errorLogger.logError("SYNTAX_ERROR", Span.of(column, column));
        }

        public void reportAmbiguity(Parser parser, DFA dfa, int row, int column, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
            this.errorLogger.logError("AMBIGUOUS_INPUT", Span.of(column, column));
        }

        public void reportAttemptingFullContext(Parser parser, DFA dfa, int row, int column, BitSet bitSet, ATNConfigSet atnConfigSet) {
            this.errorLogger.logError("FULL_CONTEXT_ERROR", Span.of(column, column));
        }

        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int row, int column, ATNConfigSet atnConfigSet) {
            this.errorLogger.logError("CONTEXT_SENSITIVE_ERROR", Span.of(column, column));
        }
    }

    static class StringOper
    implements Comparable<StringOper> {
        final Span span;

        StringOper(Span span) {
            this.span = span;
        }

        @Override
        public int compareTo(@NotNull StringOper o) {
            return o.span.getStartIndex() - this.span.getStartIndex();
        }
    }
}

