/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import io.dialob.rule.parser.api.ValueType;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AsyncFunctionDependency
implements Serializable {
    private final String functionRefId;
    private final List<String> argumentExpressions;
    private final String functionName;
    private final String canonicalFunctionName;
    private ValueType valueType;

    public AsyncFunctionDependency(String functionRefId, String canonicalFunctionName, ValueType valueType, String functionName, List<String> argumentExpressions) {
        if (StringUtils.isBlank((CharSequence)functionRefId)) {
            throw new IllegalArgumentException("functionRefId may not be blank.");
        }
        this.functionRefId = functionRefId;
        this.functionName = functionName;
        this.valueType = valueType;
        this.argumentExpressions = argumentExpressions;
        this.canonicalFunctionName = canonicalFunctionName;
    }

    public String getFunctionRefId() {
        return this.functionRefId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<String> getArgumentExpressions() {
        return Collections.unmodifiableList(this.argumentExpressions);
    }

    public String getCanonicalFunctionName() {
        return this.canonicalFunctionName;
    }

    public int hashCode() {
        return this.functionRefId.hashCode();
    }

    public String toString() {
        return this.functionRefId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AsyncFunctionDependency) {
            AsyncFunctionDependency dependency = (AsyncFunctionDependency)obj;
            return this.functionRefId.equals(dependency.functionRefId);
        }
        return false;
    }

    public ValueType getValueType() {
        return this.valueType;
    }
}

