/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.rule.parser.api.PrimitiveValueType;
import io.dialob.rule.parser.api.ValueType;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ArrayValueType
implements ValueType {
    private final ValueType valueType;
    private static final ConcurrentMap<ValueType, ValueType> ARRAY_VALUE_TYPES = new ConcurrentHashMap<ValueType, ValueType>();

    ArrayValueType(ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType may not be null");
        this.valueType = valueType;
    }

    private static <T> Class<? extends T[]> getArrayClass(Class<T> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    static ValueType arrayOf(@NotNull ValueType valueType) {
        return ARRAY_VALUE_TYPES.computeIfAbsent(valueType, ArrayValueType::new);
    }

    @Override
    public <T> Comparator<T> getComparator() {
        return null;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Class<?> getTypeClass() {
        return ArrayValueType.getArrayClass(this.valueType.getTypeClass());
    }

    @Override
    public Object parseFromString(String string) {
        if (!string.startsWith("[") && string.endsWith("]")) {
            throw new RuntimeException("No an array.");
        }
        string = string.substring(1);
        string = string.substring(0, string.length() - 1);
        String[] values = StringUtils.split((String)string, (String)",");
        Object[] objects = (Object[])Array.newInstance(this.valueType.getTypeClass(), values.length);
        for (int i = 0; i < values.length; ++i) {
            objects[i] = this.valueType.parseFromString(values[i]);
        }
        return objects;
    }

    @Override
    public boolean isNegateable() {
        return false;
    }

    @Override
    public Object negate(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object not(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> BinaryOperator<T> sumOp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> BinaryOperator<T> multOp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueType plusType(ValueType rhs) {
        return null;
    }

    @Override
    public ValueType minusType(ValueType rhs) {
        return null;
    }

    @Override
    public ValueType multiplyType(ValueType rhs) {
        return null;
    }

    @Override
    public ValueType divideByType(ValueType rhs) {
        return null;
    }

    @Override
    public boolean canEqualWith(ValueType rhs) {
        return this.equals(rhs);
    }

    @Override
    public boolean canOrderWith(ValueType rhs) {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object parseFromStringWithUnit(String value, String unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "[" + this.valueType.getName() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayValueType) {
            ArrayValueType other = (ArrayValueType)obj;
            return other.valueType.equals(this.valueType);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.valueType.hashCode() * 7;
    }

    public String toString() {
        return "ARRAY";
    }

    @Override
    public byte getTypeCode() {
        return (byte)(this.valueType.getTypeCode() | 0x80);
    }

    @Override
    public ValueType getItemValueType() {
        return this.valueType;
    }

    @Override
    public void writeTo(CodedOutputStream output, Object value) throws IOException {
        boolean present = value != null;
        output.writeBoolNoTag(present);
        if (present) {
            List list = (List)value;
            output.write(this.valueType.getTypeCode());
            output.writeInt32NoTag(list.size());
            for (Object item : list) {
                this.valueType.writeTo(output, item);
            }
        }
    }

    @Override
    public Object readFrom(CodedInputStream input) throws IOException {
        if (input.readBool()) {
            ValueType valueType;
            byte typeCode = input.readRawByte();
            int count = input.readInt32();
            if ((0x80 & typeCode) != 0) {
                typeCode = (byte)(typeCode & 0x7F);
                valueType = ValueType.arrayOf(PrimitiveValueType.values()[typeCode]);
            } else {
                valueType = PrimitiveValueType.values()[typeCode];
            }
            ImmutableList.Builder objectBuilder = ImmutableList.builder();
            for (int i = 0; i < count; ++i) {
                objectBuilder.add(valueType.readFrom(input));
            }
            return objectBuilder.build();
        }
        return null;
    }
}

