/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ExpressionMerger
implements ASTVisitor {
    private CallExprNode parentNode;
    private List<NodeBase> newArguments = new ArrayList<NodeBase>();
    private int nodeStack = 0;
    private ASTBuilder astBuilder;
    private Predicate<NodeBase> shouldMergePredicate;

    private static <T> Predicate<T> truePredicate() {
        return t -> true;
    }

    ExpressionMerger() {
        this(new ASTBuilder(), ExpressionMerger.truePredicate());
    }

    public ExpressionMerger(ASTBuilder astBuilder) {
        this(astBuilder, ExpressionMerger.truePredicate());
    }

    public ExpressionMerger(Predicate<NodeBase> shouldMergePredicate) {
        this(new ASTBuilder(), shouldMergePredicate);
    }

    private ExpressionMerger(ASTBuilder astBuilder, Predicate<NodeBase> shouldMergePredicate) {
        this.astBuilder = astBuilder;
        this.shouldMergePredicate = shouldMergePredicate;
    }

    private boolean canMerge(CallExprNode parent, CallExprNode sub) {
        if (!this.shouldMergePredicate.test(sub)) {
            return false;
        }
        NodeOperator parentOperator = parent.getNodeOperator();
        NodeOperator subOperator = sub.getNodeOperator();
        return parentOperator.getCategory() == subOperator.getCategory() && parentOperator.getOperator().equals(subOperator.getOperator());
    }

    @Override
    public ASTVisitor visitCallExpr(@NotNull CallExprNode subNode) {
        this.push(subNode);
        if (this.parentNode == null) {
            this.parentNode = subNode;
            this.astBuilder = this.astBuilder.callExprNode(subNode.getNodeOperator(), subNode.getValueType(), subNode.getSpan());
            return this;
        }
        if (this.canMerge(this.parentNode, subNode)) {
            return this;
        }
        subNode.accept(new ExpressionMerger(this.astBuilder, this.shouldMergePredicate));
        return null;
    }

    private void push(CallExprNode node) {
        ++this.nodeStack;
    }

    private void pop() {
        --this.nodeStack;
    }

    @Override
    @NotNull
    public CallExprNode endCallExpr(@NotNull CallExprNode subNode) {
        this.pop();
        if (this.nodeStack == 0) {
            for (NodeBase arg : this.newArguments) {
                if (arg instanceof ConstExprNode) {
                    this.astBuilder = this.astBuilder.constExprNode((ConstExprNode)arg).closeExpr();
                    continue;
                }
                if (!(arg instanceof IdExprNode)) continue;
                this.astBuilder = this.astBuilder.idExprNode((IdExprNode)arg).closeExpr();
            }
            this.newArguments.clear();
        } else if (!this.canMerge(this.parentNode, subNode)) {
            this.astBuilder = this.astBuilder.closeExpr();
        }
        return subNode;
    }

    public ASTBuilder getAstBuilder() {
        return this.astBuilder;
    }

    @Override
    @NotNull
    public NodeBase visitConstExpr(@NotNull ConstExprNode subNode) {
        this.newArguments.add(subNode);
        return subNode;
    }

    @Override
    @NotNull
    public NodeBase visitIdExpr(@NotNull IdExprNode subNode) {
        this.newArguments.add(subNode);
        return subNode;
    }
}

