/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.node.Span;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Span", generator="Immutables")
@Immutable
public final class ImmutableSpan
implements Span {
    private final int startIndex;
    private final int stopIndex;

    private ImmutableSpan(int startIndex, int stopIndex) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public final ImmutableSpan withStartIndex(int value) {
        if (this.startIndex == value) {
            return this;
        }
        return new ImmutableSpan(value, this.stopIndex);
    }

    public final ImmutableSpan withStopIndex(int value) {
        if (this.stopIndex == value) {
            return this;
        }
        return new ImmutableSpan(this.startIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpan && this.equalTo((ImmutableSpan)another);
    }

    private boolean equalTo(ImmutableSpan another) {
        return this.startIndex == another.startIndex && this.stopIndex == another.stopIndex;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.startIndex;
        h += (h << 5) + this.stopIndex;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Span").omitNullValues().add("startIndex", this.startIndex).add("stopIndex", this.stopIndex).toString();
    }

    public static ImmutableSpan of(int startIndex, int stopIndex) {
        return new ImmutableSpan(startIndex, stopIndex);
    }

    public static ImmutableSpan copyOf(Span instance) {
        if (instance instanceof ImmutableSpan) {
            return (ImmutableSpan)instance;
        }
        return ImmutableSpan.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Span", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_START_INDEX = 1L;
        private static final long INIT_BIT_STOP_INDEX = 2L;
        private long initBits = 3L;
        private int startIndex;
        private int stopIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Span instance) {
            Objects.requireNonNull(instance, "instance");
            this.startIndex(instance.getStartIndex());
            this.stopIndex(instance.getStopIndex());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder startIndex(int startIndex) {
            this.startIndex = startIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stopIndex(int stopIndex) {
            this.stopIndex = stopIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSpan build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSpan(this.startIndex, this.stopIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("startIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stopIndex");
            }
            return "Cannot build Span, some of required attributes are not set " + attributes;
        }
    }
}

