/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import com.google.common.base.CaseFormat;
import io.dialob.rule.parser.DialobRuleBaseListener;
import io.dialob.rule.parser.DialobRuleParser;
import io.dialob.rule.parser.ParserUtil;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import io.dialob.rule.parser.api.VariableNotDefinedException;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.ErrorLogger;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.Span;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTBuilderWalker
extends DialobRuleBaseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASTBuilderWalker.class);
    private final String namespace;
    private final VariableFinder variableFinder;
    private ASTBuilder builder;
    private final Map<NodeBase, String> asyncFunctionVariables;
    private ErrorLogger errorLogger = new ErrorLogger(){

        @Override
        public void logError(String errorCode, Span span) {
            LOGGER.error("Compiler error {} at {}", (Object)errorCode, (Object)span);
        }

        @Override
        public void logError(String errorCode, Object[] args, Span span) {
            LOGGER.error("Compiler error {} : {} at {}", new Object[]{errorCode, args, span});
        }
    };
    public static final VariableFinder DUMMY_VARIABLE_FINDER = new VariableFinder(){

        @Override
        @Nullable
        public String getScope() {
            return null;
        }

        @Override
        public ValueType typeOf(String variableName) {
            return null;
        }

        @Override
        public ValueType returnTypeOf(String functionName, ValueType ... argTypes) {
            return null;
        }

        @Override
        public boolean isAsync(String functionName) {
            return false;
        }
    };

    public ASTBuilderWalker(@NotNull VariableFinder variableFinder, Map<NodeBase, String> asyncFunctionVariables) {
        this(null, variableFinder, asyncFunctionVariables);
    }

    ASTBuilderWalker(String namespace, @NotNull VariableFinder variableFinder, Map<NodeBase, String> asyncFunctionVariables) {
        this.namespace = namespace;
        this.variableFinder = variableFinder;
        this.builder = new ASTBuilder();
        this.asyncFunctionVariables = asyncFunctionVariables;
    }

    public void setErrorLogger(ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    private void pop() {
        this.builder = this.builder.closeExpr();
    }

    public ASTBuilder getBuilder() {
        return this.builder;
    }

    protected List<ValueType> getLhsAndRhsValueTypes() {
        return this.builder.getTopNode().getSubnodes().stream().map(NodeBase::getValueType).collect(Collectors.toList());
    }

    protected NodeBase getLhs() {
        NodeBase node = this.builder.getTopNode();
        if (node instanceof CallExprNode) {
            CallExprNode callExprNode = (CallExprNode)node;
            return callExprNode.getLhs();
        }
        return null;
    }

    protected NodeBase getRhs() {
        NodeBase node = this.builder.getTopNode();
        if (node instanceof CallExprNode) {
            CallExprNode callExprNode = (CallExprNode)node;
            return callExprNode.getRhs();
        }
        return null;
    }

    @Override
    public void enterNotExpr(DialobRuleParser.NotExprContext ctx) {
        this.builder = this.builder.notExprNode(Span.of(ctx)).setValueType(ValueType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitNotExpr(DialobRuleParser.NotExprContext ctx) {
        List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
        try {
            if (valueTypes.size() != 1) {
                this.errorLogger.logError("ONLY_ONE_ARGUMENT_FOR_NOT", Span.of(ctx));
                return;
            }
            ValueType valueType = valueTypes.get(0);
            if (valueType == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            if (valueType != ValueType.BOOLEAN) {
                this.errorLogger.logError("CANNOT_EVAL_NOT_FOR_NON_BOOLEAN_TYPE", new Object[]{valueType}, Span.of(ctx));
            }
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void enterInOperExpr(DialobRuleParser.InOperExprContext ctx) {
        boolean not = ctx.NOT() != null;
        this.builder = this.builder.logicExprNode(not ? "notIn" : "in", Span.of(ctx)).setValueType(ValueType.BOOLEAN);
    }

    @Override
    public void exitInOperExpr(DialobRuleParser.InOperExprContext ctx) {
        NodeBase lhs;
        IdExprNode idExprNode;
        NodeBase rhs = this.getRhs();
        if (rhs instanceof IdExprNode && ((idExprNode = (IdExprNode)rhs).getValueType() == null || !idExprNode.getValueType().isArray())) {
            this.errorLogger.logError("ARRAY_TYPE_EXPECTED", new Object[]{rhs}, rhs.getSpan());
        }
        if ((lhs = this.getLhs()).getValueType() != null && lhs.getValueType().isArray()) {
            this.errorLogger.logError("ARRAY_TYPE_UNEXPECTED", new Object[]{lhs}, lhs.getSpan());
        }
        this.pop();
    }

    @Override
    public void enterLogicExpr(DialobRuleParser.LogicExprContext ctx) {
        this.builder = this.builder.logicExprNode(ctx.op.getText(), Span.of(ctx)).setValueType(ValueType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitLogicExpr(DialobRuleParser.LogicExprContext ctx) {
        List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
        try {
            NodeBase node;
            String operator = ctx.op.getText();
            if (valueTypes.size() != 2) {
                this.errorLogger.logError("OPERATOR_REQUIRES_2_OPERANDS", new Object[]{operator}, Span.of(ctx));
                return;
            }
            ValueType lhs = valueTypes.get(0);
            ValueType rhs = valueTypes.get(1);
            if (lhs == null || rhs == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            if (lhs != ValueType.BOOLEAN) {
                node = this.builder.getTopNode().getSubnodes().get(0);
                this.errorLogger.logError("BOOLEAN_VALUE_EXPECTED", new Object[]{lhs, rhs}, node.getSpan());
            }
            if (rhs != ValueType.BOOLEAN) {
                node = this.builder.getTopNode().getSubnodes().get(1);
                this.errorLogger.logError("BOOLEAN_VALUE_EXPECTED", new Object[]{lhs, rhs}, node.getSpan());
            }
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void enterMatchesExpr(DialobRuleParser.MatchesExprContext ctx) {
        boolean not = ctx.NOT() != null;
        this.builder = this.builder.infixExprNode(not ? "notMatches" : "matches", Span.of(ctx)).setValueType(ValueType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitMatchesExpr(DialobRuleParser.MatchesExprContext ctx) {
        List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
        try {
            NodeBase node;
            String operator = ctx.op.getText();
            if (valueTypes.size() != 2) {
                this.errorLogger.logError("OPERATOR_REQUIRES_2_OPERANDS", new Object[]{operator}, Span.of(ctx));
                return;
            }
            ValueType lhs = valueTypes.get(0);
            ValueType rhs = valueTypes.get(1);
            if (lhs == null || rhs == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            if (lhs != ValueType.STRING) {
                node = this.builder.getTopNode().getSubnodes().get(0);
                this.errorLogger.logError("ONLY_STRINGS_CAN_BE_MATCHED", new Object[]{lhs}, node.getSpan());
            }
            if (rhs != ValueType.STRING) {
                node = this.builder.getTopNode().getSubnodes().get(1);
                this.errorLogger.logError("MATCHER_DEFINITION_NEEDS_TO_BE_STRING", new Object[]{rhs}, node.getSpan());
            }
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void enterRelationExpr(DialobRuleParser.RelationExprContext ctx) {
        this.builder = this.builder.relationExprNode(ctx.op.getText(), Span.of(ctx)).setValueType(ValueType.BOOLEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitRelationExpr(DialobRuleParser.RelationExprContext ctx) {
        NodeBase lhs = this.getLhs();
        NodeBase rhs = this.getRhs();
        try {
            String code;
            boolean ok;
            String operator = ctx.op.getText();
            if (rhs == null) {
                this.errorLogger.logError("OPERATOR_REQUIRES_2_OPERANDS", new Object[]{operator}, Span.of(ctx));
                return;
            }
            if (lhs.getValueType() == null || rhs.getValueType() == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            ConstExprNode stringConstant = null;
            ValueType coercionType = null;
            if (this.isConstantString(lhs) && !rhs.isConstant()) {
                stringConstant = (ConstExprNode)lhs;
                coercionType = rhs.getValueType();
            } else if (!lhs.isConstant() && this.isConstantString(rhs)) {
                stringConstant = (ConstExprNode)rhs;
                coercionType = lhs.getValueType();
            }
            if (stringConstant != null && coercionType != null && coercionType != ValueType.STRING) {
                this.coerce(stringConstant, coercionType);
            }
            switch (operator) {
                case "=": 
                case "!=": {
                    ok = lhs.getValueType().canEqualWith(rhs.getValueType());
                    code = "NO_EQUALITY_RELATION_BETWEEN_TYPES";
                    break;
                }
                default: {
                    ok = lhs.getValueType().canOrderWith(rhs.getValueType());
                    code = "NO_ORDER_RELATION_BETWEEN_TYPES";
                }
            }
            if (!ok) {
                this.errorLogger.logError(code, new Object[]{lhs.getValueType(), rhs.getValueType()}, Span.of(ctx));
            }
        }
        finally {
            this.pop();
        }
    }

    private void coerce(ConstExprNode stringConstant, ValueType coercionType) {
        if (coercionType == ValueType.DATE && stringConstant.getValue().matches("\\d{4}-\\d{2}-\\d{2}")) {
            stringConstant.setValueType(ValueType.DATE);
            return;
        }
        if (coercionType == ValueType.TIME && stringConstant.getValue().matches("\\d{2}:\\d{2}(:\\d{2}(\\.\\d{1,6})?)?")) {
            stringConstant.setValueType(ValueType.TIME);
            return;
        }
    }

    protected boolean isConstantString(NodeBase lhs) {
        return lhs.isConstant() && lhs.getValueType() == ValueType.STRING;
    }

    @Override
    public void enterNegateExpr(DialobRuleParser.NegateExprContext ctx) {
        this.builder = this.builder.unaryExprNode("neg", Span.of(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitNegateExpr(DialobRuleParser.NegateExprContext ctx) {
        List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
        try {
            if (valueTypes.size() != 1) {
                this.errorLogger.logError("ONLY_ONE_ARGUMENT_FOR_NEGATE", Span.of(ctx));
                return;
            }
            ValueType valueType = valueTypes.get(0);
            if (valueType == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            if (!valueType.isNegateable()) {
                this.errorLogger.logError("CANNOT_NEGATE_TYPE", new Object[]{valueType}, Span.of(ctx));
            }
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void enterInfixExpr(DialobRuleParser.InfixExprContext ctx) {
        this.builder = this.builder.infixExprNode(ctx.op.getText(), Span.of(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitInfixExpr(DialobRuleParser.InfixExprContext ctx) {
        List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
        try {
            ValueType resultType;
            String operator = ctx.op.getText();
            if (valueTypes.size() != 2) {
                this.errorLogger.logError("OPERATOR_REQUIRES_2_OPERANDS", new Object[]{operator}, Span.of(ctx));
                return;
            }
            ValueType lhs = valueTypes.get(0);
            ValueType rhs = valueTypes.get(1);
            String code = null;
            if (this.getLhs().isConstant() && operator.equals("-") && lhs == ValueType.STRING) {
                this.coerce((ConstExprNode)this.getLhs(), rhs);
                lhs = this.getLhs().getValueType();
            }
            if (this.getRhs().isConstant() && operator.equals("-") && rhs == ValueType.STRING) {
                this.coerce((ConstExprNode)this.getRhs(), lhs);
                rhs = this.getRhs().getValueType();
            }
            if (this.getLhs().isConstant() && operator.equals("+") && lhs == ValueType.STRING && (rhs == ValueType.PERIOD || rhs == ValueType.DURATION)) {
                this.coerce((ConstExprNode)this.getLhs(), ValueType.DATE);
                lhs = this.getLhs().getValueType();
            }
            if (lhs == null || rhs == null) {
                this.reportTypeAnalysisProblem(ctx);
                return;
            }
            switch (operator) {
                case "+": {
                    resultType = lhs.plusType(rhs);
                    code = "CANNOT_ADD_TYPES";
                    break;
                }
                case "-": {
                    resultType = lhs.minusType(rhs);
                    code = "CANNOT_SUBTRACT_TYPES";
                    break;
                }
                case "*": {
                    resultType = lhs.multiplyType(rhs);
                    code = "CANNOT_MULTIPLY_TYPES";
                    break;
                }
                case "/": {
                    resultType = lhs.divideByType(rhs);
                    code = "CANNOT_DIVIDE_TYPES";
                    break;
                }
                default: {
                    resultType = null;
                }
            }
            if (resultType == null) {
                this.errorLogger.logError(code, new Object[]{lhs, rhs}, Span.of(ctx));
            } else {
                this.builder.setValueType(resultType);
            }
        }
        finally {
            this.pop();
        }
    }

    private void reportTypeAnalysisProblem(ParserRuleContext ctx) {
        if (this.variableFinder != DUMMY_VARIABLE_FINDER) {
            this.errorLogger.logError("COULD_NOT_DEDUCE_TYPE", Span.of(ctx));
        }
    }

    @Override
    public void enterCallExpr(DialobRuleParser.CallExprContext ctx) {
        String function = ctx.func.getText();
        if (this.variableFinder.isAsync(function)) {
            this.builder = new ASTBuilder(this.builder);
        }
        this.builder = this.builder.callExprNode(function, Span.of(ctx));
    }

    @Override
    public void exitCallExpr(DialobRuleParser.CallExprContext ctx) {
        String function = ctx.func.getText();
        try {
            List<ValueType> valueTypes = this.getLhsAndRhsValueTypes();
            ValueType returnValueType = this.variableFinder.returnTypeOf(function, valueTypes.toArray(new ValueType[0]));
            if (returnValueType != null) {
                this.builder.setValueType(returnValueType);
            }
            if (this.variableFinder.isAsync(function)) {
                String replacementVariable = this.getOrCreateAsyncFunctionVariable(function, this.builder);
                this.builder = this.builder.getParentScopeBuilder();
                this.builder = this.builder.idExprNode(this.namespace, replacementVariable, returnValueType, Span.of(ctx));
            }
        }
        catch (VariableNotDefinedException e) {
            this.errorLogger.logError("UNKNOWN_FUNCTION", new Object[]{function}, Span.of(ctx));
        }
        this.pop();
    }

    @Override
    public void enterOfExpr(DialobRuleParser.OfExprContext ctx) {
        String reducer = ctx.left.getText();
        String op = reducer + "Of";
        this.builder = this.builder.reducerExprNode(op, Span.of(ctx));
    }

    @Override
    public void exitOfExpr(DialobRuleParser.OfExprContext ctx) {
        String oper = this.getBuilder().getTopNode().getNodeOperator().getOperator();
        NodeBase lhs = this.getLhs();
        if (lhs == null || !lhs.isIdentifier()) {
            this.errorLogger.logError("REDUCER_TARGET_MUST_BE_REFERENCE", new Object[]{oper}, Span.of(ctx));
        }
        if (this.variableFinder.getScope() != null) {
            this.errorLogger.logError("CANNOT_USE_REDUCER_INSIDE_SCOPE", new Object[0], Span.of(ctx));
        } else if (!ParserUtil.isReducerOperator(oper)) {
            this.errorLogger.logError("UNKNOWN_REDUCER_OPERATOR", new Object[]{oper}, Span.of(ctx));
        } else {
            try {
                ValueType valueType;
                if (lhs != null && (valueType = this.variableFinder.returnTypeOf(oper, lhs.getValueType())) != null) {
                    this.builder.setValueType(valueType);
                }
            }
            catch (VariableNotDefinedException e) {
                this.errorLogger.logError("UNKNOWN_REDUCER_OPERATOR", new Object[]{oper}, Span.of(ctx));
            }
        }
        this.pop();
    }

    private String getOrCreateAsyncFunctionVariable(String function, ASTBuilder builder) {
        NodeBase asyncFunctionAst = builder.getTopNode();
        return this.asyncFunctionVariables.computeIfAbsent(asyncFunctionAst, nodeBase -> {
            String name;
            String prefix = "$$" + function;
            int index = 0;
            while (this.asyncFunctionVariables.containsValue(name = prefix + "_" + ++index)) {
            }
            return name;
        });
    }

    @Override
    public void enterIdExprRule(DialobRuleParser.IdExprRuleContext ctx) {
        Token var = ctx.var;
        String id = var.getText();
        String variableId = this.variableFinder.mapAlias(id);
        try {
            ValueType valueType = this.variableFinder.typeOf(variableId);
            this.builder = this.variableFinder.findVariableScope(variableId).map(scopeId -> this.builder.idExprNode(this.namespace, (String)scopeId, variableId, valueType, Span.of(var))).orElseGet(() -> this.builder.idExprNode(this.namespace, variableId, valueType, Span.of(var)));
        }
        catch (VariableNotDefinedException e) {
            this.errorLogger.logError("UNKNOWN_VARIABLE", new Object[]{e.getMessage()}, Span.of(var));
            this.builder.idExprNode(this.namespace, variableId, null, Span.of(var));
        }
    }

    @Override
    public void exitIdExprRule(DialobRuleParser.IdExprRuleContext ctx) {
        this.pop();
    }

    @Override
    public void enterConstExprRule(DialobRuleParser.ConstExprRuleContext ctx) {
        String text = ctx.value.getText();
        if (ctx.type == ValueType.STRING && this.isQuoted(text)) {
            text = text.substring(1, text.length() - 1);
        }
        this.builder = this.builder.constExprNode(text, ctx.unit != null ? ctx.unit.getText() : null, ctx.type, Span.of(ctx));
    }

    protected boolean isQuoted(@NotNull String text) {
        return text.startsWith("'") && text.endsWith("'") || text.startsWith("\"") && text.endsWith("\"");
    }

    @Override
    public void exitConstExprRule(DialobRuleParser.ConstExprRuleContext ctx) {
        this.pop();
    }

    @Override
    public void visitErrorNode(ErrorNode errorNode) {
        this.errorLogger.logError("COMPILER_ERROR", Span.of(errorNode.getSymbol()));
    }

    @Override
    public void enterIsExpr(DialobRuleParser.IsExprContext ctx) {
        String status = ctx.status.getText();
        Object op = ctx.not == null ? "is-" + status : "is-not-" + status;
        op = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, (String)op);
        String variableId = this.variableFinder.mapAlias(ctx.questionId.getText());
        ValueType valueType = null;
        try {
            valueType = this.variableFinder.typeOf(variableId);
        }
        catch (VariableNotDefinedException e) {
            this.errorLogger.logError("UNKNOWN_VARIABLE", new Object[]{e.getMessage()}, Span.of(ctx.questionId));
        }
        if (valueType != ValueType.STRING && "blank".equalsIgnoreCase(status)) {
            this.errorLogger.logError("STRING_VALUE_EXPECTED", new Object[0], Span.of(ctx.questionId));
        }
        this.builder = this.builder.callExprNode((String)op, ValueType.BOOLEAN, Span.of(ctx)).idExprNode(this.namespace, variableId, valueType, Span.of(ctx.questionId)).closeExpr();
    }

    @Override
    public void exitIsExpr(DialobRuleParser.IsExprContext ctx) {
        this.pop();
    }

    public String toString() {
        return this.builder.toString();
    }
}

