/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.ImmutableSpan;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ASTBuilderTest {
    ASTBuilderTest() {
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfBuildCalledTooEarl() {
        ASTBuilder astBuilder = new ASTBuilder();
        astBuilder.idExprNode(null, "x", ValueType.BOOLEAN, (Span)ImmutableSpan.of((int)0, (int)1));
        Assertions.assertThrows(IllegalStateException.class, () -> astBuilder.build());
    }

    @Test
    public void shouldCreateIdNode() {
        ASTBuilder astBuilder = new ASTBuilder();
        astBuilder.idExprNode(null, "x", ValueType.BOOLEAN, (Span)ImmutableSpan.of((int)0, (int)1)).closeExpr();
        NodeBase nodeBase = astBuilder.build();
        Assertions.assertEquals((Object)"x", (Object)nodeBase.toString());
        Assertions.assertEquals((Object)ValueType.BOOLEAN, (Object)nodeBase.getValueType());
        Assertions.assertEquals((Object)"$id", (Object)nodeBase.getNodeOperator().getOperator());
        Assertions.assertEquals((int)1, (int)nodeBase.getAllDependencies().size());
        Assertions.assertEquals((Object)ValueType.BOOLEAN, nodeBase.getAllDependencies().get("x"));
        Assertions.assertNull((Object)nodeBase.getParent());
    }

    @Test
    public void shouldCreateCallNode() {
        ASTBuilder astBuilder = new ASTBuilder();
        astBuilder.callExprNode("func", ValueType.BOOLEAN, (Span)ImmutableSpan.of((int)0, (int)4)).closeExpr();
        NodeBase nodeBase = astBuilder.build();
        Assertions.assertEquals((Object)"(func)", (Object)nodeBase.toString());
        Assertions.assertEquals((Object)ValueType.BOOLEAN, (Object)nodeBase.getValueType());
        Assertions.assertEquals((Object)"func", (Object)nodeBase.getNodeOperator().getOperator());
        Assertions.assertEquals((int)0, (int)nodeBase.getAllDependencies().size());
        Assertions.assertNull(nodeBase.getAllDependencies().get("func"));
        Assertions.assertNull((Object)nodeBase.getParent());
    }
}

