/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.Expression;
import io.dialob.rule.parser.ExpressionMerger;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExpressionMergerTest {
    @Test
    public void test() throws Exception {
        this.assertExpressionMerge("1 + 2 + 3 + 4", "(+ 1 2 3 4)");
        this.assertExpressionMerge("1 + 2", "(+ 1 2)");
        this.assertExpressionMerge("1 - 1", "(- 1 1)");
        this.assertExpressionMerge("1 - 1 - 2", "(- 1 1 2)");
        this.assertExpressionMerge("1 - 1 - 2 + 1", "(+ (- 1 1 2) 1)");
        this.assertExpressionMerge("1 + 2 + 3 - 3 + 2 + 1", "(+ (- (+ 1 2 3) 3) 2 1)");
        this.assertExpressionMerge("-1 + 2 + 3 - 3 + 2 + 1 = -8 * 9 + -2 + 6", "(= (+ (- (+ (neg 1) 2 3) 3) 2 1) (+ (* (neg 8) 9) (neg 2) 6))");
    }

    private void assertExpressionMerge(String expression, String expected) {
        NodeBase ast = Expression.createExpression((String)expression).getAst();
        ExpressionMerger expressionMerger = new ExpressionMerger();
        ast.accept((ASTVisitor)expressionMerger);
        Assertions.assertEquals((Object)expected, (Object)expressionMerger.getAstBuilder().getTopNode().toString());
    }
}

