/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.api.VariableFinder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="VariableFinder", generator="Immutables")
public final class ImmutableVariableFinder {
    private ImmutableVariableFinder() {
    }

    @CheckReturnValue
    @Generated(from="VariableFinder.Function", generator="Immutables")
    @Immutable
    public static final class Function
    implements VariableFinder.Function {
        private final String name;
        private final ValueType valueType;
        private final boolean isAsync;

        private Function(String name, ValueType valueType, boolean isAsync) {
            this.name = name;
            this.valueType = valueType;
            this.isAsync = isAsync;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public boolean isAsync() {
            return this.isAsync;
        }

        public final Function withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Function(newValue, this.valueType, this.isAsync);
        }

        public final Function withValueType(ValueType value) {
            if (this.valueType == value) {
                return this;
            }
            ValueType newValue = Objects.requireNonNull(value, "valueType");
            return new Function(this.name, newValue, this.isAsync);
        }

        public final Function withIsAsync(boolean value) {
            if (this.isAsync == value) {
                return this;
            }
            return new Function(this.name, this.valueType, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Function && this.equalTo((Function)another);
        }

        private boolean equalTo(Function another) {
            return this.name.equals(another.name) && this.valueType.equals(another.valueType) && this.isAsync == another.isAsync;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.valueType.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.isAsync);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Function").omitNullValues().add("name", (Object)this.name).add("valueType", (Object)this.valueType).add("isAsync", this.isAsync).toString();
        }

        public static Function copyOf(VariableFinder.Function instance) {
            if (instance instanceof Function) {
                return (Function)instance;
            }
            return Function.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="VariableFinder.Function", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_VALUE_TYPE = 2L;
            private static final long INIT_BIT_IS_ASYNC = 4L;
            private long initBits = 7L;
            @Nullable
            private String name;
            @Nullable
            private ValueType valueType;
            private boolean isAsync;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(VariableFinder.Var instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(VariableFinder.Function instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                VariableFinder.Var instance;
                if (object instanceof VariableFinder.Var) {
                    instance = (VariableFinder.Var)object;
                    this.name(instance.getName());
                    this.valueType(instance.getValueType());
                }
                if (object instanceof VariableFinder.Function) {
                    instance = (VariableFinder.Function)object;
                    this.isAsync(instance.isAsync());
                }
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder valueType(ValueType valueType) {
                this.valueType = Objects.requireNonNull(valueType, "valueType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder isAsync(boolean isAsync) {
                this.isAsync = isAsync;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Function build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Function(this.name, this.valueType, this.isAsync);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("valueType");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("isAsync");
                }
                return "Cannot build Function, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="VariableFinder.Variable", generator="Immutables")
    @Immutable
    public static final class Variable
    implements VariableFinder.Variable {
        private final String name;
        private final ValueType valueType;
        @Nullable
        private final String scope;
        @Nullable
        private final Object placeHolderValue;
        @Nullable
        private final String valueSetId;

        private Variable(String name, ValueType valueType, @Nullable String scope, @Nullable Object placeHolderValue, @Nullable String valueSetId) {
            this.name = name;
            this.valueType = valueType;
            this.scope = scope;
            this.placeHolderValue = placeHolderValue;
            this.valueSetId = valueSetId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public Optional<String> getScope() {
            return Optional.ofNullable(this.scope);
        }

        @Override
        public Optional<Object> getPlaceHolderValue() {
            return Optional.ofNullable(this.placeHolderValue);
        }

        @Override
        public Optional<String> getValueSetId() {
            return Optional.ofNullable(this.valueSetId);
        }

        public final Variable withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Variable(newValue, this.valueType, this.scope, this.placeHolderValue, this.valueSetId);
        }

        public final Variable withValueType(ValueType value) {
            if (this.valueType == value) {
                return this;
            }
            ValueType newValue = Objects.requireNonNull(value, "valueType");
            return new Variable(this.name, newValue, this.scope, this.placeHolderValue, this.valueSetId);
        }

        public final Variable withScope(String value) {
            String newValue = Objects.requireNonNull(value, "scope");
            if (Objects.equals(this.scope, newValue)) {
                return this;
            }
            return new Variable(this.name, this.valueType, newValue, this.placeHolderValue, this.valueSetId);
        }

        public final Variable withScope(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.scope, value)) {
                return this;
            }
            return new Variable(this.name, this.valueType, value, this.placeHolderValue, this.valueSetId);
        }

        public final Variable withPlaceHolderValue(Object value) {
            Object newValue = Objects.requireNonNull(value, "placeHolderValue");
            if (this.placeHolderValue == newValue) {
                return this;
            }
            return new Variable(this.name, this.valueType, this.scope, newValue, this.valueSetId);
        }

        public final Variable withPlaceHolderValue(Optional<? extends Object> optional) {
            Object value = optional.orElse(null);
            if (this.placeHolderValue == value) {
                return this;
            }
            return new Variable(this.name, this.valueType, this.scope, value, this.valueSetId);
        }

        public final Variable withValueSetId(String value) {
            String newValue = Objects.requireNonNull(value, "valueSetId");
            if (Objects.equals(this.valueSetId, newValue)) {
                return this;
            }
            return new Variable(this.name, this.valueType, this.scope, this.placeHolderValue, newValue);
        }

        public final Variable withValueSetId(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.valueSetId, value)) {
                return this;
            }
            return new Variable(this.name, this.valueType, this.scope, this.placeHolderValue, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Variable && this.equalTo((Variable)another);
        }

        private boolean equalTo(Variable another) {
            return this.name.equals(another.name) && this.valueType.equals(another.valueType) && Objects.equals(this.scope, another.scope) && Objects.equals(this.placeHolderValue, another.placeHolderValue) && Objects.equals(this.valueSetId, another.valueSetId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.valueType.hashCode();
            h += (h << 5) + Objects.hashCode(this.scope);
            h += (h << 5) + Objects.hashCode(this.placeHolderValue);
            h += (h << 5) + Objects.hashCode(this.valueSetId);
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Variable").omitNullValues().add("name", (Object)this.name).add("valueType", (Object)this.valueType).add("scope", (Object)this.scope).add("placeHolderValue", this.placeHolderValue).add("valueSetId", (Object)this.valueSetId).toString();
        }

        public static Variable copyOf(VariableFinder.Variable instance) {
            if (instance instanceof Variable) {
                return (Variable)instance;
            }
            return Variable.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="VariableFinder.Variable", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_VALUE_TYPE = 2L;
            private long initBits = 3L;
            @Nullable
            private String name;
            @Nullable
            private ValueType valueType;
            @Nullable
            private String scope;
            @Nullable
            private Object placeHolderValue;
            @Nullable
            private String valueSetId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(VariableFinder.Variable instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(VariableFinder.Var instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                VariableFinder.Var instance;
                if (object instanceof VariableFinder.Variable) {
                    Optional<String> scopeOptional;
                    Optional<String> valueSetIdOptional;
                    instance = (VariableFinder.Variable)object;
                    Optional<Object> placeHolderValueOptional = instance.getPlaceHolderValue();
                    if (placeHolderValueOptional.isPresent()) {
                        this.placeHolderValue(placeHolderValueOptional);
                    }
                    if ((valueSetIdOptional = instance.getValueSetId()).isPresent()) {
                        this.valueSetId(valueSetIdOptional);
                    }
                    if ((scopeOptional = instance.getScope()).isPresent()) {
                        this.scope(scopeOptional);
                    }
                }
                if (object instanceof VariableFinder.Var) {
                    instance = (VariableFinder.Var)object;
                    this.name(instance.getName());
                    this.valueType(instance.getValueType());
                }
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder valueType(ValueType valueType) {
                this.valueType = Objects.requireNonNull(valueType, "valueType");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder scope(String scope) {
                this.scope = Objects.requireNonNull(scope, "scope");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder scope(Optional<String> scope) {
                this.scope = scope.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder placeHolderValue(Object placeHolderValue) {
                this.placeHolderValue = Objects.requireNonNull(placeHolderValue, "placeHolderValue");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder placeHolderValue(Optional<? extends Object> placeHolderValue) {
                this.placeHolderValue = placeHolderValue.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder valueSetId(String valueSetId) {
                this.valueSetId = Objects.requireNonNull(valueSetId, "valueSetId");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder valueSetId(Optional<String> valueSetId) {
                this.valueSetId = valueSetId.orElse(null);
                return this;
            }

            public Variable build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Variable(this.name, this.valueType, this.scope, this.placeHolderValue, this.valueSetId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("valueType");
                }
                return "Cannot build Variable, some of required attributes are not set " + attributes;
            }
        }
    }
}

