/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.analyze;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import org.jetbrains.annotations.NotNull;

public class NotExpressionVisitor
implements ASTVisitor {
    @Override
    public ASTVisitor visitCallExpr(@NotNull CallExprNode node) {
        if (node.getNodeOperator().isNotOp()) {
            return null;
        }
        return this;
    }

    @Override
    @NotNull
    public NodeBase endCallExpr(@NotNull CallExprNode node) {
        if (node.getNodeOperator().isRelation() || node.getNodeOperator().isLogical() || node.getNodeOperator().getCategory() == NodeOperator.Category.FUNCTION) {
            if (node.getNodeOperator().getOperator().equals("not")) {
                return node.getLhs();
            }
            NodeOperator newOperator = node.getNodeOperator().not();
            CallExprNode callExprNode = (CallExprNode)new ASTBuilder().callExprNode(newOperator, node.getValueType(), node.getSpan()).closeExpr().build();
            node.getSubnodes().forEach(callExprNode::addSubnode);
            return callExprNode;
        }
        return node;
    }

    @Override
    @NotNull
    public NodeBase visitConstExpr(@NotNull ConstExprNode node) {
        if (node.getValueType() == ValueType.BOOLEAN) {
            Boolean value = (Boolean)node.getAsValueType();
            value = value == false;
            return new ASTBuilder().constExprNode(value.toString(), null, ValueType.BOOLEAN, node.getSpan()).closeExpr().build();
        }
        return node;
    }

    @Override
    @NotNull
    public NodeBase visitIdExpr(@NotNull IdExprNode node) {
        if (node.getValueType() == ValueType.BOOLEAN) {
            return new ASTBuilder().callExprNode(NodeOperator.createNodeOperator("not"), ValueType.BOOLEAN, node.getSpan()).idExprNode(node).closeExpr().closeExpr().build();
        }
        return node;
    }
}

