/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import io.dialob.rule.parser.api.ValueType;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayValueTypeTest {
    @Test
    public void shouldGetArrayClassOfValueType() {
        Assertions.assertSame(Integer[].class, (Object)ValueType.arrayOf((ValueType)ValueType.INTEGER).getTypeClass());
        Assertions.assertSame(String[].class, (Object)ValueType.arrayOf((ValueType)ValueType.STRING).getTypeClass());
        Assertions.assertSame(LocalDate[].class, (Object)ValueType.arrayOf((ValueType)ValueType.DATE).getTypeClass());
        Assertions.assertSame(LocalTime[].class, (Object)ValueType.arrayOf((ValueType)ValueType.TIME).getTypeClass());
        Assertions.assertSame(BigDecimal[].class, (Object)ValueType.arrayOf((ValueType)ValueType.DECIMAL).getTypeClass());
        Assertions.assertSame(Duration[].class, (Object)ValueType.arrayOf((ValueType)ValueType.DURATION).getTypeClass());
        Assertions.assertSame(Period[].class, (Object)ValueType.arrayOf((ValueType)ValueType.PERIOD).getTypeClass());
        Assertions.assertSame(Boolean[].class, (Object)ValueType.arrayOf((ValueType)ValueType.BOOLEAN).getTypeClass());
    }

    @Test
    public void shouldGetArrayClassOfArray() {
        Assertions.assertSame(Integer[][].class, (Object)ValueType.arrayOf((ValueType)ValueType.arrayOf((ValueType)ValueType.INTEGER)).getTypeClass());
    }

    @Test
    public void shouldParseArrayStrings() {
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])((Integer[])ValueType.arrayOf((ValueType)ValueType.INTEGER).parseFromString("[1,2,3]")));
    }
}

