/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import io.dialob.rule.parser.node.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallExprNode
extends NodeBase {
    private static final long serialVersionUID = 9169421768436062924L;
    private List<NodeBase> arguments = new ArrayList<NodeBase>();
    @NotNull
    private final NodeOperator nodeOperator;

    public CallExprNode(NodeBase parent, @NotNull NodeOperator nodeOperator, Span span) {
        this(parent, nodeOperator, null, span);
    }

    public CallExprNode(NodeBase parent, @NotNull NodeOperator nodeOperator, ValueType type, Span span) {
        super(parent, span, type);
        this.nodeOperator = Objects.requireNonNull(nodeOperator);
    }

    @Override
    public CallExprNode addSubnode(@NotNull NodeBase node) {
        node.setParent(this);
        this.arguments.add(node);
        return this;
    }

    @Override
    @NotNull
    public NodeOperator getNodeOperator() {
        return this.nodeOperator;
    }

    public String toString() {
        return "(" + this.nodeOperator + (this.arguments.isEmpty() ? "" : " ") + StringUtils.join(this.arguments, (String)" ") + ")";
    }

    @Nullable
    public <T extends NodeBase> T getLhs() {
        return (T)((NodeBase)this.arguments.stream().findFirst().orElse(null));
    }

    @Nullable
    public <T extends NodeBase> T getRhs() {
        return (T)((NodeBase)this.arguments.stream().skip(1L).findFirst().orElse(null));
    }

    @Override
    public String toTypedString() {
        return "(" + this.nodeOperator + "[" + this.getValueType() + "]" + (this.arguments.isEmpty() ? "" : " ") + this.arguments.stream().map(NodeBase::toTypedString).collect(Collectors.joining(" ")) + ")";
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            return this.toString();
        }
        if (this.arguments.isEmpty()) {
            return indent + "(" + this.nodeOperator + ")\n";
        }
        if (!this.arguments.stream().anyMatch(node -> node instanceof CallExprNode)) {
            return indent + "(" + this.nodeOperator + " " + this.arguments.stream().map(Object::toString).collect(Collectors.joining(" ")) + ")";
        }
        return indent + "(" + this.nodeOperator + "\n" + this.arguments.stream().map(node -> node.toString(indent + "  ")).collect(Collectors.joining("\n")) + ")";
    }

    @Override
    @NotNull
    public List<NodeBase> getSubnodes() {
        return this.arguments;
    }

    @Override
    public NodeBase accept(@NotNull ASTVisitor visitor) {
        ASTVisitor subvisitor = visitor.visitCallExpr(this);
        if (subvisitor != null) {
            int i = 0;
            int j = 0;
            NodeBase[] nodes = this.arguments.toArray(new NodeBase[0]);
            while (i < nodes.length) {
                NodeBase replaceNode;
                if ((replaceNode = nodes[i++].accept(subvisitor)) != null) {
                    replaceNode.setParent(this);
                }
                nodes[j++] = replaceNode;
            }
            if (j < nodes.length) {
                nodes = Arrays.copyOf(nodes, j);
            }
            this.arguments = Arrays.asList(nodes);
        }
        return visitor.endCallExpr(this);
    }

    @Override
    @NotNull
    public Map<String, ValueType> getDependencies() {
        HashMap<String, ValueType> dependencies = new HashMap<String, ValueType>();
        for (NodeBase argument : this.arguments) {
            CallExprNode callExprNode;
            if (!this.getNodeOperator().isOrOp() && argument instanceof CallExprNode && (callExprNode = (CallExprNode)argument).getNodeOperator().isOrOp()) continue;
            dependencies.putAll(argument.getDependencies());
        }
        return dependencies;
    }

    @Override
    public Map<String, ValueType> getAllDependencies() {
        HashMap<String, ValueType> dependencies = new HashMap<String, ValueType>();
        for (NodeBase argument : this.arguments) {
            dependencies.putAll(argument.getAllDependencies());
        }
        return dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallExprNode)) {
            return false;
        }
        CallExprNode other = (CallExprNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<NodeBase> this$arguments = this.arguments;
        List<NodeBase> other$arguments = other.arguments;
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        NodeOperator this$nodeOperator = this.getNodeOperator();
        NodeOperator other$nodeOperator = other.getNodeOperator();
        return !(this$nodeOperator == null ? other$nodeOperator != null : !((Object)this$nodeOperator).equals(other$nodeOperator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallExprNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<NodeBase> $arguments = this.arguments;
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        NodeOperator $nodeOperator = this.getNodeOperator();
        result = result * 59 + ($nodeOperator == null ? 43 : ((Object)$nodeOperator).hashCode());
        return result;
    }
}

