/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.node;

import io.dialob.rule.parser.api.ValueType;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueTypeTest {
    @Test
    public void booleanIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.BOOLEAN.parseFromString(null));
        Assertions.assertTrue((boolean)((Boolean)ValueType.BOOLEAN.parseFromString("true")));
        Assertions.assertFalse((boolean)((Boolean)ValueType.BOOLEAN.parseFromString("false")));
    }

    @Test
    public void booleanReduction() {
        Assertions.assertTrue((boolean)((Boolean)Arrays.asList(true, true, true).stream().reduce(ValueType.BOOLEAN.multOp()).get()));
        Assertions.assertFalse((boolean)((Boolean)Arrays.asList(true, false, true).stream().reduce(ValueType.BOOLEAN.multOp()).get()));
        Assertions.assertTrue((boolean)((Boolean)Arrays.asList(true, true, true).stream().reduce(ValueType.BOOLEAN.sumOp()).get()));
        Assertions.assertFalse((boolean)((Boolean)Arrays.asList(false, false, false).stream().reduce(ValueType.BOOLEAN.multOp()).get()));
    }

    @Test
    public void integerIsParseable() throws Exception {
        Assertions.assertNull((Object)ValueType.INTEGER.parseFromString(null));
        Assertions.assertEquals((Object)0, (Object)ValueType.INTEGER.parseFromString("0"));
    }

    @Test
    public void integerReduction() {
        Assertions.assertEquals((Integer)6, (Integer)((Integer)Arrays.asList(1, 2, 3).stream().reduce(ValueType.INTEGER.multOp()).get()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)Arrays.asList(1, 2, 3).stream().reduce(ValueType.INTEGER.sumOp()).get()));
        Assertions.assertEquals((Integer)24, (Integer)((Integer)Arrays.asList(1, 2, 3, 4).stream().reduce(ValueType.INTEGER.multOp()).get()));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)Arrays.asList(1, 2, 3, 4).stream().reduce(ValueType.INTEGER.sumOp()).get()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)Arrays.asList(1, 2, 3, 4, 0).stream().reduce(ValueType.INTEGER.multOp()).get()));
        Assertions.assertEquals((Integer)10, (Integer)((Integer)Arrays.asList(1, 2, 3, 4, 0).stream().reduce(ValueType.INTEGER.sumOp()).get()));
    }

    @Test
    public void decimalIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.DECIMAL.parseFromString(null));
        Assertions.assertEquals((Object)BigDecimal.valueOf(0.1), (Object)ValueType.DECIMAL.parseFromString("0.1"));
    }

    @Test
    public void dateIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.DATE.parseFromString(null));
        Assertions.assertEquals((Object)LocalDate.of(2016, 2, 1), (Object)ValueType.DATE.parseFromString("2016-02-01"));
    }

    @Test
    public void timeIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.TIME.parseFromString(null));
        Assertions.assertEquals((Object)LocalTime.of(23, 45, 10), (Object)ValueType.TIME.parseFromString("23:45:10"));
    }

    @Test
    public void periodIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.PERIOD.parseFromString(null));
        Assertions.assertEquals((Object)Period.of(10, 3, 15), (Object)ValueType.PERIOD.parseFromString("P10Y3M15D"));
    }

    @Test
    public void durationIsParseAble() throws Exception {
        Assertions.assertNull((Object)ValueType.DURATION.parseFromString(null));
        Assertions.assertEquals((Object)Duration.ofDays(100L).plusHours(2L), (Object)ValueType.DURATION.parseFromString("P100DT2H"));
    }

    @Test
    public void checkReturnTypeMapping() {
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.valueTypeOf(String.class));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.valueTypeOf(BigDecimal.class));
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.valueTypeOf(Integer.class));
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.valueTypeOf(Integer.TYPE));
        Assertions.assertEquals((Object)ValueType.DATE, (Object)ValueType.valueTypeOf(LocalDate.class));
        Assertions.assertEquals((Object)ValueType.TIME, (Object)ValueType.valueTypeOf(LocalTime.class));
        Assertions.assertEquals((Object)ValueType.DURATION, (Object)ValueType.valueTypeOf(Duration.class));
        Assertions.assertEquals((Object)ValueType.PERIOD, (Object)ValueType.valueTypeOf(Period.class));
        Assertions.assertEquals((Object)ValueType.BOOLEAN, (Object)ValueType.valueTypeOf(Boolean.class));
        Assertions.assertEquals((Object)ValueType.BOOLEAN, (Object)ValueType.valueTypeOf(Boolean.TYPE));
        Assertions.assertNull((Object)ValueType.valueTypeOf(Class.class));
    }

    @Test
    public void plusTypeReturnTypes() {
        Assertions.assertEquals((Object)ValueType.DATE, (Object)ValueType.DATE.plusType(ValueType.PERIOD));
        Assertions.assertEquals((Object)ValueType.TIME, (Object)ValueType.TIME.plusType(ValueType.DURATION));
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.INTEGER.plusType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.INTEGER.plusType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.plusType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.plusType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.STRING.plusType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.STRING.plusType(ValueType.PERIOD));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.STRING.plusType(ValueType.DURATION));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.STRING.plusType(ValueType.BOOLEAN));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.TIME.plusType(ValueType.STRING));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.DECIMAL.plusType(ValueType.STRING));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.PERIOD.plusType(ValueType.STRING));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.DURATION.plusType(ValueType.STRING));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.BOOLEAN.plusType(ValueType.STRING));
        Assertions.assertEquals((Object)ValueType.STRING, (Object)ValueType.TIME.plusType(ValueType.STRING));
    }

    @Test
    public void minusTypeReturnTypes() {
        Assertions.assertEquals((Object)ValueType.PERIOD, (Object)ValueType.DATE.minusType(ValueType.DATE));
        Assertions.assertEquals((Object)ValueType.DURATION, (Object)ValueType.TIME.minusType(ValueType.TIME));
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.INTEGER.minusType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.INTEGER.minusType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.minusType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.minusType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.TIME, (Object)ValueType.TIME.minusType(ValueType.DURATION));
        Assertions.assertEquals((Object)ValueType.DATE, (Object)ValueType.DATE.minusType(ValueType.PERIOD));
    }

    @Test
    public void multipleTypeReturnTypes() {
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.INTEGER.multiplyType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.INTEGER.multiplyType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.multiplyType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.multiplyType(ValueType.DECIMAL));
    }

    @Test
    public void divideTypeReturnTypes() {
        Assertions.assertEquals((Object)ValueType.INTEGER, (Object)ValueType.INTEGER.divideByType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.INTEGER.divideByType(ValueType.DECIMAL));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.divideByType(ValueType.INTEGER));
        Assertions.assertEquals((Object)ValueType.DECIMAL, (Object)ValueType.DECIMAL.divideByType(ValueType.DECIMAL));
    }

    @Test
    public void valueTypeNames() {
        Assertions.assertEquals((Object)"INTEGER", (Object)ValueType.INTEGER.getName());
        Assertions.assertEquals((Object)"DATE", (Object)ValueType.DATE.getName());
        Assertions.assertEquals((Object)"DECIMAL", (Object)ValueType.DECIMAL.getName());
        Assertions.assertEquals((Object)"TIME", (Object)ValueType.TIME.getName());
        Assertions.assertEquals((Object)"PERIOD", (Object)ValueType.PERIOD.getName());
        Assertions.assertEquals((Object)"DURATION", (Object)ValueType.DURATION.getName());
        Assertions.assertEquals((Object)"DECIMAL", (Object)ValueType.DECIMAL.getName());
        Assertions.assertEquals((Object)"BOOLEAN", (Object)ValueType.BOOLEAN.getName());
        Assertions.assertEquals((Object)"[STRING]", (Object)ValueType.arrayOf((ValueType)ValueType.STRING).getName());
    }
}

