/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.modifier;

import io.dialob.rule.parser.AstMatcher;
import io.dialob.rule.parser.CloneVisitor;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;

public class ModifyingMinifierVisitor
extends AstMatcher {
    public ModifyingMinifierVisitor() {
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operator(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is("+"), ModifyingMinifierVisitor.is("-"), ModifyingMinifierVisitor.is("*"), ModifyingMinifierVisitor.is("neg"))).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.is(ValueType.INTEGER))))))), node -> {
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            if (arguments.isEmpty()) {
                return null;
            }
            if ("neg".equals(callNode.getNodeOperator().getOperator())) {
                assert (arguments.size() == 1);
                ConstExprNode constExprNode = (ConstExprNode)arguments.get(0);
                return new ConstExprNode(node.getParent(), Integer.toString(-((Integer)constExprNode.getAsValueType()).intValue()), null, ValueType.INTEGER, node.getSpan());
            }
            Integer sum = null;
            BinaryOperator op = null;
            if (callNode.getNodeOperator().isPlusOp()) {
                op = (integer, integer2) -> integer != null && integer2 != null ? Integer.valueOf(integer + integer2) : null;
            } else if (callNode.getNodeOperator().isMinusOp()) {
                op = (integer, integer2) -> integer != null && integer2 != null ? Integer.valueOf(integer - integer2) : null;
            } else if (callNode.getNodeOperator().isMultOp()) {
                op = (integer, integer2) -> integer != null && integer2 != null ? Integer.valueOf(integer * integer2) : null;
            }
            for (NodeBase arg : arguments) {
                Object value = ((ConstExprNode)arg).getAsValueType();
                if (sum == null) {
                    sum = (Integer)value;
                    continue;
                }
                sum = (Integer)op.apply(sum, (Integer)value);
            }
            return new ConstExprNode(node.getParent(), Integer.toString(sum), null, ValueType.INTEGER, node.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operator(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is("+"), ModifyingMinifierVisitor.is("-"))).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.is(ValueType.PERIOD))))))), node -> {
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            if (arguments.isEmpty()) {
                return null;
            }
            if ("neg".equals(callNode.getNodeOperator().getOperator())) {
                assert (arguments.size() == 1);
                ConstExprNode constExprNode = (ConstExprNode)arguments.get(0);
                return new ConstExprNode(node.getParent(), ((Period)constExprNode.getAsValueType()).negated().toString(), null, ValueType.PERIOD, node.getSpan());
            }
            Period sum = null;
            BinaryOperator op = null;
            if (callNode.getNodeOperator().isPlusOp()) {
                op = (period, period2) -> period != null && period2 != null ? period.plus((TemporalAmount)period2).normalized() : null;
            } else if (callNode.getNodeOperator().isMinusOp()) {
                op = (period, period2) -> period != null && period2 != null ? period.minus((TemporalAmount)period2).normalized() : null;
            }
            for (NodeBase arg : arguments) {
                Object value = ((ConstExprNode)arg).getAsValueType();
                if (sum == null) {
                    sum = (Period)value;
                    continue;
                }
                sum = (Period)op.apply(sum, (Period)value);
            }
            return new ConstExprNode(node.getParent(), sum.toString(), null, ValueType.PERIOD, node.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operator(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is("+"), ModifyingMinifierVisitor.is("-"))).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.is(ValueType.DURATION))))))), node -> {
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            if (arguments.isEmpty()) {
                return null;
            }
            if ("neg".equals(callNode.getNodeOperator().getOperator())) {
                assert (arguments.size() == 1);
                ConstExprNode constExprNode = (ConstExprNode)arguments.get(0);
                return new ConstExprNode(node.getParent(), ((Duration)constExprNode.getAsValueType()).negated().toString(), null, ValueType.DURATION, node.getSpan());
            }
            Duration sum = null;
            BinaryOperator op = null;
            if (callNode.getNodeOperator().isPlusOp()) {
                op = (duration, duration2) -> duration != null && duration2 != null ? duration.plus((Duration)duration2) : null;
            } else if (callNode.getNodeOperator().isMinusOp()) {
                op = (duration, duration2) -> duration != null && duration2 != null ? duration.minus((Duration)duration2) : null;
            }
            for (NodeBase arg : arguments) {
                Object value = ((ConstExprNode)arg).getAsValueType();
                if (sum == null) {
                    sum = (Duration)value;
                    continue;
                }
                sum = (Duration)op.apply(sum, (Duration)value);
            }
            return new ConstExprNode(node.getParent(), sum.toString(), null, ValueType.DURATION, node.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operator(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is("+"), ModifyingMinifierVisitor.is("-"), ModifyingMinifierVisitor.is("*"), ModifyingMinifierVisitor.is("/"), ModifyingMinifierVisitor.is("neg"))).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is(ValueType.INTEGER), ModifyingMinifierVisitor.is(ValueType.DECIMAL)))))))), node -> {
            BinaryOperator op = null;
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            BigDecimal sum = null;
            if ("neg".equals(callNode.getNodeOperator().getOperator())) {
                assert (arguments.size() == 1);
                ConstExprNode constExprNode = (ConstExprNode)arguments.get(0);
                return new ConstExprNode(node.getParent(), ((BigDecimal)constExprNode.getAsValueType()).negate().toString(), null, ValueType.DECIMAL, node.getSpan());
            }
            if (callNode.getNodeOperator().isPlusOp()) {
                op = (decimal, decimal2) -> decimal != null && decimal2 != null ? decimal.add((BigDecimal)decimal2) : null;
            } else if (callNode.getNodeOperator().isMinusOp()) {
                op = (decimal, decimal2) -> decimal != null && decimal2 != null ? decimal.subtract((BigDecimal)decimal2) : null;
            } else if (callNode.getNodeOperator().isMultOp()) {
                op = (decimal, decimal2) -> decimal != null && decimal2 != null ? decimal.multiply((BigDecimal)decimal2) : null;
            } else if (callNode.getNodeOperator().isDivOp()) {
                op = (decimal, decimal2) -> decimal != null && decimal2 != null ? decimal.divide((BigDecimal)decimal2) : null;
            }
            for (NodeBase arg : arguments) {
                Object value = ((ConstExprNode)arg).getAsValueType();
                if (sum != null) {
                    if (value instanceof Integer) {
                        sum = (BigDecimal)op.apply(sum, new BigDecimal((Integer)value));
                        continue;
                    }
                    if (!(value instanceof BigDecimal)) continue;
                    sum = (BigDecimal)op.apply(sum, (BigDecimal)value);
                    continue;
                }
                if (value instanceof Integer) {
                    sum = new BigDecimal((Integer)value);
                    continue;
                }
                if (!(value instanceof BigDecimal)) continue;
                sum = (BigDecimal)value;
            }
            return new ConstExprNode(callNode.getParent(), sum.toString(), null, ValueType.DECIMAL, callNode.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operCategory(ModifyingMinifierVisitor.is(NodeOperator.Category.RELATION)).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is(ValueType.INTEGER), ModifyingMinifierVisitor.is(ValueType.DECIMAL)))))))), node -> {
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            BigDecimal sum = BigDecimal.ZERO;
            assert (arguments.size() == 2);
            ConstExprNode leftHand = (ConstExprNode)arguments.get(0);
            ConstExprNode rightHand = (ConstExprNode)arguments.get(1);
            BigDecimal left = this.toBigDecimal(leftHand);
            BigDecimal right = this.toBigDecimal(rightHand);
            String operator = callNode.getNodeOperator().getOperator();
            Boolean result = this.compare(operator, left, right);
            return new ConstExprNode(callNode.getParent(), result.toString(), null, ValueType.BOOLEAN, callNode.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operCategory(ModifyingMinifierVisitor.is(NodeOperator.Category.RELATION)).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.is(ValueType.STRING))))))), node -> {
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            BigDecimal sum = BigDecimal.ZERO;
            assert (arguments.size() == 2);
            ConstExprNode leftHand = (ConstExprNode)arguments.get(0);
            ConstExprNode rightHand = (ConstExprNode)arguments.get(1);
            String left = leftHand.getValue();
            String right = rightHand.getValue();
            Boolean result = this.compare(callNode.getNodeOperator().getOperator(), (Comparable)((Object)left), (Object)right);
            return new ConstExprNode(callNode.getParent(), result.toString(), null, ValueType.BOOLEAN, callNode.getSpan());
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operCategory(ModifyingMinifierVisitor.is(NodeOperator.Category.LOGICAL))), node -> {
            BinaryOperator op = null;
            CallExprNode callNode = (CallExprNode)node;
            List<NodeBase> arguments = callNode.getSubnodes();
            BigDecimal sum = BigDecimal.ZERO;
            Boolean result = null;
            String operator = callNode.getNodeOperator().getOperator();
            ArrayList<NodeBase> newArguments = new ArrayList<NodeBase>();
            boolean andOperator = "and".equals(operator);
            boolean orOperator = "or".equals(operator);
            boolean notOperator = "not".equals(operator);
            if (notOperator) {
                assert (arguments.size() == 1);
                NodeBase arg0 = arguments.get(0);
                if (arg0 instanceof ConstExprNode) {
                    result = (Boolean)((ConstExprNode)arg0).getAsValueType() == false;
                    return new ConstExprNode(callNode.getParent(), result.toString(), null, ValueType.BOOLEAN, callNode.getSpan());
                }
            } else {
                if (andOperator) {
                    op = (identity, value) -> identity == null ? value : value != false && identity != false;
                } else if (orOperator) {
                    op = (identity, value) -> identity == null ? value : value != false || identity != false;
                }
                for (NodeBase arg : arguments) {
                    if (arg instanceof ConstExprNode) {
                        result = (Boolean)op.apply(result, (Boolean)((ConstExprNode)arg).getAsValueType());
                        continue;
                    }
                    newArguments.add(arg);
                }
            }
            if (result != null) {
                if ((!result.booleanValue() || newArguments.isEmpty()) && andOperator) {
                    return new ConstExprNode(node.getParent(), result.toString(), null, ValueType.BOOLEAN, node.getSpan());
                }
                if ((result.booleanValue() || newArguments.isEmpty()) && orOperator) {
                    return new ConstExprNode(node.getParent(), result.toString(), null, ValueType.BOOLEAN, node.getSpan());
                }
            }
            if (newArguments.size() == 1) {
                NodeBase argument = (NodeBase)newArguments.get(0);
                CloneVisitor cloneVisitor = new CloneVisitor();
                argument.accept(cloneVisitor);
                return cloneVisitor.getASTBuilder().build();
            }
            if (newArguments.size() > 0) {
                ASTBuilder astBuilder = new ASTBuilder().callExprNode(callNode);
                for (NodeBase argument : newArguments) {
                    argument.accept(new CloneVisitor(astBuilder));
                }
                return astBuilder.getTopNode();
            }
            return node;
        });
        this.whenMatches(ModifyingMinifierVisitor.callNode(ModifyingMinifierVisitor.operator(ModifyingMinifierVisitor.is("+")).and(ModifyingMinifierVisitor.args(ModifyingMinifierVisitor.allMatches(ModifyingMinifierVisitor.constNode(ModifyingMinifierVisitor.valueType(ModifyingMinifierVisitor.or(ModifyingMinifierVisitor.is(ValueType.STRING), ModifyingMinifierVisitor.is(ValueType.INTEGER)))))))), callNode -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (NodeBase arg : callNode.getSubnodes()) {
                String value = ((ConstExprNode)arg).getValue();
                stringBuilder.append((Object)value);
            }
            return new ConstExprNode(callNode.getParent(), stringBuilder.toString(), null, ValueType.STRING, callNode.getSpan());
        });
    }

    private <T> Boolean compare(String operator, Comparable<T> left, T right) {
        Boolean result;
        if (left != null && right != null) {
            int diff = left.compareTo(right);
            switch (operator) {
                case "!=": {
                    result = diff != 0;
                    break;
                }
                case "<=": {
                    result = diff <= 0;
                    break;
                }
                case ">=": {
                    result = diff >= 0;
                    break;
                }
                case ">": {
                    result = diff > 0;
                    break;
                }
                case "<": {
                    result = diff < 0;
                    break;
                }
                case "=": {
                    result = diff == 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown relation operator " + operator);
                }
            }
        } else {
            switch (operator) {
                case "!=": 
                case ">": 
                case "<": {
                    result = false;
                    break;
                }
                case "<=": 
                case "=": 
                case ">=": {
                    result = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown relation operator " + operator);
                }
            }
            if (left != null || right != null) {
                result = result == false;
            }
        }
        return result;
    }

    private BigDecimal toBigDecimal(ConstExprNode constNode) {
        if (constNode.getValueType() == ValueType.DECIMAL) {
            Object value = constNode.getAsValueType();
            if (value != null) {
                return (BigDecimal)constNode.getAsValueType();
            }
            return null;
        }
        if (constNode.getValueType() == ValueType.INTEGER) {
            Object value = constNode.getAsValueType();
            if (value != null) {
                return new BigDecimal((Integer)value);
            }
            return null;
        }
        throw new IllegalStateException();
    }
}

