/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dialob.rule.parser.api.ArrayValueType;
import io.dialob.rule.parser.api.PrimitiveValueType;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.Comparator;
import java.util.function.BinaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValueType
extends Serializable {
    public static final ValueType TIME = PrimitiveValueType.TIME;
    public static final ValueType DATE = PrimitiveValueType.DATE;
    public static final ValueType STRING = PrimitiveValueType.STRING;
    public static final ValueType PERIOD = PrimitiveValueType.PERIOD;
    public static final ValueType INTEGER = PrimitiveValueType.INTEGER;
    public static final ValueType DECIMAL = PrimitiveValueType.DECIMAL;
    public static final ValueType BOOLEAN = PrimitiveValueType.BOOLEAN;
    public static final ValueType DURATION = PrimitiveValueType.DURATION;
    public static final ValueType PERCENT = PrimitiveValueType.PERCENT;

    public <T> Comparator<T> getComparator();

    public Class<?> getTypeClass();

    public Object parseFromString(String var1);

    public boolean isNegateable();

    public Object negate(Object var1);

    public Object not(Object var1);

    public <T> BinaryOperator<T> sumOp();

    public <T> BinaryOperator<T> multOp();

    public ValueType plusType(ValueType var1);

    public ValueType minusType(ValueType var1);

    public ValueType multiplyType(ValueType var1);

    public ValueType divideByType(ValueType var1);

    public boolean canEqualWith(ValueType var1);

    public boolean canOrderWith(ValueType var1);

    public Object parseFromStringWithUnit(String var1, String var2);

    public String getName();

    default public boolean isArray() {
        return false;
    }

    public boolean isPrimitive();

    public static ValueType arrayOf(@NotNull ValueType valueType) {
        return ArrayValueType.arrayOf(valueType);
    }

    @Nullable
    public static ValueType valueTypeOf(@NotNull Class<?> returnType) {
        if (returnType == String.class) {
            return STRING;
        }
        if (returnType == LocalDate.class) {
            return DATE;
        }
        if (returnType == LocalTime.class) {
            return TIME;
        }
        if (returnType == Period.class) {
            return PERIOD;
        }
        if (returnType == Integer.class || returnType == Integer.TYPE) {
            return INTEGER;
        }
        if (returnType == BigDecimal.class) {
            return DECIMAL;
        }
        if (returnType == Boolean.class || returnType == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (returnType == Duration.class) {
            return DURATION;
        }
        if (returnType.isArray()) {
            ValueType valueType = ValueType.valueTypeOf(returnType.getComponentType());
            if (valueType == null) {
                throw new RuntimeException("Cannot find ValueType of type " + returnType.getComponentType());
            }
            return ValueType.arrayOf(valueType);
        }
        return null;
    }

    default public Object coerseFrom(Object value) {
        if (this.getTypeClass().isAssignableFrom(value.getClass())) {
            return value;
        }
        return null;
    }

    public byte getTypeCode();

    default public ValueType getItemValueType() {
        throw new IllegalStateException("Not an array value type");
    }

    public void writeTo(CodedOutputStream var1, Object var2) throws IOException;

    public Object readFrom(CodedInputStream var1) throws IOException;
}

