/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import io.dialob.rule.parser.api.ValueType;
import io.dialob.rule.parser.node.ASTBuilder;
import io.dialob.rule.parser.node.ASTVisitor;
import io.dialob.rule.parser.node.CallExprNode;
import io.dialob.rule.parser.node.ConstExprNode;
import io.dialob.rule.parser.node.IdExprNode;
import io.dialob.rule.parser.node.NodeBase;
import io.dialob.rule.parser.node.NodeOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AstMatcher
implements ASTVisitor {
    private final List<Pair<Predicate<NodeBase>, UnaryOperator<NodeBase>>> matchers = new ArrayList<Pair<Predicate<NodeBase>, UnaryOperator<NodeBase>>>();

    public NodeBase onVisitEnd(NodeBase baseNode) {
        return baseNode;
    }

    public void whenMatches(Predicate<NodeBase> matcher, UnaryOperator<NodeBase> thenAction) {
        this.matchers.add((Pair<Predicate<NodeBase>, UnaryOperator<NodeBase>>)new ImmutablePair(matcher, thenAction));
    }

    @Override
    public ASTVisitor visitCallExpr(@NotNull CallExprNode node) {
        this.checkMatchingBefore(node);
        return this;
    }

    @Override
    @NotNull
    public NodeBase endCallExpr(@NotNull CallExprNode node) {
        NodeBase nodeBase = this.checkMatching(node);
        if (nodeBase.getParent() == null) {
            return this.onVisitEnd(nodeBase);
        }
        return nodeBase;
    }

    protected void checkIsThisLast(NodeBase nodeBase) {
    }

    @Override
    @NotNull
    public NodeBase visitConstExpr(@NotNull ConstExprNode node) {
        NodeBase nodeBase = this.checkMatching(node);
        this.checkIsThisLast(node);
        return nodeBase;
    }

    @Override
    @NotNull
    public NodeBase visitIdExpr(@NotNull IdExprNode node) {
        NodeBase nodeBase = this.checkMatching(node);
        this.checkIsThisLast(node);
        return nodeBase;
    }

    protected void checkMatchingBefore(NodeBase node) {
    }

    @NotNull
    protected NodeBase checkMatching(NodeBase node) {
        for (Pair<Predicate<NodeBase>, UnaryOperator<NodeBase>> pair : this.matchers) {
            if (!((Predicate)pair.getKey()).test(node)) continue;
            return (NodeBase)((UnaryOperator)pair.getValue()).apply(node);
        }
        return node;
    }

    public static <T> Predicate<T> isNull() {
        return Objects::isNull;
    }

    public static <T> Predicate<T> is(@NotNull T equalsTo) {
        return object -> equalsTo == object || equalsTo.equals(object);
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return object -> !predicate.test(object);
    }

    public static <T> Predicate<T> or(Predicate<T> ... predicates) {
        return object -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(object)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> and(Predicate<T> ... predicates) {
        return object -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(object)) continue;
                return false;
            }
            return true;
        };
    }

    public static Predicate<NodeBase> stringValue(Predicate<Object> predicate) {
        return node -> node instanceof ConstExprNode && predicate.test(((ConstExprNode)node).getValue());
    }

    public static Predicate<NodeBase> value(Predicate<Object> predicate) {
        return node -> node instanceof ConstExprNode && predicate.test(((ConstExprNode)node).getAsValueType());
    }

    public static Predicate<NodeBase> valueType(Predicate<ValueType> predicate) {
        return node -> predicate.test(node.getValueType());
    }

    public static Predicate<List<NodeBase>> count(Predicate<Integer> predicate) {
        return list -> predicate.test(list.size());
    }

    public static Predicate<NodeBase> parent(Predicate<NodeBase> predicate) {
        return node -> predicate.test(node.getParent());
    }

    public static Predicate<NodeBase> lhs(Predicate<NodeBase> predicate) {
        return node -> node instanceof CallExprNode && predicate.test((NodeBase)((CallExprNode)node).getLhs());
    }

    public static Predicate<NodeBase> rhs(Predicate<NodeBase> predicate) {
        return node -> node instanceof CallExprNode && predicate.test((NodeBase)((CallExprNode)node).getRhs());
    }

    public static Predicate<NodeBase> args(Predicate<List<NodeBase>> predicate) {
        return node -> node instanceof CallExprNode && predicate.test(node.getSubnodes());
    }

    public static Predicate<List<NodeBase>> length(Predicate<Integer> predicate) {
        return args -> args != null && predicate.test(args.size());
    }

    public static Predicate<List<NodeBase>> first(Predicate<NodeBase> predicate) {
        return args -> !args.isEmpty() && predicate.test((NodeBase)args.get(0));
    }

    public static Predicate<List<NodeBase>> last(Predicate<NodeBase> predicate) {
        return args -> !args.isEmpty() && predicate.test((NodeBase)args.get(args.size() - 1));
    }

    public static Predicate<List<NodeBase>> anyMatches(Predicate<NodeBase> predicate) {
        return args -> {
            if (args.isEmpty()) {
                return false;
            }
            for (NodeBase arg : args) {
                if (!predicate.test(arg)) continue;
                return true;
            }
            return false;
        };
    }

    public static Predicate<NodeBase> dependencies(Predicate<Map<String, ValueType>> predicate) {
        return node -> node instanceof CallExprNode && predicate.test(node.getDependencies());
    }

    public static <T> Predicate<Collection<T>> size(Predicate<Integer> predicate) {
        return args -> predicate.test(args.size());
    }

    public static Predicate<NodeBase> isChildOf(NodeBase parentNode) {
        return args -> {
            NodeBase node = args;
            while ((node = node.getParent()) != null) {
                if (node != parentNode) continue;
                return true;
            }
            return false;
        };
    }

    public static <K, V> Predicate<Map<K, V>> keys(Predicate<Set<K>> predicate) {
        return args -> predicate.test(args.keySet());
    }

    public static <K, V> Predicate<Map<K, V>> values(Predicate<Collection<V>> predicate) {
        return args -> predicate.test(args.values());
    }

    public static <T> Predicate<Collection<T>> contains(Predicate<T> predicate) {
        return args -> {
            for (Object t : args) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<Collection<T>> contains(T t) {
        return args -> args.contains(t);
    }

    public static Predicate<List<NodeBase>> allMatches(Predicate<NodeBase> predicate) {
        return args -> {
            if (args.isEmpty()) {
                return false;
            }
            for (NodeBase arg : args) {
                if (predicate.test(arg)) continue;
                return false;
            }
            return true;
        };
    }

    public static Predicate<NodeBase> operCategory(Predicate<NodeOperator.Category> predicate) {
        return node -> node instanceof CallExprNode && predicate.test(node.getNodeOperator().getCategory());
    }

    public static Predicate<NodeBase> operator(Predicate<String> predicate) {
        return node -> node instanceof CallExprNode && predicate.test(node.getNodeOperator().getOperator());
    }

    public static Predicate<NodeBase> callNode() {
        return AstMatcher.callNode(AstMatcher.any());
    }

    public static Predicate<NodeBase> callNode(@NotNull Predicate<NodeBase> predicate) {
        return node -> node instanceof CallExprNode && predicate.test((NodeBase)node);
    }

    public static Predicate<NodeBase> idNode() {
        return AstMatcher.idNode(AstMatcher.any());
    }

    public static Predicate<NodeBase> idNode(@NotNull Predicate<NodeBase> predicate) {
        return node -> node instanceof IdExprNode && predicate.test((NodeBase)node);
    }

    public static Predicate<NodeBase> id(Predicate<String> predicate) {
        return node -> node instanceof IdExprNode && predicate.test(((IdExprNode)node).getId());
    }

    public static <T> Predicate<T> any() {
        return t -> true;
    }

    public static Predicate<NodeBase> constNode() {
        return AstMatcher.constNode(AstMatcher.any());
    }

    public static Predicate<NodeBase> constNode(@NotNull Predicate<NodeBase> predicate) {
        return node -> node instanceof ConstExprNode && predicate.test((NodeBase)node);
    }

    public static Predicate<NodeBase> anyNode() {
        return AstMatcher.anyNode(AstMatcher.any());
    }

    public static Predicate<NodeBase> anyNode(@NotNull Predicate<NodeBase> predicate) {
        return node -> node != null && predicate.test((NodeBase)node);
    }

    public ASTBuilder newASTBuilder() {
        return new ASTBuilder();
    }
}

