package io.dialob.rule.parser.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.node.Span;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuleExpressionCompilerError}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRuleExpressionCompilerError.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableRuleExpressionCompilerError.of()}.
 */
@Generated(from = "RuleExpressionCompilerError", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRuleExpressionCompilerError
    implements RuleExpressionCompilerError {
  private final String errorCode;
  private final @Nullable Object[] args;
  private final Span span;

  private ImmutableRuleExpressionCompilerError(String errorCode, Span span) {
    this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
    this.span = Objects.requireNonNull(span, "span");
    this.args = null;
  }

  private ImmutableRuleExpressionCompilerError(ImmutableRuleExpressionCompilerError.Builder builder) {
    this.errorCode = builder.errorCode;
    this.args = builder.args;
    this.span = builder.span != null
        ? builder.span
        : Objects.requireNonNull(RuleExpressionCompilerError.super.getSpan(), "span");
  }

  private ImmutableRuleExpressionCompilerError(
      String errorCode,
      @Nullable Object[] args,
      Span span) {
    this.errorCode = errorCode;
    this.args = args;
    this.span = span;
  }

  /**
   * @return The value of the {@code errorCode} attribute
   */
  @Override
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public Optional<Object[]> getArgs() {
    return Optional.ofNullable(args);
  }

  /**
   * @return The value of the {@code span} attribute
   */
  @Override
  public Span getSpan() {
    return span;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuleExpressionCompilerError#getErrorCode() errorCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuleExpressionCompilerError withErrorCode(String value) {
    String newValue = Objects.requireNonNull(value, "errorCode");
    if (this.errorCode.equals(newValue)) return this;
    return new ImmutableRuleExpressionCompilerError(newValue, this.args, this.span);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RuleExpressionCompilerError#getArgs() args} attribute.
   * @param value The value for args
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuleExpressionCompilerError withArgs(Object[] value) {
    @Nullable Object[] newValue = Objects.requireNonNull(value, "args");
    if (this.args == newValue) return this;
    return new ImmutableRuleExpressionCompilerError(this.errorCode, newValue, this.span);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RuleExpressionCompilerError#getArgs() args} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for args
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRuleExpressionCompilerError withArgs(Optional<? extends Object[]> optional) {
    @Nullable Object[] value = optional.orElse(null);
    if (this.args == value) return this;
    return new ImmutableRuleExpressionCompilerError(this.errorCode, value, this.span);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RuleExpressionCompilerError#getSpan() span} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for span
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuleExpressionCompilerError withSpan(Span value) {
    if (this.span == value) return this;
    Span newValue = Objects.requireNonNull(value, "span");
    return new ImmutableRuleExpressionCompilerError(this.errorCode, this.args, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRuleExpressionCompilerError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRuleExpressionCompilerError
        && equalTo((ImmutableRuleExpressionCompilerError) another);
  }

  private boolean equalTo(ImmutableRuleExpressionCompilerError another) {
    return errorCode.equals(another.errorCode)
        && Objects.equals(args, another.args)
        && span.equals(another.span);
  }

  /**
   * Computes a hash code from attributes: {@code errorCode}, {@code args}, {@code span}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + errorCode.hashCode();
    h += (h << 5) + Objects.hashCode(args);
    h += (h << 5) + span.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RuleExpressionCompilerError} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RuleExpressionCompilerError")
        .omitNullValues()
        .add("errorCode", errorCode)
        .add("args", args)
        .add("span", span)
        .toString();
  }

  /**
   * Construct a new immutable {@code RuleExpressionCompilerError} instance.
   * @param errorCode The value for the {@code errorCode} attribute
   * @param span The value for the {@code span} attribute
   * @return An immutable RuleExpressionCompilerError instance
   */
  public static ImmutableRuleExpressionCompilerError of(String errorCode, Span span) {
    return new ImmutableRuleExpressionCompilerError(errorCode, span);
  }

  /**
   * Creates an immutable copy of a {@link RuleExpressionCompilerError} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RuleExpressionCompilerError instance
   */
  public static ImmutableRuleExpressionCompilerError copyOf(RuleExpressionCompilerError instance) {
    if (instance instanceof ImmutableRuleExpressionCompilerError) {
      return (ImmutableRuleExpressionCompilerError) instance;
    }
    return ImmutableRuleExpressionCompilerError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRuleExpressionCompilerError ImmutableRuleExpressionCompilerError}.
   * <pre>
   * ImmutableRuleExpressionCompilerError.builder()
   *    .errorCode(String) // required {@link RuleExpressionCompilerError#getErrorCode() errorCode}
   *    .args(Object[]) // optional {@link RuleExpressionCompilerError#getArgs() args}
   *    .span(io.dialob.rule.parser.node.Span) // optional {@link RuleExpressionCompilerError#getSpan() span}
   *    .build();
   * </pre>
   * @return A new ImmutableRuleExpressionCompilerError builder
   */
  public static ImmutableRuleExpressionCompilerError.Builder builder() {
    return new ImmutableRuleExpressionCompilerError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRuleExpressionCompilerError ImmutableRuleExpressionCompilerError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuleExpressionCompilerError", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ERROR_CODE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String errorCode;
    private @Nullable Object[] args;
    private @Nullable Span span;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuleExpressionCompilerError} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RuleExpressionCompilerError instance) {
      Objects.requireNonNull(instance, "instance");
      errorCode(instance.getErrorCode());
      Optional<Object[]> argsOptional = instance.getArgs();
      if (argsOptional.isPresent()) {
        args(argsOptional);
      }
      span(instance.getSpan());
      return this;
    }

    /**
     * Initializes the value for the {@link RuleExpressionCompilerError#getErrorCode() errorCode} attribute.
     * @param errorCode The value for errorCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorCode(String errorCode) {
      this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
      initBits &= ~INIT_BIT_ERROR_CODE;
      return this;
    }

    /**
     * Initializes the optional value {@link RuleExpressionCompilerError#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Object[] args) {
      this.args = Objects.requireNonNull(args, "args");
      return this;
    }

    /**
     * Initializes the optional value {@link RuleExpressionCompilerError#getArgs() args} to args.
     * @param args The value for args
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Optional<? extends Object[]> args) {
      this.args = args.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link RuleExpressionCompilerError#getSpan() span} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link RuleExpressionCompilerError#getSpan() span}.</em>
     * @param span The value for span 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder span(Span span) {
      this.span = Objects.requireNonNull(span, "span");
      return this;
    }

    /**
     * Builds a new {@link ImmutableRuleExpressionCompilerError ImmutableRuleExpressionCompilerError}.
     * @return An immutable instance of RuleExpressionCompilerError
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRuleExpressionCompilerError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRuleExpressionCompilerError(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ERROR_CODE) != 0) attributes.add("errorCode");
      return "Cannot build RuleExpressionCompilerError, some of required attributes are not set " + attributes;
    }
  }
}
