/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.dialob.rule.parser.api.RuleExpressionCompilerError;
import io.dialob.rule.parser.node.Span;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RuleExpressionCompilerError", generator="Immutables")
@Immutable
public final class ImmutableRuleExpressionCompilerError
implements RuleExpressionCompilerError {
    private final String errorCode;
    @Nullable
    private final Object[] args;
    private final Span span;

    private ImmutableRuleExpressionCompilerError(String errorCode, Span span) {
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
        this.span = Objects.requireNonNull(span, "span");
        this.args = null;
    }

    private ImmutableRuleExpressionCompilerError(Builder builder) {
        this.errorCode = builder.errorCode;
        this.args = builder.args;
        this.span = builder.span != null ? builder.span : Objects.requireNonNull(RuleExpressionCompilerError.super.getSpan(), "span");
    }

    private ImmutableRuleExpressionCompilerError(String errorCode, @Nullable Object[] args, Span span) {
        this.errorCode = errorCode;
        this.args = args;
        this.span = span;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<Object[]> getArgs() {
        return Optional.ofNullable(this.args);
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    public final ImmutableRuleExpressionCompilerError withErrorCode(String value) {
        String newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode.equals(newValue)) {
            return this;
        }
        return new ImmutableRuleExpressionCompilerError(newValue, this.args, this.span);
    }

    public final ImmutableRuleExpressionCompilerError withArgs(Object[] value) {
        Object[] newValue = Objects.requireNonNull(value, "args");
        if (this.args == newValue) {
            return this;
        }
        return new ImmutableRuleExpressionCompilerError(this.errorCode, newValue, this.span);
    }

    public final ImmutableRuleExpressionCompilerError withArgs(Optional<? extends Object[]> optional) {
        Object[] value = optional.orElse(null);
        if (this.args == value) {
            return this;
        }
        return new ImmutableRuleExpressionCompilerError(this.errorCode, value, this.span);
    }

    public final ImmutableRuleExpressionCompilerError withSpan(Span value) {
        if (this.span == value) {
            return this;
        }
        Span newValue = Objects.requireNonNull(value, "span");
        return new ImmutableRuleExpressionCompilerError(this.errorCode, this.args, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuleExpressionCompilerError && this.equalTo((ImmutableRuleExpressionCompilerError)another);
    }

    private boolean equalTo(ImmutableRuleExpressionCompilerError another) {
        return this.errorCode.equals(another.errorCode) && Objects.equals(this.args, another.args) && this.span.equals(another.span);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errorCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.args);
        h += (h << 5) + this.span.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RuleExpressionCompilerError").omitNullValues().add("errorCode", (Object)this.errorCode).add("args", (Object)this.args).add("span", (Object)this.span).toString();
    }

    public static ImmutableRuleExpressionCompilerError of(String errorCode, Span span) {
        return new ImmutableRuleExpressionCompilerError(errorCode, span);
    }

    public static ImmutableRuleExpressionCompilerError copyOf(RuleExpressionCompilerError instance) {
        if (instance instanceof ImmutableRuleExpressionCompilerError) {
            return (ImmutableRuleExpressionCompilerError)instance;
        }
        return ImmutableRuleExpressionCompilerError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RuleExpressionCompilerError", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ERROR_CODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String errorCode;
        @Nullable
        private Object[] args;
        @Nullable
        private Span span;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RuleExpressionCompilerError instance) {
            Objects.requireNonNull(instance, "instance");
            this.errorCode(instance.getErrorCode());
            Optional<Object[]> argsOptional = instance.getArgs();
            if (argsOptional.isPresent()) {
                this.args(argsOptional);
            }
            this.span(instance.getSpan());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorCode(String errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Object[] args) {
            this.args = Objects.requireNonNull(args, "args");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Optional<? extends Object[]> args) {
            this.args = args.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder span(Span span) {
            this.span = Objects.requireNonNull(span, "span");
            return this;
        }

        public ImmutableRuleExpressionCompilerError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRuleExpressionCompilerError(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("errorCode");
            }
            return "Cannot build RuleExpressionCompilerError, some of required attributes are not set " + attributes;
        }
    }
}

