/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rule.parser;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class TreeWalkerInvocationHandler
implements InvocationHandler {
    int level = 0;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("enterEveryRule".equals(name) || "exitEveryRule".equals(name)) {
            return null;
        }
        boolean enter = false;
        if (name.startsWith("enter")) {
            name = name.substring(5);
            enter = true;
            ++this.level;
        } else if (name.startsWith("exit")) {
            name = name.substring(4);
        } else if (name.equals("visitTerminal")) {
            return null;
        }
        ParseTree node = (ParseTree)args[0];
        this.printNode(enter, name, node);
        if (!enter) {
            --this.level;
        }
        return null;
    }

    protected void printNode(boolean enter, String ruleName, ParseTree node) throws IllegalAccessException {
        if (!enter) {
            return;
        }
        String op = this.findOp(node);
        String expr = this.findExpr(node);
        String left = this.findLeft(node);
        String right = this.findRight(node);
        String var = this.findVar(node);
        String value = this.findValue(node);
        Object argstring = "";
        if (left != null || right != null) {
            argstring = "(" + op + " " + left + " " + right + ")";
        } else if (op != null) {
            argstring = "(" + op + ")";
        } else if (expr != null) {
            argstring = "(" + expr + ")";
        } else if (value != null) {
            argstring = "(" + value + ")";
        } else if (var != null) {
            argstring = "(" + var + ")";
        }
        System.out.println("                         ".substring(0, this.level) + ruleName + (String)argstring);
    }

    protected String findOp(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "op");
    }

    protected String findLeft(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "left");
    }

    protected String findRight(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "right");
    }

    protected String findExpr(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "expr");
    }

    protected String findUnit(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "unit");
    }

    protected String findVar(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "var");
    }

    protected String findFunc(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "func");
    }

    protected String findValue(ParseTree node) throws IllegalAccessException {
        return this.findField(node, "stringValue");
    }

    protected String findField(ParseTree node, String fieldName) throws IllegalAccessException {
        Object op = null;
        try {
            Field opField = node.getClass().getField(fieldName);
            op = opField.get(node);
            if (op instanceof Token) {
                return ((Token)op).getText();
            }
            if (op instanceof ParseTree) {
                return ((ParseTree)op).getText();
            }
            if (op == null) {
                return null;
            }
            return "<ERROR>";
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }
}

