/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.rest;

import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import io.dialob.api.rest.Errors;
import io.dialob.api.rest.ImmutableErrors;
import io.dialob.rest.type.ApiException;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class RestApiExceptionMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiExceptionMapper.class);

    @ExceptionHandler
    public ResponseEntity handleMethodArgumentNotValidException(@NonNull MethodArgumentNotValidException exception) {
        BindingResult bindingResult = exception.getBindingResult();
        ImmutableErrors.Builder errorsBuilder = ImmutableErrors.builder().status(Integer.valueOf(HttpStatus.UNPROCESSABLE_ENTITY.value())).error(HttpStatus.UNPROCESSABLE_ENTITY.getReasonPhrase());
        for (ObjectError objectError : bindingResult.getAllErrors()) {
            ImmutableErrors.Error.Builder builder = ImmutableErrors.Error.builder().code(objectError.getCode()).error(objectError.getDefaultMessage());
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                builder = builder.context(fieldError.getField()).rejectedValue(fieldError.getRejectedValue());
            }
            errorsBuilder.addErrors((Errors.Error)builder.build());
        }
        ImmutableErrors errors = errorsBuilder.build();
        HttpStatus httpStatus = this.resolveHttpStatus((Errors)errors);
        LOGGER.error("Invalid request (" + httpStatus + "): " + exception.getMessage());
        return ResponseEntity.status((HttpStatus)httpStatus).body((Object)errors);
    }

    @ExceptionHandler
    public ResponseEntity valueInstantiationExceptionHandler(@NonNull ValueInstantiationException exception) {
        ImmutableErrors.Builder builder = ImmutableErrors.builder();
        Throwable cause = exception.getCause();
        String message = exception.getMessage();
        if (cause instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)cause;
            cve.getConstraintViolations().forEach(constraintViolation -> builder.addErrors((Errors.Error)ImmutableErrors.Error.builder().error(constraintViolation.getMessage()).rejectedValue(constraintViolation.getInvalidValue()).context(constraintViolation.getPropertyPath().toString()).build()).build());
            message = cve.getConstraintViolations().stream().map(cv -> cv.getPropertyPath() + ": " + cv.getMessage()).collect(Collectors.joining("\n"));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)builder.message(message).error(HttpStatus.UNPROCESSABLE_ENTITY.getReasonPhrase()).build());
    }

    @ExceptionHandler
    public ResponseEntity apiExceptionHandler(@NonNull ApiException exception) {
        Errors errors = exception.getErrors();
        HttpStatus httpStatus = this.resolveHttpStatus(errors);
        errors = ImmutableErrors.builder().from(errors).error(httpStatus.getReasonPhrase()).build();
        LOGGER.error("API Error (" + httpStatus + "): " + exception.getMessage(), (Throwable)exception);
        return ResponseEntity.status((HttpStatus)httpStatus).contentType(MediaType.APPLICATION_JSON).body((Object)errors);
    }

    private HttpStatus resolveHttpStatus(Errors errors) {
        HttpStatus httpStatus;
        Integer status = errors.getStatus();
        if (status == null) {
            LOGGER.error("No error status defined {}", (Object)errors);
            status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
        try {
            httpStatus = HttpStatus.valueOf((int)status);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unknown error status defined {}", (Object)errors);
            httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return httpStatus;
    }
}

