/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.submit;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.AnswerSubmitHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class PostSubmitHandler
implements AnswerSubmitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostSubmitHandler.class);
    private ClientHttpRequestFactory requestFactory;

    public void submit(@NonNull AnswerSubmitHandler.Settings submitHandlerSettings, @NonNull Questionnaire document) {
        block8: {
            String submitUrl = document.getMetadata().getSubmitUrl();
            if (StringUtils.isBlank((CharSequence)submitUrl)) {
                LOGGER.info("Form submit endpoint not defined for questionnaire {}", (Object)document.getId());
                return;
            }
            try {
                ResponseEntity response;
                URL url = new URL(submitUrl);
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.set("Content-Type", "application/json");
                HttpEntity httpEntity = new HttpEntity((Object)document, (MultiValueMap)httpHeaders);
                String userInfo = url.getUserInfo();
                String username = null;
                String password = null;
                String[] credentials = null;
                if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                    credentials = userInfo.split(":", 2);
                }
                if (credentials != null && credentials.length == 2) {
                    username = credentials[0];
                    password = credentials[1];
                }
                if ((response = this.createRestTemplate(username, password).exchange(submitUrl, HttpMethod.POST, httpEntity, String.class, new Object[0])).getStatusCode().is2xxSuccessful()) {
                    LOGGER.debug("Successfully POSTed questionnaire {} answers to {}, response {}", new Object[]{document.getId(), submitUrl, response.getStatusCode()});
                    break block8;
                }
                String entity = null;
                try {
                    entity = (String)response.getBody();
                }
                catch (Exception e) {
                    LOGGER.debug("Error response content could not be read.", (Throwable)e);
                }
                LOGGER.error("There was a problem POSTing questionnaire {} answers to {}, response {}, response content '{}'", new Object[]{document.getId(), submitUrl, response.getStatusCode(), entity});
            }
            catch (MalformedURLException | RestClientException e) {
                LOGGER.error(String.format("Failed to POST questionnaire %s results to %s", document.getId(), submitUrl), e);
            }
        }
    }

    public RestTemplate createRestTemplate(String username, String password) {
        RestTemplate restTemplate;
        RestTemplate restTemplate2 = restTemplate = this.requestFactory != null ? new RestTemplate(this.requestFactory) : new RestTemplate();
        if (username != null && password != null) {
            restTemplate.setInterceptors(Collections.singletonList(new BasicAuthorizationInterceptor(username, password)));
        }
        return restTemplate;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }
}

