/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.ActionProcessingService;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.NonNull;

public class QuestionnaireSessionProcessingService
implements ActionProcessingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionProcessingService.class);
    private final QuestionnaireSessionService questionnaireSessionService;
    private final Timer processingTime;
    private final Counter numberOfFailures;
    private final Timer updateTime;
    private Optional<CacheManager> sessionCacheManager;
    private final QuestionnaireSessionSaveService questionnaireSessionSaveService;
    private final QuestionnaireEventPublisher eventPublisher;

    public QuestionnaireSessionProcessingService(QuestionnaireSessionService questionnaireSessionService, MeterRegistry meterRegistry, Optional<CacheManager> sessionCacheManager, QuestionnaireSessionSaveService questionnaireSessionSaveService, QuestionnaireEventPublisher eventPublisher) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.numberOfFailures = Counter.builder((String)"dialob.session.actions.failures").description("Number of failed actions").register(meterRegistry);
        this.processingTime = Timer.builder((String)"dialob.session.actions.processingTime").description("Actions processing time").register(meterRegistry);
        this.updateTime = Timer.builder((String)"dialob.session.update.time").description("Actions processing time").register(meterRegistry);
        this.sessionCacheManager = sessionCacheManager;
        this.questionnaireSessionSaveService = questionnaireSessionSaveService;
        this.eventPublisher = eventPublisher;
    }

    @NonNull
    @Deprecated
    public Actions answerQuestion(@NonNull String questionnaireId, String revision, @NonNull List<Action> actions) {
        return (Actions)this.processingTime.record(() -> {
            try {
                QuestionnaireSession session = this.questionnaireSessionService.findOne(questionnaireId);
                if (session == null) {
                    throw new DocumentNotFoundException(String.format("Could not find questionnaire %s", questionnaireId));
                }
                if (session.isCompleted()) {
                    return ImmutableActions.builder().rev(session.getRev()).build();
                }
                QuestionnaireSession.DispatchActionsResult response = session.dispatchActions(revision, (Collection)actions);
                if (response.isDidComplete()) {
                    this.questionnaireSessionSaveService.save(session);
                    session.getSessionId().ifPresent(sessionId -> this.eventPublisher.completed(session.getTenantId(), sessionId));
                } else {
                    this.storeSessionIntoCache(questionnaireId, session);
                }
                return response.getActions();
            }
            catch (Exception e) {
                this.numberOfFailures.increment();
                LOGGER.error("Action processing failure on questionnaireId : {}", (Object)questionnaireId, (Object)e);
                throw e;
            }
        });
    }

    @Nonnull
    public QuestionnaireSession computeSessionUpdate(@Nonnull String questionnaireId, boolean openIfClosed, Function<QuestionnaireSession, QuestionnaireSession> updateFunction) {
        return (QuestionnaireSession)this.updateTime.record(() -> {
            try {
                QuestionnaireSession session = this.questionnaireSessionService.findOne(questionnaireId);
                if (session == null) {
                    return null;
                }
                QuestionnaireSession updatedSession = (QuestionnaireSession)updateFunction.apply(session);
                if (updatedSession != session) {
                    this.storeSessionIntoCache(questionnaireId, updatedSession);
                }
                return updatedSession;
            }
            catch (Exception e) {
                LOGGER.error("Processing failure on questionnaireId : {}", (Object)questionnaireId, (Object)e);
                throw e;
            }
        });
    }

    public void storeSessionIntoCache(@NonNull String questionnaireId, @NonNull QuestionnaireSession session) {
        this.sessionCacheManager.ifPresent(cacheManager -> {
            Cache cache = cacheManager.getCache("sessionCache");
            if (cache != null) {
                cache.put((Object)questionnaireId, (Object)session);
            }
        });
    }
}

