/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.settings.DialobSettings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class PeriodicPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicPersistenceService.class);
    private final QuestionnaireSessionService questionnaireSessionService;
    private final QuestionnaireSessionSaveService questionnaireSessionSaveService;
    private final ConcurrentHashMap<String, ScheduledFuture> tasks = new ConcurrentHashMap();
    private final ThreadPoolTaskScheduler scheduler;
    private final DialobSettings settings;
    private final CurrentTenant currentTenant;

    PeriodicPersistenceService(@NonNull QuestionnaireSessionService questionnaireSessionService, @NonNull QuestionnaireSessionSaveService questionnaireSessionSaveService, @NonNull ThreadPoolTaskScheduler taskScheduler, @NonNull DialobSettings settings, @NonNull CurrentTenant currentTenant) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.questionnaireSessionSaveService = questionnaireSessionSaveService;
        this.scheduler = taskScheduler;
        this.settings = settings;
        this.currentTenant = currentTenant;
        LOGGER.debug("Periodic Persistence Service: activated");
    }

    @EventListener
    public void onQuestionnaireActionsEvent(QuestionnaireActionsEvent event) {
        this.tasks.compute(event.getQuestionnaireId(), (qId, previousSchedule) -> {
            if (previousSchedule != null && !previousSchedule.isDone()) {
                previousSchedule.cancel(false);
            }
            return this.scheduler.getScheduledThreadPoolExecutor().schedule(() -> {
                QuestionnaireSession session = this.questionnaireSessionService.findOne(qId, false);
                if (session != null && session.getStatus() != Questionnaire.Metadata.Status.COMPLETED) {
                    this.questionnaireSessionSaveService.save(session);
                    LOGGER.debug("Periodic Persistence Service: session '{}' stored", qId);
                }
                this.tasks.remove(qId);
            }, this.settings.getSession().getAutosave().getInterval(), TimeUnit.MILLISECONDS);
        });
    }
}

