/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.submit;

import io.dialob.questionnaire.service.api.AnswerSubmitHandler;
import io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.settings.DialobSettings;
import io.dialob.settings.SubmitHandlerSettings;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class CompleteQuestionnaireEventDelegateToAnswerSubmitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompleteQuestionnaireEventDelegateToAnswerSubmitHandler.class);
    private final DialobSettings dialobSettings;
    private final QuestionnaireSessionService questionnaireSessionService;
    private final ApplicationContext applicationContext;

    public CompleteQuestionnaireEventDelegateToAnswerSubmitHandler(DialobSettings dialobSettings, QuestionnaireSessionService questionnaireSessionService, ApplicationContext applicationContext) {
        this.dialobSettings = dialobSettings;
        this.questionnaireSessionService = questionnaireSessionService;
        this.applicationContext = applicationContext;
    }

    @EventListener
    protected void onCompleteQuestionnaireHandler(QuestionnaireCompletedEvent event) {
        LOGGER.debug("Received: {}", (Object)event);
        final String tenantId = event.getTenant().getId();
        AnswerSubmitHandler.Settings submitHandlerSettings = new AnswerSubmitHandler.Settings(){

            public String getBeanName() {
                SubmitHandlerSettings tenantSubmitHandlerSettings = (SubmitHandlerSettings)CompleteQuestionnaireEventDelegateToAnswerSubmitHandler.this.dialobSettings.getSubmitHandlers().get(tenantId);
                if (tenantSubmitHandlerSettings != null) {
                    return tenantSubmitHandlerSettings.getBeanName();
                }
                return null;
            }

            public Map<String, Object> getProperties() {
                SubmitHandlerSettings tenantSubmitHandlerSettings = (SubmitHandlerSettings)CompleteQuestionnaireEventDelegateToAnswerSubmitHandler.this.dialobSettings.getSubmitHandlers().get(tenantId);
                if (tenantSubmitHandlerSettings != null) {
                    return tenantSubmitHandlerSettings.getProperties();
                }
                return Collections.emptyMap();
            }
        };
        String questionnaireId = event.getQuestionnaireId();
        QuestionnaireSession questionnaireSession = this.questionnaireSessionService.findOne(questionnaireId);
        if (questionnaireSession != null) {
            this.createSubmitHandler(submitHandlerSettings).ifPresent(answerSubmitHandler -> {
                LOGGER.debug("call submit handler {} for {}", (Object)submitHandlerSettings.getBeanName(), (Object)questionnaireSession.getQuestionnaire().getId());
                answerSubmitHandler.submit(submitHandlerSettings, questionnaireSession.getQuestionnaire());
            });
        } else {
            LOGGER.warn("Cannot do submit. Questionnaire {} is missing", (Object)questionnaireId);
        }
    }

    private Optional<AnswerSubmitHandler> createSubmitHandler(AnswerSubmitHandler.Settings submitHandlerSettings) {
        String beanName = submitHandlerSettings.getBeanName();
        if (beanName != null) {
            try {
                LOGGER.debug("Looking submit handler {}", (Object)beanName);
                return Optional.of((AnswerSubmitHandler)this.applicationContext.getBean(beanName, AnswerSubmitHandler.class));
            }
            catch (BeansException e) {
                LOGGER.error("no answer submit handler '{}' defined. Error: {}", (Object)beanName, (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }
}

