/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service;

import io.dialob.integration.api.event.EventPublisher;
import io.dialob.questionnaire.service.PeriodicPersistenceService;
import io.dialob.questionnaire.service.QuestionnaireSessionEventPublisher;
import io.dialob.questionnaire.service.QuestionnaireSessionProcessingService;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.questionnaire.service.submit.CompleteQuestionnaireEventDelegateToAnswerSubmitHandler;
import io.dialob.questionnaire.service.submit.PostSubmitHandler;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.settings.DialobSettings;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods=false)
@ImportResource(value={"classpath:dialob-questionnaire-service-cache-context.xml"})
public class DialobQuestionnaireServiceAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobQuestionnaireServiceAutoConfiguration.class);

    @Bean
    public QuestionnaireSessionProcessingService questionnaireSessionActionProcessingService(QuestionnaireSessionService questionnaireSessionService, QuestionnaireSessionSaveService questionnaireSessionSaveService, MeterRegistry meterRegistry, @Qualifier(value="sessionCacheManager") Optional<CacheManager> sessionCacheManager, QuestionnaireEventPublisher eventPublisher) {
        return new QuestionnaireSessionProcessingService(questionnaireSessionService, meterRegistry, sessionCacheManager, questionnaireSessionSaveService, eventPublisher);
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.session.postSubmitHandler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public CompleteQuestionnaireEventDelegateToAnswerSubmitHandler completeQuestionnaireEventDelegateToAnswerSubmitHandler(DialobSettings dialobSettings, QuestionnaireSessionService questionnaireSessionService, ApplicationContext applicationContext) {
        LOGGER.info("Enabling CompleteQuestionnaireEventDelegateToAnswerSubmitHandler");
        return new CompleteQuestionnaireEventDelegateToAnswerSubmitHandler(dialobSettings, questionnaireSessionService, applicationContext);
    }

    @Bean(value={"postSubmitHandler"})
    public PostSubmitHandler postSubmitHandler() {
        return new PostSubmitHandler();
    }

    @Bean
    public EventPublisher questionnaireSessionEventPublisher(TaskExecutor taskExecutor, ApplicationEventPublisher applicationEventPublisher) {
        return new QuestionnaireSessionEventPublisher(taskExecutor, applicationEventPublisher);
    }

    @Bean
    @ConditionalOnProperty(prefix="dialob.session.autosave", name={"enabled"}, havingValue="true")
    public PeriodicPersistenceService periodicPersistenceService(QuestionnaireSessionService questionnaireSessionService, QuestionnaireSessionSaveService questionnaireSessionSaveService, ThreadPoolTaskScheduler taskScheduler, DialobSettings settings, CurrentTenant currentTenant) {
        return new PeriodicPersistenceService(questionnaireSessionService, questionnaireSessionSaveService, taskScheduler, settings, currentTenant);
    }

    @Bean
    public QuestionnaireEventPublisher questionnaireEventPublisher(EventPublisher applicationEventPublisher, CurrentTenant currentTenant) {
        return new QuestionnaireEventPublisher(applicationEventPublisher, currentTenant);
    }
}

