/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.InetAddresses;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.ActionProcessingService;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.questionnaire.service.api.FormActionsUpdatesCallback;
import io.dialob.questionnaire.service.api.QuestionnaireActionsService;
import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.ResysSecurityConstants;
import io.dialob.security.tenant.Tenant;
import io.dialob.security.tenant.TenantContextHolderCurrentTenant;
import io.dialob.settings.DialobSettings;
import io.dialob.settings.SessionSettings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;

public class QuestionnaireWebSocketHandler
extends TextWebSocketHandler
implements QuestionnaireActionsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnaireWebSocketHandler.class);
    private final SessionSettings.SockJSSettings settings;
    private final QuestionnaireEventPublisher eventPublisher;
    private final ActionProcessingService actionProcessingService;
    private final ObjectMapper mapper;
    private final QuestionnaireSessionService questionnaireSessionService;
    private final TaskExecutor taskExecutor;
    private String questionnaireId;
    @NonNull
    private Tenant tenant = ResysSecurityConstants.DEFAULT_TENANT;
    private WebSocketSession session;
    private boolean reportStackTrace = true;

    public QuestionnaireWebSocketHandler(DialobSettings settings, QuestionnaireEventPublisher eventPublisher, ActionProcessingService actionProcessingService, ObjectMapper mapper, QuestionnaireSessionService questionnaireSessionService, TaskExecutor taskExecutor) {
        this.settings = settings.getSession().getSockjs();
        this.eventPublisher = eventPublisher;
        this.actionProcessingService = actionProcessingService;
        this.mapper = mapper;
        this.questionnaireSessionService = questionnaireSessionService;
        this.taskExecutor = taskExecutor;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.session = new ConcurrentWebSocketSessionDecorator(session, this.settings.getSendTimeLimit(), this.settings.getMaxBinaryMessageBufferSize());
        Map sessionAttributes = session.getAttributes();
        this.questionnaireId = (String)sessionAttributes.get(this.settings.getUrlAttributes().getSessionId());
        String tenantId = (String)sessionAttributes.get(this.settings.getUrlAttributes().getTenantId());
        if (tenantId != null && !this.isDefaultTenantPathPlaceholder(tenantId)) {
            this.tenant = ImmutableTenant.of((String)tenantId, Optional.empty());
        }
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)this.tenant, () -> {
            this.publishConnectionEvent();
            this.sendFullForm();
        });
    }

    protected boolean isDefaultTenantPathPlaceholder(String tenantId) {
        return "-".equals(tenantId);
    }

    protected void sendFullForm() {
        this.taskExecutor.execute(() -> {
            ImmutableActions.Builder actions = ImmutableActions.builder();
            try {
                QuestionnaireSession questionnaireSession = this.questionnaireSessionService.findOne(this.questionnaireId);
                FormActions formActions = new FormActions();
                questionnaireSession.buildFullForm((QuestionnaireSession.UpdatesCallback)new FormActionsUpdatesCallback(formActions));
                actions.actions((Iterable)formActions.getActions());
                String revision = questionnaireSession.getRevision();
                actions.rev(revision);
            }
            catch (DocumentNotFoundException e) {
                LOGGER.debug("Action QUESTIONNAIRE_NOT_FOUND: backend response '{}'", (Object)e.getMessage());
                actions.addActions((Action)ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true)).message("not found").id(this.questionnaireId).build());
            }
            catch (Exception e) {
                LOGGER.debug("Error in websocket handler", (Throwable)e);
                actions.actions(Collections.singletonList(this.createNotifyServerErrorAction(e)));
            }
            this.sendMessage((Actions)actions.build());
        });
    }

    protected void publishConnectionEvent() {
        InetAddress remoteAddress = this.resolveRealIp();
        LOGGER.info("WebSocket session '{}' from {} trying connect to '{}'", new Object[]{this.session.getId(), remoteAddress, this.questionnaireId});
        this.eventPublisher.clientConnected(this.questionnaireId, remoteAddress);
    }

    protected void publishDisconnectionEvent(CloseStatus closeStatus) {
        InetAddress remoteAddress = this.resolveRealIp();
        this.eventPublisher.clientDisconnected(StringUtils.defaultString((String)this.questionnaireId), remoteAddress, closeStatus.getCode());
        LOGGER.info("WebSocket session '{}' from {} disconnected from '{}'", new Object[]{this.session.getId(), remoteAddress, this.questionnaireId});
    }

    @Nullable
    private InetAddress resolveRealIp() {
        List realIp = this.session.getHandshakeHeaders().getValuesAsList("X-Real-IP");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("X-Real-IP {}", (Object)realIp);
            LOGGER.debug("X-Forwarded-For {}", (Object)this.session.getHandshakeHeaders().getValuesAsList("X-Forwarded-For"));
        }
        if (!realIp.isEmpty()) {
            return InetAddresses.forString((String)((String)realIp.get(0)));
        }
        List forwardFor = this.session.getHandshakeHeaders().getValuesAsList("X-Forwarded-For");
        if (!forwardFor.isEmpty()) {
            return InetAddresses.forString((String)((String)forwardFor.get(0)));
        }
        InetSocketAddress remoteAddress = this.session.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.getAddress();
        }
        return null;
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)this.tenant, () -> {
            ArrayList<Action> actionList = new ArrayList<Action>();
            String prevRev = null;
            String id = this.session.getId();
            try {
                MDC.put((String)"socketSession", (String)id);
                Actions actions = (Actions)this.mapper.readValue((String)message.getPayload(), Actions.class);
                prevRev = actions.getRev();
                List actions1 = actions.getActions();
                if (actions1 == null || actions1.isEmpty()) {
                    LOGGER.info("Resource '{}' sent empty message.", (Object)id);
                    return;
                }
                LOGGER.info("Resource '{}' sent {} action(s)", (Object)id, (Object)actions1.size());
                for (Action action2 : actions1) {
                    if (action2.getServerEvent() != null && action2.getServerEvent().booleanValue()) continue;
                    this.handleAction(this.questionnaireId, (Action)ImmutableAction.builder().from(action2).resourceId(id).build(), actions.getRev());
                }
            }
            catch (IOException e) {
                LOGGER.info("unparseable message from client {} due error {}", (Object)id, (Object)e.getMessage());
                LOGGER.debug("message payload: {}", message.getPayload());
                return;
            }
            catch (Exception e) {
                LOGGER.debug("Server side error,", (Throwable)e);
                actionList.add(this.createNotifyServerErrorAction(e));
            }
            finally {
                MDC.remove((String)"socketSession");
            }
            if (!actionList.isEmpty()) {
                ImmutableActions returnActions = ImmutableActions.builder().rev(prevRev).actions((Iterable)actionList.stream().map(action -> ImmutableAction.builder().from(action).serverEvent(Boolean.valueOf(true)).build()).collect(Collectors.toList())).build();
                this.sendMessage((Actions)returnActions);
            }
        });
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)this.tenant, () -> LOGGER.error("WebSocket transport error. " + this.session.getId(), exception));
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)this.tenant, () -> {
            LOGGER.debug("WebSocket connection closed {} status {}", (Object)this.session.getId(), (Object)closeStatus);
            this.publishDisconnectionEvent(closeStatus);
            this.session = null;
        });
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    @NonNull
    public Actions answerQuestion(@NonNull String questionnaireId, String revision, @NonNull List<Action> actions) {
        return this.actionProcessingService.answerQuestion(questionnaireId, revision, actions);
    }

    public void onQuestionnaireActionsEvent(QuestionnaireActionsEvent event) {
        if (this.isForThisHandler((QuestionnaireEvent)event)) {
            try {
                Actions actions = event.getActions();
                List filteredActions = actions.getActions().stream().filter(action -> !this.session.getId().equals(action.getResourceId())).collect(Collectors.toList());
                this.sendMessage((Actions)ImmutableActions.builder().from(actions).actions(filteredActions).build());
            }
            catch (SockJsTransportFailureException transportFailureException) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Unexpected client disconnect detected", (Throwable)transportFailureException);
                }
                LOGGER.info("Unexpected client disconnect detected");
            }
        }
    }

    private Action createNotifyServerErrorAction(Exception e) {
        ImmutableAction.Builder action = ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true));
        if (this.reportStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            action.message(e.getMessage());
            action.trace(sw.toString());
        }
        return action.build();
    }

    public void onQuestionnaireCompletedEvent(QuestionnaireCompletedEvent event) {
        if (this.isForThisHandler((QuestionnaireEvent)event)) {
            this.sendMessage((Actions)ImmutableActions.builder().addActions((Action)ImmutableAction.builder().type(Action.Type.COMPLETE).id(event.getQuestionnaireId()).serverEvent(Boolean.valueOf(true)).build()).build());
        }
    }

    private void sendMessage(Actions actions) {
        TextMessage message = null;
        try {
            message = new TextMessage((CharSequence)this.mapper.writeValueAsString((Object)actions));
            if (this.sessionIsClosed()) {
                return;
            }
            this.session.sendMessage((WebSocketMessage)message);
        }
        catch (IOException e) {
            LOGGER.info("unparseable message from client {} due error {}", (Object)this.session.getId(), (Object)e.getMessage());
            LOGGER.debug("message payload: {}", message != null ? message.getPayload() : actions);
            return;
        }
    }

    protected boolean isForThisHandler(QuestionnaireEvent event) {
        return this.questionnaireId != null && this.questionnaireId.equals(event.getQuestionnaireId());
    }

    protected boolean sessionIsClosed() {
        if (this.session == null || !this.session.isOpen()) {
            LOGGER.debug("Dangling socket handler... trying to unsubscribe");
            this.questionnaireId = null;
            return true;
        }
        return false;
    }
}

