/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import io.dialob.questionnaire.service.api.event.QuestionnaireActionsEvent;
import io.dialob.questionnaire.service.api.event.QuestionnaireCompletedEvent;
import io.dialob.questionnaire.service.sockjs.QuestionnaireEventsHandler;
import io.dialob.questionnaire.service.sockjs.QuestionnaireWebSocketHandler;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.noop.NoopCounter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.BeanCreatingHandlerProvider;

public class PerQuestionnaireConnectionWebSocketHandler
implements WebSocketHandler,
BeanFactoryAware,
HealthIndicator,
QuestionnaireEventsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerQuestionnaireConnectionWebSocketHandler.class);
    public static final String CONNECTIONS_METRIC_NAME = "questionnaire.websocket.connections";
    private final BeanCreatingHandlerProvider<QuestionnaireWebSocketHandler> provider;
    private final Map<WebSocketSession, QuestionnaireWebSocketHandler> handlers = new ConcurrentHashMap<WebSocketSession, QuestionnaireWebSocketHandler>();
    private final boolean supportsPartialMessages;
    private final Counter connectionsCounter;

    public PerQuestionnaireConnectionWebSocketHandler(Optional<MeterRegistry> meterRegistry) {
        this(QuestionnaireWebSocketHandler.class, false, meterRegistry);
    }

    public PerQuestionnaireConnectionWebSocketHandler(Class<QuestionnaireWebSocketHandler> handlerType, boolean supportsPartialMessages, Optional<MeterRegistry> meterRegistry) {
        this.connectionsCounter = meterRegistry.map(mr -> Counter.builder((String)CONNECTIONS_METRIC_NAME).register(mr)).orElseGet(() -> new NoopCounter(null));
        this.provider = new BeanCreatingHandlerProvider(handlerType);
        this.supportsPartialMessages = supportsPartialMessages;
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) {
        this.provider.setBeanFactory(beanFactory);
    }

    public void afterConnectionEstablished(@NonNull WebSocketSession session) throws Exception {
        QuestionnaireWebSocketHandler handler = (QuestionnaireWebSocketHandler)((Object)this.provider.getHandler());
        this.handlers.put(session, handler);
        this.connectionsCounter.increment();
        handler.afterConnectionEstablished(session);
    }

    public void handleMessage(@NonNull WebSocketSession session, @NonNull WebSocketMessage<?> message) throws Exception {
        this.getHandler(session).handleMessage(session, message);
    }

    private QuestionnaireWebSocketHandler getHandler(WebSocketSession session) {
        QuestionnaireWebSocketHandler handler = this.handlers.get(session);
        Assert.isTrue((handler != null ? 1 : 0) != 0, (String)("WebSocketHandler not found for " + session));
        return handler;
    }

    public void handleTransportError(@NonNull WebSocketSession session, @NonNull Throwable exception) throws Exception {
        this.getHandler(session).handleTransportError(session, exception);
    }

    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus closeStatus) throws Exception {
        LOGGER.debug("afterConnectionClosed(\"{}\",{})", (Object)session.getId(), (Object)closeStatus);
        try {
            this.getHandler(session).afterConnectionClosed(session, closeStatus);
        }
        finally {
            this.destroy(session);
        }
    }

    public boolean supportsPartialMessages() {
        return this.supportsPartialMessages;
    }

    private void destroy(WebSocketSession session) {
        QuestionnaireWebSocketHandler handler = this.handlers.remove(session);
        this.connectionsCounter.increment(-1.0);
        try {
            if (handler != null) {
                this.provider.destroy((Object)handler);
            }
        }
        catch (Exception t) {
            LOGGER.warn("Error while destroying " + handler, (Throwable)t);
        }
    }

    public String toString() {
        return "PerConnectionWebSocketHandlerProxy[handlerType=" + this.provider.getHandlerType() + "]";
    }

    @Override
    public void onQuestionnaireActionsEvent(QuestionnaireActionsEvent event) {
        this.handlers.values().forEach(handler -> handler.onQuestionnaireActionsEvent(event));
    }

    @Override
    public void onQuestionnaireCompletedEvent(QuestionnaireCompletedEvent event) {
        this.handlers.values().forEach(handler -> handler.onQuestionnaireCompletedEvent(event));
    }

    public Health health() {
        return Health.up().build();
    }
}

