/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class WebSocketRequestTestTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketRequestTestTemplate.class);
    private final String uri;
    private final String jsessionid;
    protected String revision;
    protected WebSocketSession webSocketSession;
    protected WebSocketHandler webSocketHandler;
    protected SockJsClient sockJsClient;
    protected ObjectMapper objectMapper;
    protected List<String> websocketMessages = new ArrayList<String>();
    private List<WhenMessage> steps = new ArrayList<WhenMessage>();
    private FinalAssert assertConsumer;

    public WebSocketRequestTestTemplate(ObjectMapper objectMapper, String uri, String jsessionid) {
        this.objectMapper = objectMapper;
        this.uri = uri;
        this.jsessionid = jsessionid;
    }

    public void openSession() throws Exception {
        if (this.webSocketSession == null) {
            StandardWebSocketClient standardWebSocketClient = new StandardWebSocketClient();
            ArrayList<WebSocketTransport> transports = new ArrayList<WebSocketTransport>();
            WebSocketTransport transport = new WebSocketTransport((WebSocketClient)standardWebSocketClient);
            transports.add(transport);
            this.sockJsClient = new SockJsClient(transports);
            WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
            if (this.jsessionid != null) {
                headers.add("Cookie", this.jsessionid);
            }
            ListenableFuture listenableFuture = this.sockJsClient.doHandshake(this.webSocketHandler, headers, new URI(this.uri));
            Assertions.assertFalse((boolean)listenableFuture.isDone());
            this.webSocketSession = (WebSocketSession)listenableFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertTrue((boolean)listenableFuture.isDone());
            Assertions.assertNotNull((Object)this.webSocketSession.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        final AtomicReference<Object> activeStep = new AtomicReference<Object>(null);
        final AtomicBoolean handlerFailed = new AtomicBoolean(false);
        Iterator<WhenMessage> whenMessageIterator = this.steps.iterator();
        this.webSocketHandler = (WebSocketHandler)Mockito.spy((Object)new WebSocketHandler(){

            public void afterConnectionEstablished(WebSocketSession session) throws Exception {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
                WebSocketRequestTestTemplate.this.websocketMessages.add("<-- " + message.getPayload());
                AtomicReference atomicReference = activeStep;
                synchronized (atomicReference) {
                    WhenMessage step = (WhenMessage)activeStep.get();
                    if (step == null) {
                        LOGGER.error("Unexpected message {}", message.getPayload());
                        handlerFailed.set(true);
                        return;
                    }
                    Expectations expectations = step.getExpectations();
                    expectations.accept(message);
                    if (expectations.isCompleted()) {
                        if (expectations.isSuccess()) {
                            activeStep.compareAndSet(step, null);
                        } else {
                            LOGGER.error("Failed expectations {}", (Object)expectations);
                        }
                        activeStep.notifyAll();
                    }
                }
            }

            public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
            }

            public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
            }

            public boolean supportsPartialMessages() {
                return false;
            }
        });
        try {
            while (whenMessageIterator.hasNext()) {
                AtomicReference<Object> atomicReference = activeStep;
                synchronized (atomicReference) {
                    WhenMessage whenMessage = whenMessageIterator.next();
                    LOGGER.info("Step \"{}\"", (Object)whenMessage.getName());
                    boolean activeStepClear = activeStep.compareAndSet(null, whenMessage);
                    if (!activeStepClear) {
                        LOGGER.error("Active step wasn't' clear..");
                    }
                    whenMessage.accept(this.webSocketSession);
                    activeStep.wait(60000L);
                    if (activeStep.get() != null) {
                        LOGGER.error("Timed out!");
                    } else if (whenMessage.getDelay() != null) {
                        Thread.sleep(whenMessage.getDelay());
                    }
                }
                Assertions.assertFalse((boolean)handlerFailed.get());
                if (activeStep.get() == null) continue;
                LOGGER.error("{}", (Object)((WhenMessage)activeStep.get()).getExpectations());
                Assertions.fail((String)("Could not complete step '" + ((WhenMessage)activeStep.get()).getName() + "'"));
            }
            if (this.assertConsumer != null) {
                this.assertConsumer.accept(this.webSocketHandler);
            }
            Assertions.assertFalse((boolean)handlerFailed.get());
        }
        catch (Error e) {
            this.websocketMessages.forEach(System.err::println);
            throw e;
        }
        finally {
            if (this.webSocketSession != null) {
                this.webSocketSession.close();
            }
            if (this.sockJsClient != null) {
                this.sockJsClient.stop();
            }
        }
        return true;
    }

    public StepsBuilder steps() {
        return new StepsBuilder();
    }

    private class OrderedExpectations
    implements Expectations {
        private Deque<Expectation> expectations = new ArrayDeque<Expectation>();
        private List<Expectation> failed = new ArrayList<Expectation>();
        private List<Expectation> succeeded = new ArrayList<Expectation>();
        private List<Expectation> accepted = new ArrayList<Expectation>();

        private OrderedExpectations() {
        }

        @Override
        public void accept(WebSocketMessage message) throws Exception {
            Expectation expectation = this.expectations.pop();
            try {
                expectation.accept(message);
                this.succeeded.add(expectation);
            }
            catch (Throwable throwable) {
                this.failed.add(expectation);
            }
        }

        @Override
        public boolean isSuccess() {
            return this.failed.isEmpty();
        }

        @Override
        public boolean isCompleted() {
            return this.expectations.isEmpty();
        }

        @Override
        public void addExpect(String name, Expectation expectation) {
            if (name != null) {
                expectation = new NamedExpectation(name, expectation);
            }
            this.expectations.add(expectation);
        }

        @Override
        public void addAccept(String name, Expectation expectConsumer) {
            this.accepted.add(expectConsumer);
        }
    }

    private class OutOfOrderExpectations
    implements Expectations {
        private List<Expectation> expectations = new ArrayList<Expectation>();
        private List<Expectation> accepted = new ArrayList<Expectation>();
        private List<String> unexpected = new ArrayList<String>();

        private OutOfOrderExpectations() {
        }

        @Override
        public void accept(WebSocketMessage message) throws Exception {
            Expectation expectation;
            Iterator<Expectation> i = this.expectations.iterator();
            ArrayList<AssertionError> assertionErrors = new ArrayList<AssertionError>();
            while (i.hasNext()) {
                expectation = i.next();
                try {
                    expectation.accept(message);
                    i.remove();
                    return;
                }
                catch (AssertionError error) {
                    assertionErrors.add(error);
                }
                finally {
                }
            }
            i = this.accepted.iterator();
            while (i.hasNext()) {
                expectation = i.next();
                try {
                    expectation.accept(message);
                    i.remove();
                    return;
                }
                catch (AssertionError error) {
                    assertionErrors.add(error);
                }
                finally {
                }
            }
            if (!assertionErrors.isEmpty()) {
                LOGGER.error("Assertions failed\n{}", assertionErrors);
            }
            this.unexpected.add((String)((TextMessage)message).getPayload());
        }

        @Override
        public boolean isCompleted() {
            return this.expectations.isEmpty() || !this.unexpected.isEmpty();
        }

        @Override
        public boolean isSuccess() {
            return this.expectations.isEmpty() && this.unexpected.isEmpty();
        }

        @Override
        public void addExpect(String name, Expectation expectation) {
            if (name != null) {
                expectation = new NamedExpectation(name, expectation);
            }
            this.expectations.add(expectation);
        }

        @Override
        public void addAccept(String name, Expectation expectConsumer) {
            this.accepted.add(expectConsumer);
        }

        public String toString() {
            return "Unexpected messages: " + this.unexpected + "\nUnsatisfied expectations: " + this.expectations;
        }
    }

    public static interface FinalAssert {
        public void accept(WebSocketHandler var1) throws Exception;
    }

    public class ExpectionBuilder {
        private StepsBuilder stepsBuilder;

        public ExpectionBuilder(StepsBuilder stepsBuilder) {
            this.stepsBuilder = stepsBuilder;
        }

        public ExpectionBuilder expect(String name, Expectation expectConsumer) {
            WhenMessage whenMessage = this.stepsBuilder.getWhenMessage();
            whenMessage.getExpectations().addExpect(name, expectConsumer);
            return this;
        }

        public ExpectionBuilder accept(String name, Expectation expectConsumer) {
            WhenMessage whenMessage = this.stepsBuilder.getWhenMessage();
            whenMessage.getExpectations().addAccept(name, expectConsumer);
            return this;
        }

        public ExpectionBuilder expectActions(Consumer<Actions> expectConsumer) {
            return this.expectActions("expectActions", expectConsumer);
        }

        public ExpectionBuilder expectActions(String name, Consumer<Actions> expectConsumer) {
            return this.expect(name, webSocketMessage -> {
                TextMessage textMessage = (TextMessage)webSocketMessage;
                Actions actions = null;
                try {
                    String message = (String)textMessage.getPayload();
                    actions = (Actions)WebSocketRequestTestTemplate.this.objectMapper.readValue(message, Actions.class);
                    WebSocketRequestTestTemplate.this.revision = actions.getRev();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                expectConsumer.accept(actions);
            });
        }

        public ExpectionBuilder expectActivated() {
            return this;
        }

        public ExpectionBuilder expectPassivation() {
            return this;
        }

        public ExpectionBuilder expectRemoveAll() {
            return this.expectActions("expectPassivation", actions -> {
                Iterator i = actions.getActions().iterator();
                Action action = (Action)i.next();
                Assertions.assertEquals((Object)Action.Type.RESET, (Object)action.getType());
                Assertions.assertFalse((boolean)i.hasNext());
            });
        }

        public ExpectionBuilder expectUpdateWithoutActions() {
            return this.expectActions("expectUpdateWithoutActions", actions -> {
                if (actions.getActions() == null || actions.getActions().isEmpty()) {
                    return;
                }
                LOGGER.error("{} do not match with expectUpdateWithoutActions", (Object)actions.toString());
                Assertions.fail((String)"We didn't expect any actions, but got some.");
            });
        }

        public StepsBuilder nextAfterDelay(long after) {
            this.stepsBuilder.setDelay(after);
            return this.next();
        }

        public StepsBuilder next() {
            return this.stepsBuilder;
        }

        public boolean execute() throws Exception {
            return this.next().execute();
        }

        public WebSocketRequestTestTemplate finallyAssert(FinalAssert assertConsumer) {
            WebSocketRequestTestTemplate.this.assertConsumer = assertConsumer;
            return WebSocketRequestTestTemplate.this;
        }
    }

    public class StepsBuilder {
        private WhenMessage whenMessage;

        public ExpectionBuilder when(WhenMessage whenMessage) {
            this.whenMessage = whenMessage;
            WebSocketRequestTestTemplate.this.steps.add(this.whenMessage);
            this.whenMessage.setExpectations(new OutOfOrderExpectations());
            return new ExpectionBuilder(this);
        }

        public WhenMessage getWhenMessage() {
            return this.whenMessage;
        }

        public ExpectionBuilder when(String name, final Actions actions) {
            return this.when(new WhenMessage(name){

                @Override
                public void accept(WebSocketSession webSocketSession) throws Exception {
                    TextMessage webSockerMessage = new TextMessage((CharSequence)WebSocketRequestTestTemplate.this.objectMapper.writeValueAsString((Object)ImmutableActions.builder().from(actions).rev(WebSocketRequestTestTemplate.this.revision).build()));
                    WebSocketRequestTestTemplate.this.websocketMessages.add("--> " + (String)webSockerMessage.getPayload());
                    webSocketSession.sendMessage((WebSocketMessage)webSockerMessage);
                }
            });
        }

        public ExpectionBuilder when(String name, Action action) {
            return this.when(name, (Actions)ImmutableActions.builder().addActions(action).build());
        }

        public ExpectionBuilder answerQuestion(String questionId, String answer) {
            return this.when("answerQuestion(\"" + questionId + "\",\"" + answer + "\")", (Action)ImmutableAction.builder().type(Action.Type.ANSWER).answer((Object)answer).id(questionId).build());
        }

        public ExpectionBuilder answerQuestion(String questionId, List<String> answer) {
            return this.when("answerQuestion(\"" + questionId + "\",\"" + answer + "\")", (Action)ImmutableAction.builder().type(Action.Type.ANSWER).answer(answer).id(questionId).build());
        }

        public ExpectionBuilder setLocale(String locale) {
            return this.when("setLocale(\"" + locale + "\")", ActionsFactory.setLocale((String)locale));
        }

        public ExpectionBuilder addRow(String rowGroupId) {
            return this.when("addRow(\"" + rowGroupId + "\")", (Action)ImmutableAction.builder().type(Action.Type.ADD_ROW).id(rowGroupId).build());
        }

        public ExpectionBuilder deleteRow(String rowGroupId) {
            return this.when("deleteRow(\"" + rowGroupId + "\")", (Action)ImmutableAction.builder().type(Action.Type.DELETE_ROW).id(rowGroupId).build());
        }

        public ExpectionBuilder nextPage() {
            ImmutableAction action = ImmutableAction.builder().type(Action.Type.NEXT).build();
            return this.when("nextPage()", (Action)action);
        }

        public ExpectionBuilder prevPage() {
            return this.when("prevPage()", (Action)ImmutableAction.builder().type(Action.Type.PREVIOUS).build());
        }

        public boolean execute() throws Exception {
            return WebSocketRequestTestTemplate.this.execute();
        }

        public void setDelay(long delay) {
            this.whenMessage.setDelay(delay);
        }
    }

    public static interface Expectations
    extends Expectation {
        public boolean isCompleted();

        public boolean isSuccess();

        public void addExpect(String var1, Expectation var2);

        public void addAccept(String var1, Expectation var2);
    }

    public static class NamedExpectation
    implements Expectation {
        private final String name;
        private final Expectation delegate;

        public NamedExpectation(String name, Expectation delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void accept(WebSocketMessage message) throws Exception {
            this.delegate.accept(message);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Expectation {
        public void accept(WebSocketMessage var1) throws Exception;
    }

    public static abstract class WhenMessage {
        private final String name;
        private Long delay;
        private Expectations expectations;

        protected WhenMessage(String name) {
            this.name = name;
        }

        public abstract void accept(WebSocketSession var1) throws Exception;

        public String getName() {
            return this.name;
        }

        public void setDelay(Long delay) {
            this.delay = delay;
        }

        public Long getDelay() {
            return this.delay;
        }

        public Expectations getExpectations() {
            return this.expectations;
        }

        public void setExpectations(Expectations expectations) {
            this.expectations = expectations;
        }
    }
}

