/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class ExtractURITemplateVariablesToAttributesInterceptor
implements HandshakeInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractURITemplateVariablesToAttributesInterceptor.class);
    private final List<String> attributesToExtract = new ArrayList<String>();

    public ExtractURITemplateVariablesToAttributesInterceptor(String ... attributesToExtract) {
        this.attributesToExtract.addAll(Arrays.asList(attributesToExtract));
    }

    public boolean beforeHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest serverRequest = (ServletServerHttpRequest)request;
            HttpServletRequest servletRequest = serverRequest.getServletRequest();
            Map variables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            LOGGER.debug("variables {}", (Object)variables);
            if (variables != null) {
                for (String attribute : this.attributesToExtract) {
                    String value = (String)variables.get(attribute);
                    if (value == null) continue;
                    attributes.put(attribute, value);
                }
            }
        }
        return true;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
    }
}

