/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ImmutableActionItem;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.ActionProcessingService;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.questionnaire.service.sockjs.QuestionnaireWebSocketHandler;
import io.dialob.settings.DialobSettings;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class QuestionnaireWebSocketHandlerTest {
    @Mock
    public ActionProcessingService actionProcessingService;
    @Spy
    public ObjectMapper mapper = new ObjectMapper();
    @Spy
    public DialobSettings settings = new DialobSettings();
    @Mock
    public Clock clock;
    @Mock
    public QuestionnaireSessionService questionnaireSessionService;
    @Mock
    public TaskExecutor taskExecutor;
    @Mock
    QuestionnaireEventPublisher eventPublisher;
    @InjectMocks
    public QuestionnaireWebSocketHandler questionnaireWebSocketHandler;

    @BeforeEach
    public void reset() {
        MockitoAnnotations.initMocks((Object)this);
    }

    protected WebSocketSession mockWebSocketSessionFrom(String hostname, int port) {
        WebSocketSession webSocketSession = (WebSocketSession)Mockito.mock(WebSocketSession.class);
        Mockito.when((Object)webSocketSession.getRemoteAddress()).thenReturn((Object)new InetSocketAddress(hostname, port));
        Mockito.when((Object)webSocketSession.isOpen()).thenReturn((Object)true);
        return webSocketSession;
    }

    @Test
    public void shouldDelegateSessionInitToAsyncTask() throws Exception {
        WebSocketSession webSocketSession = this.mockWebSocketSessionFrom("localhost", 9999);
        QuestionnaireSession questionnaireSession = (QuestionnaireSession)Mockito.mock(QuestionnaireSession.class);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("sessionId", "123-321");
        Mockito.when((Object)webSocketSession.getAttributes()).thenReturn(attributes);
        HttpHeaders httpHeaders = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)webSocketSession.getHandshakeHeaders()).thenReturn((Object)httpHeaders);
        ((TaskExecutor)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0)).run();
            return null;
        }).when((Object)this.taskExecutor)).execute((Runnable)ArgumentMatchers.any());
        Mockito.when((Object)this.questionnaireSessionService.findOne("123-321")).thenReturn((Object)questionnaireSession);
        Mockito.when((Object)questionnaireSession.getRevision()).thenReturn((Object)"123");
        ((QuestionnaireSession)Mockito.doAnswer(invocation -> {
            QuestionnaireSession.UpdatesCallback callback = (QuestionnaireSession.UpdatesCallback)invocation.getArgument(0);
            ImmutableActionItem textQuestion = ImmutableActionItem.builder().type("text").id("q1").className(Collections.emptyList()).label("Question?").build();
            callback.removeAll().questionAdded((ActionItem)textQuestion);
            return null;
        }).when((Object)questionnaireSession)).buildFullForm((QuestionnaireSession.UpdatesCallback)ArgumentMatchers.any(QuestionnaireSession.UpdatesCallback.class));
        this.questionnaireWebSocketHandler.afterConnectionEstablished(webSocketSession);
        ((WebSocketSession)Mockito.verify((Object)webSocketSession, (VerificationMode)new VerificationMode(){

            public void verify(VerificationData data) {
                Assertions.assertEquals((int)7, (int)data.getAllInvocations().size());
                Assertions.assertEquals((Object)"sendMessage", (Object)((Invocation)data.getAllInvocations().get(6)).getMethod().getName());
                TextMessage textMessage = (TextMessage)((Invocation)data.getAllInvocations().get(6)).getArgument(0);
                String message = new String(textMessage.asBytes());
                Assertions.assertEquals((Object)"{\"rev\":\"123\",\"actions\":[{\"type\":\"RESET\"},{\"type\":\"ITEM\",\"item\":{\"id\":\"q1\",\"type\":\"text\",\"label\":\"Question?\"}}]}", (Object)message);
            }

            public VerificationMode description(String description) {
                return this;
            }
        })).sendMessage((WebSocketMessage)ArgumentMatchers.any(TextMessage.class));
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        ((QuestionnaireSessionService)Mockito.verify((Object)this.questionnaireSessionService)).findOne("123-321");
        ((QuestionnaireSession)Mockito.verify((Object)questionnaireSession)).getRevision();
        ((QuestionnaireSession)Mockito.verify((Object)questionnaireSession)).buildFullForm((QuestionnaireSession.UpdatesCallback)ArgumentMatchers.any(QuestionnaireSession.UpdatesCallback.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskExecutor, this.questionnaireSessionService, questionnaireSession});
    }

    @Test
    public void shouldSendQuestionnaireNotFoundMessageIfQuestionnaireIsNotFound() throws Exception {
        WebSocketSession webSocketSession = this.mockWebSocketSessionFrom("localhost", 9999);
        QuestionnaireSession questionnaireSession = (QuestionnaireSession)Mockito.mock(QuestionnaireSession.class);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("sessionId", "123-321");
        Mockito.when((Object)webSocketSession.getAttributes()).thenReturn(attributes);
        HttpHeaders httpHeaders = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)webSocketSession.getHandshakeHeaders()).thenReturn((Object)httpHeaders);
        ((TaskExecutor)Mockito.doAnswer(invocation -> {
            ((Runnable)invocation.getArgument(0)).run();
            return null;
        }).when((Object)this.taskExecutor)).execute((Runnable)ArgumentMatchers.any());
        Mockito.when((Object)this.questionnaireSessionService.findOne("123-321")).thenThrow(DocumentNotFoundException.class);
        this.questionnaireWebSocketHandler.afterConnectionEstablished(webSocketSession);
        ((WebSocketSession)Mockito.verify((Object)webSocketSession, (VerificationMode)new VerificationMode(){

            public void verify(VerificationData data) {
                Assertions.assertEquals((int)7, (int)data.getAllInvocations().size());
                Assertions.assertEquals((Object)"sendMessage", (Object)((Invocation)data.getAllInvocations().get(6)).getMethod().getName());
                TextMessage textMessage = (TextMessage)((Invocation)data.getAllInvocations().get(6)).getArgument(0);
                String message = new String(textMessage.asBytes());
                Assertions.assertEquals((Object)"{\"actions\":[{\"type\":\"SERVER_ERROR\",\"id\":\"123-321\",\"message\":\"not found\"}]}", (Object)message);
            }

            public VerificationMode description(String description) {
                return this;
            }
        })).sendMessage((WebSocketMessage)ArgumentMatchers.any(TextMessage.class));
        ((TaskExecutor)Mockito.verify((Object)this.taskExecutor)).execute((Runnable)ArgumentMatchers.any(Runnable.class));
        ((QuestionnaireSessionService)Mockito.verify((Object)this.questionnaireSessionService)).findOne("123-321");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskExecutor, this.questionnaireSessionService});
    }
}

