/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.sockjs;

import io.dialob.questionnaire.service.sockjs.ExtractURITemplateVariablesToAttributesInterceptor;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;

public class ExtractURITemplateVariablesToAttributesInterceptorTest {
    @Test
    public void shouldNotExtractAnything() throws Exception {
        ExtractURITemplateVariablesToAttributesInterceptor interceptor = new ExtractURITemplateVariablesToAttributesInterceptor(new String[0]);
        HashMap attributes = new HashMap();
        WebSocketHandler wsHandler = (WebSocketHandler)Mockito.mock(WebSocketHandler.class);
        ServletServerHttpRequest request = (ServletServerHttpRequest)Mockito.mock(ServletServerHttpRequest.class);
        ServerHttpResponse response = (ServerHttpResponse)Mockito.mock(ServerHttpResponse.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletRequest()).thenReturn((Object)httpServletRequest);
        interceptor.beforeHandshake((ServerHttpRequest)request, response, wsHandler, attributes);
        Assertions.assertTrue((boolean)attributes.isEmpty());
        ((ServletServerHttpRequest)Mockito.verify((Object)request)).getServletRequest();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, response, wsHandler});
    }

    @Test
    public void shouldExtractId() throws Exception {
        ExtractURITemplateVariablesToAttributesInterceptor interceptor = new ExtractURITemplateVariablesToAttributesInterceptor(new String[]{"id"});
        HashMap attributes = new HashMap();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "123");
        WebSocketHandler wsHandler = (WebSocketHandler)Mockito.mock(WebSocketHandler.class);
        ServletServerHttpRequest request = (ServletServerHttpRequest)Mockito.mock(ServletServerHttpRequest.class);
        ServerHttpResponse response = (ServerHttpResponse)Mockito.mock(ServerHttpResponse.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getServletRequest()).thenReturn((Object)httpServletRequest);
        Mockito.when((Object)httpServletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)).thenReturn(variables);
        interceptor.beforeHandshake((ServerHttpRequest)request, response, wsHandler, attributes);
        Assertions.assertEquals((int)1, (int)attributes.size());
        Assertions.assertEquals((Object)"123", attributes.get("id"));
        ((ServletServerHttpRequest)Mockito.verify((Object)request)).getServletRequest();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{request, response, wsHandler});
    }
}

