/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.questionnaire.service.rest;

import io.dialob.api.form.Form;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ActionsFactory;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import io.dialob.api.questionnaire.ImmutableQuestionnaireListItem;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.QuestionnaireFactory;
import io.dialob.api.questionnaire.QuestionnaireListItem;
import io.dialob.api.rest.Errors;
import io.dialob.api.rest.IdAndRevision;
import io.dialob.api.rest.ImmutableErrors;
import io.dialob.api.rest.ImmutableIdAndRevision;
import io.dialob.api.rest.ImmutableItems;
import io.dialob.api.rest.ImmutableResponse;
import io.dialob.api.rest.Items;
import io.dialob.api.rest.Response;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.questionnaire.csvserializer.CSVSerializer;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionBuilderFactory;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.questionnaire.service.rest.QuestionnairesRestService;
import io.dialob.rest.type.ApiException;
import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.user.CurrentUserProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QuestionnairesRestServiceController
implements QuestionnairesRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestionnairesRestServiceController.class);
    private final QuestionnaireSessionService questionnaireSessionService;
    private final QuestionnaireSessionSaveService questionnaireSessionSaveService;
    private final QuestionnaireSessionBuilderFactory questionnaireSessionBuilderFactory;
    private final QuestionnaireDatabase questionnaireRepository;
    private final FormDatabase formDatabase;
    private final CurrentTenant currentTenant;
    private final CurrentUserProvider currentUserProvider;
    private final CSVSerializer csvSerializer;

    public QuestionnairesRestServiceController(@NonNull QuestionnaireSessionService questionnaireSessionService, QuestionnaireSessionSaveService questionnaireSessionSaveService, @NonNull QuestionnaireSessionBuilderFactory questionnaireSessionBuilderFactory, @NonNull QuestionnaireDatabase questionnaireRepository, @NonNull FormDatabase formDatabase, @NonNull CurrentTenant currentTenant, @NonNull CurrentUserProvider currentUserProvider, @NonNull CSVSerializer csvSerializer) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.questionnaireSessionSaveService = questionnaireSessionSaveService;
        this.questionnaireSessionBuilderFactory = questionnaireSessionBuilderFactory;
        this.questionnaireRepository = questionnaireRepository;
        this.formDatabase = formDatabase;
        this.currentTenant = currentTenant;
        this.currentUserProvider = currentUserProvider;
        this.csvSerializer = csvSerializer;
    }

    @Override
    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<IdAndRevision> postQuestionnaire(@NonNull @RequestBody @Validated Questionnaire questionnaire) {
        Questionnaire.Metadata metadata = questionnaire.getMetadata();
        String formId = metadata.getFormId();
        String formRev = metadata.getFormRev();
        String owner = metadata.getOwner();
        String submitUrl = metadata.getSubmitUrl();
        String language = metadata.getLanguage();
        Questionnaire.Metadata.Status status = metadata.getStatus();
        LOGGER.debug("POST /questionnaire {formId: '{}',formRev:'{}'}", (Object)formId, (Object)formRev);
        if (!this.formDatabase.exists(this.currentTenant.getId(), formId)) {
            throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("NotExists").context("metadata.formId").error("Form do not exist").rejectedValue((Object)formId).build()).status(Integer.valueOf(HttpStatus.UNPROCESSABLE_ENTITY.value())).build());
        }
        QuestionnaireSession session = this.questionnaireSessionBuilderFactory.createQuestionnaireSessionBuilder().setCreateOnly(true).setFormId(formId).setFormRev(formRev).setCreator(this.currentUserProvider.getUserId()).setOwner(owner).setSubmitUrl(submitUrl).setContextValues(questionnaire.getContext()).setAnswers(questionnaire.getAnswers()).setLanguage(language).setStatus(status).setActiveItem(questionnaire.getActiveItem()).setValueSets(questionnaire.getValueSets()).setAdditionalProperties(metadata.getAdditionalProperties()).build();
        Questionnaire sessionQuestionnaire = session.getQuestionnaire();
        String sessionId = sessionQuestionnaire.getId();
        String rev = session.getQuestionnaire().getRev();
        if (sessionId == null) {
            throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("noSessionId").context("_id").error("No session id").build()).status(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value())).build());
        }
        LOGGER.debug("questionnaire '{}' created", (Object)sessionId);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)ImmutableIdAndRevision.builder().id(sessionId).rev(rev).build());
    }

    @Override
    @GetMapping(produces={"application/json"})
    public ResponseEntity<List<QuestionnaireListItem>> getQuestionnaires(@RequestParam(name="owner", required=false) String owner, @RequestParam(name="formId", required=false) String formId, @RequestParam(name="formName", required=false) String formName, @RequestParam(name="formTag", required=false) String formTag, @RequestParam(name="status", required=false) Questionnaire.Metadata.Status status) {
        ArrayList result = new ArrayList();
        this.questionnaireRepository.findAllMetadata(this.currentTenant.getId(), owner, formId, formName, formTag, status, row -> result.add(ImmutableQuestionnaireListItem.builder().id(row.getId()).metadata(row.getValue()).build()));
        return ResponseEntity.ok(result);
    }

    @Override
    @GetMapping(path={"{questionnaireId}"}, produces={"application/json"})
    public ResponseEntity<Questionnaire> getQuestionnaire(@PathVariable(value="questionnaireId") String questionnaireId) {
        LOGGER.debug("GET /questionnaire/{}", (Object)questionnaireId);
        return ResponseEntity.ok((Object)this.questionnaireRepository.findOne(this.currentTenant.getId(), questionnaireId));
    }

    @Override
    @DeleteMapping(path={"{questionnaireId}"}, produces={"application/json"})
    public ResponseEntity<Response> deleteQuestionnaire(@PathVariable(value="questionnaireId") String questionnaireId) {
        LOGGER.debug("DELETE /questionnaire/{}", (Object)questionnaireId);
        this.questionnaireRepository.delete(this.currentTenant.getId(), questionnaireId);
        return ResponseEntity.ok((Object)ImmutableResponse.builder().ok(Boolean.valueOf(true)).build());
    }

    @Override
    @PutMapping(path={"{questionnaireId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Questionnaire> putQuestionnaire(@PathVariable(value="questionnaireId") String questionnaireId, @RequestBody @Validated Questionnaire questionnaire) {
        return this.inSession(questionnaireId, questionnaireSession -> {
            ArrayList<Action> actions = new ArrayList<Action>();
            String activeItem = questionnaireSession.getActiveItem().orElse(null);
            if (questionnaire.getActiveItem() != null && !questionnaire.getActiveItem().equals(activeItem)) {
                actions.add(ActionsFactory.gotoPage((String)questionnaire.getActiveItem()));
            }
            actions.add(ActionsFactory.removeAnswers());
            questionnaire.getAnswers().forEach(answer -> actions.add(ActionsFactory.answer((String)answer.getId(), (Object)answer.getValue())));
            questionnaire.getContext().forEach(answer -> actions.add(ActionsFactory.setValue((String)answer.getId(), (Object)answer.getValue())));
            if (questionnaire.getMetadata().getStatus() == Questionnaire.Metadata.Status.COMPLETED) {
                actions.add(ActionsFactory.complete((String)questionnaire.getId()));
            }
            Questionnaire updatedQuestionnaire = this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, (Collection<Action>)actions).getQuestionnaire();
            return ResponseEntity.ok((Object)updatedQuestionnaire);
        });
    }

    @Override
    @GetMapping(path={"{questionnaireId}/status"}, produces={"application/json"})
    public ResponseEntity<Questionnaire.Metadata.Status> getQuestionnaireStatus(@PathVariable(value="questionnaireId") String questionnaireId) {
        return this.inSession(questionnaireId, questionnaireSession -> ResponseEntity.ok((Object)questionnaireSession.getStatus()));
    }

    @Override
    @PutMapping(path={"{questionnaireId}/status"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Questionnaire.Metadata.Status> putQuestionnaireStatus(@PathVariable(value="questionnaireId") String questionnaireId, @RequestBody Questionnaire.Metadata.Status status) {
        return this.inSession(questionnaireId, questionnaireSession -> {
            if (status == Questionnaire.Metadata.Status.COMPLETED) {
                this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, (Collection<Action>)Collections.singletonList(ActionsFactory.complete((String)questionnaireId)));
            }
            return ResponseEntity.ok((Object)questionnaireSession.getStatus());
        });
    }

    @Override
    @GetMapping(path={"{questionnaireId}/answers"}, produces={"application/json"})
    public ResponseEntity<List<Answer>> getQuestionnaireAnswers(@PathVariable(value="questionnaireId") String questionnaireId) {
        LOGGER.debug("GET /questionnaires/{}/answers", (Object)questionnaireId);
        return this.inSession(questionnaireId, questionnaireSession -> ResponseEntity.ok((Object)questionnaireSession.getAnswers()));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/errors"}, produces={"application/json"})
    public ResponseEntity<List<Error>> getQuestionnaireErrors(@PathVariable(value="questionnaireId") String questionnaireId) {
        LOGGER.debug("GET /questionnaires/{}/errors", (Object)questionnaireId);
        return this.inSession(questionnaireId, questionnaireSession -> ResponseEntity.ok((Object)questionnaireSession.getErrors()));
    }

    @Override
    @PostMapping(path={"{questionnaireId}/answers"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Error>> putQuestionnaireAnswers(@PathVariable(value="questionnaireId") String questionnaireId, @RequestBody List<Answer> answers) {
        return this.inSession(questionnaireId, questionnaireSession -> {
            this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, answers.stream().map(answer -> ActionsFactory.answer((String)answer.getId(), (Object)answer.getValue())).collect(Collectors.toList()));
            return ResponseEntity.ok((Object)questionnaireSession.getErrors());
        });
    }

    @Override
    @PutMapping(path={"{questionnaireId}/answers/{answerId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<Error>> putQuestionnaireAnswer(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="answerId") String answerId, @RequestBody Object answer) {
        if (!this.isValidAnswerValue(answer)) {
            return ResponseEntity.badRequest().body(Collections.singletonList(ImmutableError.builder().id(answerId).code("invalid_answer").description("Cannot handle answer data").build()));
        }
        if (answer instanceof List) {
            answer = ((List)answer).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return this.putQuestionnaireAnswers(questionnaireId, Collections.singletonList(QuestionnaireFactory.answer((String)answerId, (Object)answer)));
    }

    boolean isValidAnswerValue(Object answer) {
        if (answer == null || answer instanceof BigDecimal || answer instanceof BigInteger || answer instanceof Integer || answer instanceof Long || answer instanceof Double || answer instanceof Boolean || answer instanceof String) {
            return true;
        }
        if (answer instanceof List) {
            List list = (List)answer;
            return list.stream().map(i -> i == null || i instanceof String).reduce(Boolean.TRUE, (a, i) -> a != false && i != false);
        }
        return false;
    }

    @Override
    @DeleteMapping(path={"{questionnaireId}/answers/{answerId}"}, produces={"application/json"})
    public ResponseEntity<List<Error>> deleteQuestionnaireAnswer(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="answerId") String answerId) {
        return this.putQuestionnaireAnswers(questionnaireId, Collections.singletonList(QuestionnaireFactory.answer((String)answerId, null)));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/pages"}, produces={"application/json"})
    public ResponseEntity<Items> getQuestionnairePages(@PathVariable(value="questionnaireId") String questionnaireId) {
        return this.inSession(questionnaireId, questionnaireSession -> questionnaireSession.getItemById("questionnaire").map(question -> {
            ImmutableItems.Builder builder = ImmutableItems.builder();
            if (question.getItems() != null) {
                builder = builder.items((Iterable)question.getItems());
            }
            if (question.getAvailableItems() != null) {
                builder = builder.availableItems((Iterable)question.getAvailableItems());
            }
            if (question.getActiveItem() != null) {
                builder = builder.activeItem(question.getActiveItem());
            }
            return builder.build();
        }).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build()));
    }

    @Override
    @PutMapping(path={"{questionnaireId}/pages"}, produces={"application/json"})
    public ResponseEntity<Items> putQuestionnairePages(@NonNull @PathVariable(value="questionnaireId") String questionnaireId, @RequestBody Items pages) {
        return this.inSession(questionnaireId, questionnaireSession -> {
            String activeItem = pages.getActiveItem();
            if (!questionnaireSession.getActiveItem().filter(sessionActiveItem -> sessionActiveItem.equals(activeItem)).isPresent()) {
                this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, (Collection<Action>)Collections.singletonList(ActionsFactory.gotoPage((String)activeItem)));
                return questionnaireSession.getItemById("questionnaire").map(question -> {
                    ImmutableItems.Builder builder = ImmutableItems.builder();
                    if (question.getItems() != null) {
                        builder = builder.items((Iterable)question.getItems());
                    }
                    if (question.getAvailableItems() != null) {
                        builder = builder.availableItems((Iterable)question.getAvailableItems());
                    }
                    if (question.getActiveItem() != null) {
                        builder = builder.activeItem(question.getActiveItem());
                    }
                    return builder.build();
                }).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
            }
            return ResponseEntity.notFound().build();
        });
    }

    @Override
    @GetMapping(path={"{questionnaireId}/items"}, produces={"application/json"})
    public ResponseEntity<List<ActionItem>> getQuestionnaireItems(@PathVariable(value="questionnaireId") String questionnaireId) {
        return this.inSession(questionnaireId, questionnaireSession -> ResponseEntity.ok((Object)questionnaireSession.getItems()));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/items/{itemId}"}, produces={"application/json"})
    public ResponseEntity<ActionItem> getQuestionnaireItem(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="itemId") String itemId) {
        return this.inSession(questionnaireId, questionnaireSession -> questionnaireSession.getItemById(itemId).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build()));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/items/{itemId}/rows"}, produces={"application/json"})
    public ResponseEntity<List<String>> getQuestionnaireItemRows(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="itemId") String itemId) {
        return this.inSession(questionnaireId, questionnaireSession -> questionnaireSession.getItemById(itemId).map(this::selectRowgroup).map(ActionItem::getItems).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build()));
    }

    @Nullable
    private ActionItem selectRowgroup(ActionItem question) {
        if (question.getType().equals("rowgroup")) {
            return question;
        }
        return null;
    }

    @Override
    @PostMapping(path={"{questionnaireId}/items/{itemId}/rows"}, produces={"application/json"})
    public ResponseEntity<List<String>> postQuestionnaireItemRow(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="itemId") String itemId) {
        return this.inSession(questionnaireId, questionnaireSession -> this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, (Collection<Action>)Collections.singletonList(ActionsFactory.addRow((String)itemId))).getItemById(itemId).map(this::selectRowgroup).map(ActionItem::getItems).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @Override
    @DeleteMapping(path={"{questionnaireId}/items/{itemId}/rows/{rowId}"}, produces={"application/json"})
    public ResponseEntity<List<String>> deleteQuestionnaireItemRow(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="itemId") String itemId, @PathVariable(value="rowId") String rowId) {
        return this.inSession(questionnaireId, questionnaireSession -> questionnaireSession.getItemById(itemId).map(this::selectRowgroup).map(ActionItem::getItems).map(items -> items.contains(rowId) ? items : null).flatMap(items -> this.updateQuestionnaire((QuestionnaireSession)questionnaireSession, (Collection<Action>)Collections.singletonList(ActionsFactory.deleteRow((String)rowId))).getItemById(itemId).map(this::selectRowgroup).map(ActionItem::getItems)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build()));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/valueSets"}, produces={"application/json"})
    public ResponseEntity<List<ValueSet>> getQuestionnaireValueSets(@PathVariable(value="questionnaireId") String questionnaireId) {
        return this.inSession(questionnaireId, questionnaireSession -> ResponseEntity.ok((Object)questionnaireSession.getValueSets()));
    }

    @Override
    @GetMapping(path={"{questionnaireId}/valueSets/{valueSetId}"}, produces={"application/json"})
    public ResponseEntity<ValueSet> getQuestionnaireValueSet(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="valueSetId") String valueSetId) {
        return this.inSession(questionnaireId, questionnaireSession -> questionnaireSession.getValueSets().stream().filter(valueSet1 -> valueSet1.getId().equals(valueSetId)).findFirst().map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build()));
    }

    protected QuestionnaireSession updateQuestionnaire(QuestionnaireSession questionnaireSession, Collection<Action> actions) {
        if (questionnaireSession.getStatus() != Questionnaire.Metadata.Status.COMPLETED) {
            questionnaireSession.dispatchActions(actions);
            questionnaireSession = this.questionnaireSessionSaveService.save(questionnaireSession);
        }
        return questionnaireSession;
    }

    protected <R> R inSession(String questionnaireId, Function<QuestionnaireSession, R> operation) {
        QuestionnaireSession questionnaireSession = this.questionnaireSessionService.findOne(questionnaireId);
        return operation.apply(questionnaireSession);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponseEntity<String> getCsv(Optional<String> formId, Optional<String> formName, Optional<String> formTag, Optional<List<String>> questionnaires, Optional<String> language, Optional<LocalDateTime> startDate, Optional<LocalDateTime> endDate) {
        Form form;
        ArrayList questionnaireMetadataList = new ArrayList();
        if (questionnaires.isPresent()) {
            questionnaires.ifPresent(q -> q.stream().map(qId -> this.questionnaireRepository.findMetadata(this.currentTenant.getId(), qId)).filter(metadataRow -> metadataRow.getValue().getStatus().equals((Object)Questionnaire.Metadata.Status.COMPLETED)).forEach(questionnaireMetadataList::add));
            String seenFormId = null;
            for (QuestionnaireDatabase.MetadataRow metadataRow : questionnaireMetadataList) {
                Questionnaire.Metadata metadata2 = metadataRow.getValue();
                if (seenFormId == null) {
                    seenFormId = metadata2.getFormId();
                }
                if (seenFormId.equals(metadata2.getFormId())) continue;
                throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("NotSameForm").context("metadata.formId").error("Requested sessions don't have same form ID").rejectedValue((Object)metadata2.getFormId()).build()).status(Integer.valueOf(HttpStatus.BAD_REQUEST.value())).build());
            }
            if (seenFormId == null) throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("not_found").context("metadata.formId").error("Could not find form").build()).status(Integer.valueOf(HttpStatus.NOT_FOUND.value())).build());
            form = this.formDatabase.findOne(this.currentTenant.getId(), seenFormId);
        } else {
            if (formId.isPresent()) {
                form = this.formDatabase.findOne(this.currentTenant.getId(), formId.get());
            } else {
                if (!formName.isPresent() && !formTag.isPresent()) {
                    throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("formNameNotSet").context("").error("Form name and tag or form ID is not set").build()).status(Integer.valueOf(HttpStatus.BAD_REQUEST.value())).build());
                }
                form = this.formDatabase.findOne(this.currentTenant.getId(), formName.get(), formTag.get());
            }
            this.questionnaireRepository.findAllMetadata(this.currentTenant.getId(), null, (String)formId.orElse(null), (String)formName.orElse(null), (String)formTag.orElse(null), Questionnaire.Metadata.Status.COMPLETED, metadata -> {
                if (startDate.isPresent() && ((LocalDateTime)startDate.get()).isAfter(metadata.getValue().getLastAnswer().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime())) {
                    return;
                }
                if (endDate.isPresent() && ((LocalDateTime)endDate.get()).isBefore(metadata.getValue().getLastAnswer().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime())) {
                    return;
                }
                questionnaireMetadataList.add(metadata);
            });
            if (questionnaireMetadataList.isEmpty()) {
                throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("noSessionsFound").context("").error("No sessions found with given criteria").build()).status(Integer.valueOf(HttpStatus.NOT_FOUND.value())).build());
            }
        }
        try {
            String csv = this.csvSerializer.serializeQuestionnaires((String[])questionnaireMetadataList.stream().map(md -> md.getId()).toArray(String[]::new), form, language.orElse("en"));
            return ResponseEntity.ok().contentType(MediaType.valueOf((String)"text/csv")).body((Object)csv);
        }
        catch (IOException e) {
            LOGGER.error("CSV Export failed", (Throwable)e);
            throw new ApiException((Errors)ImmutableErrors.builder().addErrors((Errors.Error)ImmutableErrors.Error.builder().code("CSVExportFailed").context("exception").error(e.getMessage()).build()).status(Integer.valueOf(HttpStatus.BAD_REQUEST.value())).build());
        }
    }
}

